/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.keyboard.actions;

import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.KeyStroke;
import org.tn5250j.SessionPanel;
import org.tn5250j.keyboard.KeyMapper;
import org.tn5250j.keyboard.KeyMnemonic;
import org.tn5250j.keyboard.actions.EmulatorAction;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

public class PasteAction
extends EmulatorAction {
    private static final long serialVersionUID = 1L;
    private final TN5250jLogger log = TN5250jLogFactory.getLogger(this.getClass());

    public PasteAction(SessionPanel session, KeyMapper keyMap) {
        super(session, KeyMnemonic.PASTE.mnemonic, KeyStroke.getKeyStroke(86, 8), keyMap);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        try {
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable transferable = cb.getContents(this);
            if (transferable != null) {
                String content = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                this.session.getScreen().pasteText(content, false);
            }
        }
        catch (HeadlessException e1) {
            this.log.debug("HeadlessException", e1);
        }
        catch (UnsupportedFlavorException e1) {
            this.log.debug("the requested data flavor is not supported", e1);
        }
        catch (IOException e1) {
            this.log.debug("data is no longer available in the requested flavor", e1);
        }
    }
}

