/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.keyboard.configure;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.text.CollationKey;
import java.text.Collator;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.tn5250j.encoding.ICodePage;
import org.tn5250j.keyboard.KeyMapper;
import org.tn5250j.keyboard.KeyMnemonicResolver;
import org.tn5250j.keyboard.configure.KeyGetter;
import org.tn5250j.keyboard.configure.KeyGetterInterface;
import org.tn5250j.scripting.InterpreterDriverManager;
import org.tn5250j.tools.AlignLayout;
import org.tn5250j.tools.LangTool;
import org.tn5250j.tools.system.OperatingSystem;

public class KeyConfigure
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -421661235666776519L;
    private final KeyMnemonicResolver keyMnemonicResolver = new KeyMnemonicResolver();
    private JPanel keyPanel = new JPanel();
    private JPanel options = new JPanel();
    private JTextArea strokeDesc = new JTextArea();
    private JTextArea strokeDescAlt = new JTextArea();
    private JLabel strokeLocation = new JLabel();
    private JLabel strokeLocationAlt = new JLabel();
    private JList functions;
    private JDialog dialog;
    private boolean mods;
    private String[] macrosList;
    private DefaultListModel lm = new DefaultListModel();
    private boolean macros;
    private boolean special;
    private ICodePage codePage;
    private boolean isLinux;
    private boolean isAltGr;
    private boolean altKey;
    private static final SortedMap<Integer, String> colorMap = new TreeMap<Integer, String>();

    public KeyConfigure(Frame parent, String[] macros, ICodePage cp) {
        super(parent);
        this.codePage = cp;
        this.macrosList = macros;
        if (OperatingSystem.isUnix() && !OperatingSystem.isMacOS()) {
            this.isLinux = true;
        }
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        BorderLayout borderLayout = new BorderLayout();
        KeyMapper.init();
        this.keyPanel.setLayout(borderLayout);
        this.keyPanel.add((Component)this.createFunctionsPanel(), "West");
        this.keyPanel.add((Component)this.createMappingPanel(), "Center");
        this.getContentPane().add((Component)this.keyPanel, "Center");
        this.getContentPane().add((Component)this.options, "South");
        this.addOptButton(LangTool.getString("key.labelDone", "Done"), "DONE", this.options, true);
        this.setModal(true);
        this.setTitle(LangTool.getString("key.title"));
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        this.setVisible(true);
    }

    private JPanel createFunctionsPanel() {
        this.functions = new JList(this.lm);
        this.functions.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent lse) {
                if (!lse.getValueIsAdjusting()) {
                    KeyConfigure.this.setKeyDescription(KeyConfigure.this.functions.getSelectedIndex());
                }
            }
        });
        this.loadList(LangTool.getString("key.labelKeys"));
        this.functions.setSelectionMode(0);
        JScrollPane functionsScroll = new JScrollPane(this.functions);
        JPanel fp = new JPanel();
        JComboBox<String> whichKeys = new JComboBox<String>();
        whichKeys.addItem(LangTool.getString("key.labelKeys"));
        whichKeys.addItem(LangTool.getString("key.labelMacros"));
        whichKeys.addItem(LangTool.getString("key.labelSpecial"));
        whichKeys.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                KeyConfigure.this.loadList((String)cb.getSelectedItem());
            }
        });
        fp.setBorder(BorderFactory.createTitledBorder(LangTool.getString("key.labelDesc")));
        fp.setLayout(new BoxLayout(fp, 1));
        fp.add(whichKeys);
        fp.add(functionsScroll);
        return fp;
    }

    private JPanel createMappingPanel() {
        this.strokeDesc.setColumns(30);
        this.strokeDesc.setBackground(this.functions.getBackground());
        this.strokeDesc.setEditable(false);
        this.strokeDescAlt.setColumns(30);
        this.strokeDescAlt.setBackground(this.functions.getBackground());
        this.strokeDescAlt.setEditable(false);
        JPanel dp = new JPanel();
        dp.setBorder(BorderFactory.createTitledBorder(LangTool.getString("key.labelMapTo")));
        dp.setLayout(new BoxLayout(dp, 1));
        JPanel primeKeyMapPanel = new JPanel();
        primeKeyMapPanel.setLayout(new BorderLayout());
        JPanel primeKeyPanel = new JPanel();
        primeKeyPanel.setLayout(new AlignLayout(3, 5, 5));
        primeKeyPanel.add(this.strokeDesc);
        this.addOptButton(LangTool.getString("key.labelMap", "Map Key"), "MAP-Prime", primeKeyPanel, true);
        this.addOptButton(LangTool.getString("key.labelRemove", "Remove"), "REMOVE-Prime", primeKeyPanel, true);
        primeKeyMapPanel.add((Component)primeKeyPanel, "North");
        JPanel loc1 = new JPanel();
        loc1.setLayout(new BorderLayout());
        loc1.add((Component)this.strokeLocation, "North");
        primeKeyMapPanel.add((Component)loc1, "Center");
        JPanel altKeyMapPanel = new JPanel();
        altKeyMapPanel.setLayout(new BorderLayout());
        JPanel altKeyPanel = new JPanel();
        altKeyPanel.setLayout(new AlignLayout(3, 5, 5));
        altKeyPanel.add(this.strokeDescAlt);
        this.addOptButton(LangTool.getString("key.labelMap", "Map Key"), "MAP-Alt", altKeyPanel, true);
        this.addOptButton(LangTool.getString("key.labelRemove", "Remove"), "REMOVE-Alt", altKeyPanel, true);
        altKeyMapPanel.add((Component)altKeyPanel, "North");
        JPanel locAlt = new JPanel();
        locAlt.setLayout(new BorderLayout());
        locAlt.add((Component)this.strokeLocationAlt, "North");
        altKeyMapPanel.add((Component)locAlt, "Center");
        dp.add(primeKeyMapPanel);
        dp.add(altKeyMapPanel);
        return dp;
    }

    private void setKeyDescription(int index) {
        try {
            if (!this.macros && !this.special) {
                KeyDescription kd = (KeyDescription)this.lm.getElementAt(index);
                this.setKeyInformation(this.keyMnemonicResolver.getMnemonics()[kd.getIndex()]);
            } else {
                if (this.macros) {
                    Object o = this.lm.getElementAt(index);
                    if (o instanceof String) {
                        System.out.println((String)o);
                        this.setKeyInformation((String)o);
                    } else if (o instanceof Macro) {
                        Macro m = (Macro)o;
                        this.setKeyInformation(m.getFullName());
                    }
                }
                if (this.special) {
                    System.out.println((String)this.lm.getElementAt(index));
                    String k = this.parseSpecialCharacter((String)this.lm.getElementAt(index));
                    this.setKeyInformation(k);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException ar) {
            System.out.println("ar at index " + index + " - " + ar.getMessage());
        }
    }

    private void setKeyInformation(String keyDesc) {
        if (keyDesc.endsWith(".alt2")) {
            keyDesc = keyDesc.substring(0, keyDesc.indexOf(".alt2"));
        }
        this.strokeDesc.setText(KeyMapper.getKeyStrokeDesc(keyDesc));
        this.strokeDescAlt.setText(KeyMapper.getKeyStrokeDesc(keyDesc + ".alt2"));
        this.strokeLocation.setText(this.getLocationDesc(keyDesc));
        this.strokeLocationAlt.setText(this.getLocationDesc(keyDesc + ".alt2"));
    }

    private String getLocationDesc(String keyDesc) {
        String locStr = LangTool.getString("key.labelLocUnknown");
        if (KeyMapper.isKeyStrokeDefined(keyDesc)) {
            switch (KeyMapper.getKeyStroker(keyDesc).getLocation()) {
                case 2: {
                    locStr = LangTool.getString("key.labelLocLeft");
                    break;
                }
                case 3: {
                    locStr = LangTool.getString("key.labelLocRight");
                    break;
                }
                case 1: {
                    locStr = LangTool.getString("key.labelLocStandard");
                    break;
                }
                case 4: {
                    locStr = LangTool.getString("key.labelLocNumPad");
                }
            }
        }
        return locStr;
    }

    private String parseSpecialCharacter(String value) {
        StringTokenizer tokenizer = new StringTokenizer(value, "-");
        if (tokenizer.hasMoreTokens()) {
            String first = tokenizer.nextToken();
            return String.valueOf(value.charAt(first.length() + 2));
        }
        return "";
    }

    private void loadList(String which) {
        this.lm.clear();
        this.lm.removeAllElements();
        if (which.equals(LangTool.getString("key.labelKeys"))) {
            int x;
            Vector<KeyDescription> lk = new Vector<KeyDescription>(this.keyMnemonicResolver.getMnemonics().length);
            for (x = 0; x < this.keyMnemonicResolver.getMnemonics().length; ++x) {
                lk.addElement(new KeyDescription(LangTool.getString("key." + this.keyMnemonicResolver.getMnemonics()[x]), x));
            }
            Collections.sort(lk, new KeyDescriptionCompare());
            for (x = 0; x < this.keyMnemonicResolver.getMnemonics().length; ++x) {
                this.lm.addElement(lk.get(x));
            }
            this.macros = false;
            this.special = false;
        } else if (which.equals(LangTool.getString("key.labelMacros"))) {
            Vector<String> macrosVector = new Vector<String>();
            if (this.macrosList != null) {
                for (int x = 0; x < this.macrosList.length; ++x) {
                    macrosVector.add(this.macrosList[x]);
                }
            }
            KeyConfigure.scriptDir("scripts", macrosVector);
            KeyConfigure.loadListModel(this.lm, macrosVector, null, 0);
            this.macros = true;
            this.special = false;
        } else {
            Collator collator = Collator.getInstance();
            CollationKey key = null;
            StringBuffer sb = new StringBuffer();
            TreeSet<CollationKey> set = new TreeSet<CollationKey>();
            this.supportAplColorCodesInSEU(collator, sb, set);
            for (int x = 0; x < 256; ++x) {
                char c = this.codePage.ebcdic2uni(x);
                char ac = this.codePage.ebcdic2uni(x);
                if (Character.isISOControl(c)) continue;
                sb.setLength(0);
                if (Integer.toHexString(ac).length() == 1) {
                    sb.append("0x0" + Integer.toHexString(ac).toUpperCase());
                } else {
                    sb.append("0x" + Integer.toHexString(ac).toUpperCase());
                }
                sb.append(" - " + c + " - " + this.getUnicodeString(c));
                key = collator.getCollationKey(sb.toString());
                set.add(key);
            }
            for (CollationKey keyc : set) {
                this.lm.addElement(keyc.getSourceString());
            }
            this.macros = false;
            this.special = true;
        }
        if (!this.lm.isEmpty()) {
            this.functions.setSelectedIndex(0);
        }
    }

    private void supportAplColorCodesInSEU(Collator collator, StringBuffer sb, Set<CollationKey> set) {
        for (Map.Entry<Integer, String> color : colorMap.entrySet()) {
            int keyVal = color.getKey();
            char c = (char)(65280 + keyVal);
            sb.setLength(0);
            sb.append("0FF" + Integer.toHexString(keyVal).toUpperCase());
            sb.append(" - " + c + " - " + color.getValue());
            CollationKey key = collator.getCollationKey(sb.toString());
            set.add(key);
        }
    }

    private String getUnicodeString(char c) {
        String s = Integer.toHexString(c).toUpperCase();
        int len = s.length();
        switch (len) {
            case 2: {
                s = "'\\u00" + s + "'";
                break;
            }
            case 3: {
                s = "'\\u0" + s + "'";
                break;
            }
            default: {
                s = "'\\u" + s + "'";
            }
        }
        return s;
    }

    private JButton addOptButton(String text, String ac, Container container, boolean enabled) {
        JButton button = new JButton(text);
        button.setEnabled(enabled);
        button.setActionCommand(ac);
        button.addActionListener(this);
        button.setAlignmentX(0.5f);
        container.add(button);
        return button;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("DONE")) {
            if (this.mods) {
                KeyMapper.saveKeyMap();
                KeyMapper.fireKeyChangeEvent();
            }
            this.setVisible(false);
        }
        if (e.getActionCommand().equals("MAP")) {
            this.mapIt();
        }
        if (e.getActionCommand().equals("REMOVE")) {
            this.removeIt();
        }
        if (e.getActionCommand().equals("MAP-Prime")) {
            this.altKey = false;
            this.mapIt();
        }
        if (e.getActionCommand().equals("REMOVE-Prime")) {
            this.altKey = false;
            this.removeIt();
        }
        if (e.getActionCommand().equals("MAP-Alt")) {
            this.altKey = true;
            this.mapIt();
        }
        if (e.getActionCommand().equals("REMOVE-Alt")) {
            this.altKey = true;
            this.removeIt();
        }
    }

    private void mapIt() {
        Object[] message = new Object[1];
        JPanel kgp = new JPanel();
        final KeyGetterInterface kg = this.getMeAKeyProcessor();
        kg.setForeground(Color.blue);
        message[0] = kgp;
        String function = this.functions.getSelectedValue() instanceof String ? (String)this.functions.getSelectedValue() : (this.functions.getSelectedValue() instanceof Macro ? ((Macro)this.functions.getSelectedValue()).toString() : ((KeyDescription)this.functions.getSelectedValue()).toString());
        kg.setText(LangTool.getString("key.labelMessage") + function);
        kgp.add(kg);
        Object[] options = new String[]{LangTool.getString("key.labelClose")};
        JOptionPane opain = new JOptionPane(message, -1, -1, null, options, null);
        this.dialog = opain.createDialog(this, this.getTitle());
        kg.setDialog(this.dialog);
        this.dialog.addWindowListener(new WindowAdapter(){
            boolean gotFocus = false;

            @Override
            public void windowClosed(WindowEvent we) {
                if (KeyConfigure.this.isAvailable(kg.keyevent)) {
                    KeyConfigure.this.setNewKeyStrokes(kg.keyevent);
                }
            }

            @Override
            public void windowActivated(WindowEvent we) {
                if (!this.gotFocus) {
                    kg.grabFocus();
                    this.gotFocus = true;
                }
            }
        });
        this.dialog.setVisible(true);
    }

    private boolean isAvailable(KeyEvent ke) {
        boolean exists = true;
        exists = this.isLinux ? KeyMapper.isKeyStrokeDefined(ke, this.isAltGr) : KeyMapper.isKeyStrokeDefined(ke);
        if (exists) {
            Object[] args = new Object[]{this.getKeyDescription(ke)};
            int result = JOptionPane.showConfirmDialog(this, LangTool.messageFormat("messages.mapKeyWarning", args), LangTool.getString("key.labelKeyExists"), 0, 2);
            return result == 0;
        }
        return !exists;
    }

    private String getKeyDescription(KeyEvent ke) {
        String desc = this.isLinux ? KeyMapper.getKeyStrokeMnemonic(ke, this.isAltGr) : KeyMapper.getKeyStrokeMnemonic(ke, this.isAltGr);
        if (desc != null && desc.length() > 1 && desc.startsWith("[")) {
            desc = LangTool.getString("key." + desc);
        }
        return desc;
    }

    private KeyGetterInterface getMeAKeyProcessor() {
        return new KeyGetter();
    }

    private void removeIt() {
        if (!this.macros && !this.special) {
            int index = ((KeyDescription)this.functions.getSelectedValue()).getIndex();
            String function = this.keyMnemonicResolver.getMnemonics()[index];
            if (this.altKey) {
                function = function + ".alt2";
            }
            KeyMapper.removeKeyStroke(function);
            this.setKeyInformation(function);
        } else {
            if (this.macros) {
                Object o = this.functions.getSelectedValue();
                String name = o instanceof Macro ? ((Macro)o).getFullName() : (String)o;
                if (this.altKey) {
                    name = name + ".alt2";
                }
                KeyMapper.removeKeyStroke(name);
                this.setKeyInformation(name);
            }
            if (this.special) {
                String k = "";
                k = k + ((String)this.functions.getSelectedValue()).charAt(7);
                if (this.altKey) {
                    k = k + ".alt2";
                }
                KeyMapper.removeKeyStroke(k);
                this.setKeyInformation(k);
            }
        }
        this.mods = true;
    }

    private void setNewKeyStrokes(KeyEvent ke) {
        if (!this.macros && !this.special) {
            int index = ((KeyDescription)this.functions.getSelectedValue()).getIndex();
            String stroke = this.keyMnemonicResolver.getMnemonics()[index];
            if (this.altKey) {
                stroke = stroke + ".alt2";
            }
            if (this.isLinux) {
                KeyMapper.setKeyStroke(stroke, ke, this.isAltGr);
            } else {
                KeyMapper.setKeyStroke(stroke, ke);
            }
            this.setKeyInformation(stroke);
        } else {
            if (this.macros) {
                Object o = this.functions.getSelectedValue();
                String macro = o instanceof Macro ? ((Macro)o).getFullName() : (String)o;
                if (this.altKey) {
                    macro = macro + ".alt2";
                }
                System.out.println(macro);
                if (this.isLinux) {
                    KeyMapper.setKeyStroke(macro, ke, this.isAltGr);
                } else {
                    KeyMapper.setKeyStroke(macro, ke);
                }
                this.setKeyInformation(macro);
            }
            if (this.special) {
                System.out.println((String)this.functions.getSelectedValue());
                String k = this.parseSpecialCharacter((String)this.functions.getSelectedValue());
                if (this.altKey) {
                    k = k + ".alt2";
                }
                KeyMapper.removeKeyStroke(k);
                if (this.isLinux) {
                    KeyMapper.setKeyStroke(k, ke, this.isAltGr);
                } else {
                    KeyMapper.setKeyStroke(k, ke);
                }
                this.setKeyInformation(k);
            }
        }
        this.mods = true;
    }

    public static void scriptDir(String pathName, Vector scripts) {
        File root = new File(pathName);
        try {
            KeyConfigure.loadScripts(scripts, root.getCanonicalPath(), root);
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
        }
    }

    private static void loadScripts(Vector vector, String path, File directory) {
        File[] macroFiles = directory.listFiles();
        if (macroFiles == null || macroFiles.length == 0) {
            return;
        }
        Arrays.sort(macroFiles, new MacroCompare());
        for (int i = 0; i < macroFiles.length; ++i) {
            File file = macroFiles[i];
            String fileName = file.getName();
            if (file.isHidden()) continue;
            if (file.isDirectory()) {
                Vector<String> subvector = new Vector<String>();
                subvector.addElement(fileName.replace('_', ' '));
                KeyConfigure.loadScripts(subvector, path + fileName + '/', file);
                if (subvector.size() == 1) continue;
                vector.addElement(subvector);
                continue;
            }
            if (!InterpreterDriverManager.isScriptSupported(fileName)) continue;
            String fn = fileName.replace('_', ' ');
            int index = fn.lastIndexOf(46);
            if (index > 0) {
                fn = fn.substring(0, index);
            }
            Macro macro = new Macro(fn, file.getAbsolutePath(), fileName);
            vector.addElement(macro);
        }
    }

    private static void loadListModel(DefaultListModel lm, Vector vector, String prefix, int start) {
        for (int i = start; i < vector.size(); ++i) {
            Object obj = vector.elementAt(i);
            if (obj instanceof Macro) {
                Macro m = (Macro)obj;
                m.setPrefix(prefix);
                lm.addElement(m);
                continue;
            }
            if (obj instanceof Vector) {
                Vector subvector = (Vector)obj;
                String name = (String)subvector.elementAt(0);
                if (prefix != null) {
                    KeyConfigure.loadListModel(lm, subvector, prefix + '/' + name + '/', 1);
                    continue;
                }
                KeyConfigure.loadListModel(lm, subvector, name + '/', 1);
                continue;
            }
            if (!(obj instanceof String)) continue;
            lm.addElement(obj);
        }
    }

    static {
        colorMap.put(32, "Green");
        colorMap.put(33, "Green RI");
        colorMap.put(34, "White");
        colorMap.put(35, "White RI");
        colorMap.put(36, "Green UL");
        colorMap.put(37, "Green RI UL");
        colorMap.put(38, "White UL");
        colorMap.put(39, "NonDisplay");
        colorMap.put(40, "Red");
        colorMap.put(41, "Red RI");
        colorMap.put(42, "Red BL");
        colorMap.put(43, "Red RI BL");
        colorMap.put(44, "Red UL");
        colorMap.put(45, "Red UL RI");
        colorMap.put(46, "Red UL BL");
        colorMap.put(48, "Turquoise CS");
        colorMap.put(49, "Turquoise CS RI");
        colorMap.put(50, "Yellow CS");
        colorMap.put(51, "Yellow CS RI");
        colorMap.put(52, "Turquoise UL");
        colorMap.put(53, "Turquoise UL RI ");
        colorMap.put(54, "Yellow UL");
        colorMap.put(56, "Pink");
        colorMap.put(57, "Pink RI");
        colorMap.put(58, "Blue");
        colorMap.put(59, "Blue RI");
        colorMap.put(60, "Pink UL");
        colorMap.put(61, "Pink UL RI");
        colorMap.put(62, "Blue UL");
    }

    public static class MacroCompare
    implements Comparator<File> {
        @Override
        public int compare(File one, File two) {
            String s1 = one.toString();
            String s2 = two.toString();
            return s1.compareToIgnoreCase(s2);
        }
    }

    private static class Macro {
        String name;
        String path;
        String prefix;
        String fileName;

        Macro(String name, String path, String fileName) {
            this.name = name;
            this.path = path;
            this.fileName = fileName;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public String getFullName() {
            if (this.prefix != null) {
                return this.prefix + this.fileName;
            }
            return this.fileName;
        }

        public String toString() {
            if (this.prefix != null) {
                return this.prefix + this.name;
            }
            return this.name;
        }
    }

    private class KeyDescription {
        private int index;
        private String text;

        public KeyDescription(String text, int index) {
            this.text = text;
            this.index = index;
        }

        public String toString() {
            return this.text;
        }

        public int getIndex() {
            return this.index;
        }
    }

    private static class KeyDescriptionCompare
    implements Comparator<KeyDescription> {
        private KeyDescriptionCompare() {
        }

        @Override
        public int compare(KeyDescription one, KeyDescription two) {
            String s1 = one.toString();
            String s2 = two.toString();
            return s1.compareToIgnoreCase(s2);
        }
    }
}

