/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.mailtools;

import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.tn5250j.interfaces.ConfigureFactory;
import org.tn5250j.tools.LangTool;

public class SendEMail {
    private String to;
    private String from;
    private String pers;
    private String cc;
    private String subject;
    private String configFile;
    private String message;
    private String attachment;
    private String attachmentName;
    private String fileName;
    Properties SMTPProperties;

    public void setTo(String to) {
        this.to = to;
    }

    public String getTo() {
        return this.to;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getFrom() {
        return this.from;
    }

    public void setCC(String cc) {
        this.cc = cc;
    }

    public String getCC() {
        return this.cc;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setConfigFile(String file) {
        this.configFile = file;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setAttachment(String text) {
        this.attachment = text;
    }

    public String getAttachment() {
        return this.attachment;
    }

    public void setMessage(String text) {
        this.message = text;
    }

    public String getMessage() {
        return this.message;
    }

    public void setAttachmentName(String desc) {
        this.attachmentName = desc;
    }

    public String getAttachmentName() {
        return this.attachmentName;
    }

    public void setFileName(String name) {
        this.fileName = name;
    }

    public String getFileName() {
        return this.fileName;
    }

    private boolean loadConfig(String name) throws Exception {
        this.SMTPProperties = ConfigureFactory.getInstance().getProperties("smtp", "SMTPProperties.cfg");
        return this.SMTPProperties.size() > 0;
    }

    public void release() {
        this.to = null;
        this.from = null;
        this.cc = null;
        this.subject = null;
        this.configFile = null;
        this.message = null;
        this.attachment = null;
        this.attachmentName = null;
        this.fileName = null;
    }

    public boolean send() throws Exception {
        try {
            if (!this.loadConfig(this.configFile)) {
                return false;
            }
            Session session = Session.getDefaultInstance((Properties)this.SMTPProperties, null);
            session.setDebug(false);
            MimeMultipart mp = new MimeMultipart();
            MimeMessage msg = new MimeMessage(session);
            InternetAddress[] toAddrs = null;
            InternetAddress[] ccAddrs = null;
            toAddrs = InternetAddress.parse((String)this.to, (boolean)false);
            msg.setRecipients(Message.RecipientType.TO, (Address[])toAddrs);
            if (this.cc != null) {
                ccAddrs = InternetAddress.parse((String)this.cc, (boolean)false);
                msg.setRecipients(Message.RecipientType.CC, (Address[])ccAddrs);
            }
            if (this.subject != null) {
                msg.setSubject(this.subject.trim());
            }
            if (this.from == null) {
                this.from = this.SMTPProperties.getProperty("mail.smtp.from");
            }
            if (this.from != null && this.from.length() > 0) {
                this.pers = this.SMTPProperties.getProperty("mail.smtp.realname");
                if (this.pers != null) {
                    msg.setFrom((Address)new InternetAddress(this.from, this.pers));
                }
            }
            if (this.message != null && this.message.length() > 0) {
                MimeBodyPart mbp = new MimeBodyPart();
                mbp.setText(this.message, "us-ascii");
                mp.addBodyPart((BodyPart)mbp);
            }
            msg.setSentDate(new Date());
            if (this.attachment != null && this.attachment.length() > 0) {
                MimeBodyPart abp = new MimeBodyPart();
                abp.setText(this.attachment, "us-ascii");
                if (this.attachmentName == null || this.attachmentName.length() == 0) {
                    abp.setFileName("tn5250j.txt");
                } else {
                    abp.setFileName(this.attachmentName);
                }
                mp.addBodyPart((BodyPart)abp);
            }
            if (this.fileName != null && this.fileName.length() > 0) {
                MimeBodyPart fbp = new MimeBodyPart();
                fbp.setText("File sent using tn5250j", "us-ascii");
                if (this.attachmentName == null || this.attachmentName.length() == 0) {
                    fbp.setFileName("tn5250j.txt");
                } else {
                    fbp.setFileName(this.attachmentName);
                }
                FileDataSource source = new FileDataSource(this.fileName);
                fbp.setDataHandler(new DataHandler((DataSource)source));
                mp.addBodyPart((BodyPart)fbp);
            }
            msg.setContent((Multipart)mp);
            Transport.send((Message)msg);
            return true;
        }
        catch (SendFailedException sfe) {
            this.showFailedException(sfe);
            return false;
        }
    }

    private void showFailedException(SendFailedException sfe) {
        String error = sfe.getMessage() + "\n";
        Address[] ia = sfe.getInvalidAddresses();
        if (ia != null) {
            for (int x = 0; x < ia.length; ++x) {
                error = error + "Invalid Address: " + ia[x].toString() + "\n";
            }
        }
        JTextArea ea = new JTextArea(error, 6, 50);
        JScrollPane errorScrollPane = new JScrollPane(ea);
        errorScrollPane.setHorizontalScrollBarPolicy(30);
        errorScrollPane.setVerticalScrollBarPolicy(20);
        JOptionPane.showMessageDialog(null, errorScrollPane, LangTool.getString("em.titleConfirmation"), 0);
    }
}

