/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.scripting;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.tn5250j.SessionPanel;
import org.tn5250j.scripting.InterpreterDriver;
import org.tn5250j.scripting.InterpreterDriverManager;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

public class ExecuteScriptAction
extends AbstractAction {
    private static final long serialVersionUID = 181938308216785668L;
    private static final transient TN5250jLogger LOG = TN5250jLogFactory.getLogger(ExecuteScriptAction.class);
    private String _scriptFile;
    private SessionPanel ses;

    public ExecuteScriptAction(String name, String scriptFile, SessionPanel session) {
        super(name);
        this._scriptFile = scriptFile;
        this.ses = session;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Invoking " + this._scriptFile);
        }
        try {
            InterpreterDriverManager.executeScriptFile(this.ses, this._scriptFile);
        }
        catch (InterpreterDriver.InterpreterException ex) {
            this.ses.setMacroRunning(false);
            System.out.println(ex);
            ex.printStackTrace();
        }
    }
}

