/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.sessionsettings;

import java.awt.Color;
import java.awt.Rectangle;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.tn5250j.SessionConfig;
import org.tn5250j.tools.LangTool;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

abstract class AttributesPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String nodePrefix = "sa.node";
    private final TN5250jLogger log = TN5250jLogFactory.getLogger(this.getClass());
    private String name;
    SessionConfig changes = null;
    JPanel contentPane;

    public AttributesPanel(SessionConfig config) {
        this(config, "", nodePrefix);
    }

    public AttributesPanel(SessionConfig config, String name) {
        this(config, name, nodePrefix);
    }

    public AttributesPanel(SessionConfig config, String name, String prefix) {
        this.changes = config;
        this.name = LangTool.getString(prefix + name);
        this.setLayout(new BoxLayout(this, 1));
        try {
            this.initPanel();
        }
        catch (Exception e) {
            this.log.error(e);
        }
    }

    public abstract void initPanel() throws Exception;

    public abstract void applyAttributes();

    protected final String getStringProperty(String prop) {
        if (this.changes.isPropertyExists(prop)) {
            return this.changes.getStringProperty(prop);
        }
        return "";
    }

    protected final String getStringProperty(String prop, String defaultValue) {
        if (this.changes.isPropertyExists(prop)) {
            String p = this.changes.getStringProperty(prop);
            if (p.length() > 0) {
                return p;
            }
            return defaultValue;
        }
        return defaultValue;
    }

    protected final Color getColorProperty(String prop) {
        if (this.changes.isPropertyExists(prop)) {
            Color c = new Color(this.changes.getIntegerProperty(prop));
            return c;
        }
        return null;
    }

    protected Color getColorProperty(String prop, Color defColor) {
        if (this.changes.isPropertyExists(prop)) {
            Color c = new Color(this.changes.getIntegerProperty(prop));
            return c;
        }
        return defColor;
    }

    protected final boolean getBooleanProperty(String prop, boolean dflt) {
        if (this.changes.isPropertyExists(prop)) {
            String b = this.changes.getStringProperty(prop).toLowerCase();
            return b.equals("yes") || b.equals("true");
        }
        return dflt;
    }

    protected Rectangle getRectangleProperty(String key) {
        return this.changes.getRectangleProperty(key);
    }

    protected void setRectangleProperty(String key, Rectangle rect) {
        this.changes.setRectangleProperty(key, rect);
    }

    protected final void setProperty(String key, String val) {
        this.changes.setProperty(key, val);
    }

    @Override
    public String toString() {
        return this.name;
    }
}

