/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.sessionsettings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import org.tn5250j.SessionConfig;
import org.tn5250j.sessionsettings.AttributesPanel;
import org.tn5250j.sessionsettings.ColumnSeparator;
import org.tn5250j.tools.AlignLayout;
import org.tn5250j.tools.LangTool;

class DisplayAttributesPanel
extends AttributesPanel {
    private static final String NO = "No";
    private static final String YES = "Yes";
    private static final long serialVersionUID = 1L;
    private JRadioButton csHide;
    private JRadioButton csLine;
    private JRadioButton csShortLine;
    private JRadioButton saNormal;
    private JCheckBox guiCheck;
    private JCheckBox guiShowUnderline;

    DisplayAttributesPanel(SessionConfig config) {
        super(config, "Display");
    }

    @Override
    public void initPanel() throws Exception {
        this.setLayout(new BorderLayout());
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BoxLayout(this.contentPane, 1));
        this.add((Component)this.contentPane, "North");
        JPanel csp = new JPanel(new FlowLayout(1, 10, 10));
        TitledBorder tb = BorderFactory.createTitledBorder(LangTool.getString("sa.cs"));
        csp.setBorder(tb);
        this.csHide = new JRadioButton(LangTool.getString("sa.csHide"));
        this.csHide.setActionCommand("Hide");
        this.csLine = new JRadioButton(LangTool.getString("sa.csLine"));
        this.csLine.setActionCommand("Line");
        JRadioButton csDot = new JRadioButton(LangTool.getString("sa.csDot"));
        csDot.setActionCommand("Dot");
        this.csShortLine = new JRadioButton(LangTool.getString("sa.csShortLine"));
        this.csShortLine.setActionCommand("ShortLine");
        ButtonGroup csGroup = new ButtonGroup();
        csGroup.add(this.csHide);
        csGroup.add(this.csLine);
        csGroup.add(csDot);
        csGroup.add(this.csShortLine);
        this.csLine.setSelected(ColumnSeparator.Line == ColumnSeparator.getFromName(this.getStringProperty("colSeparator")));
        csDot.setSelected(ColumnSeparator.Dot == ColumnSeparator.getFromName(this.getStringProperty("colSeparator")));
        this.csShortLine.setSelected(ColumnSeparator.ShortLine == ColumnSeparator.getFromName(this.getStringProperty("colSeparator")));
        this.csHide.setSelected(ColumnSeparator.Hide == ColumnSeparator.getFromName(this.getStringProperty("colSeparator")));
        csp.add(this.csHide);
        csp.add(this.csLine);
        csp.add(csDot);
        csp.add(this.csShortLine);
        JPanel sap = new JPanel();
        sap.setBorder(BorderFactory.createTitledBorder(LangTool.getString("sa.showAttr")));
        this.saNormal = new JRadioButton(LangTool.getString("sa.showNormal"));
        this.saNormal.setActionCommand("Normal");
        JRadioButton saHex = new JRadioButton(LangTool.getString("sa.showHex"));
        saHex.setActionCommand("Hex");
        ButtonGroup saGroup = new ButtonGroup();
        saGroup.add(this.saNormal);
        saGroup.add(saHex);
        if (this.getStringProperty("showAttr").equals("Hex")) {
            saHex.setSelected(true);
        } else {
            this.saNormal.setSelected(true);
        }
        sap.add(this.saNormal);
        sap.add(saHex);
        JPanel cgp = new JPanel();
        cgp.setBorder(BorderFactory.createTitledBorder(LangTool.getString("sa.cgp")));
        cgp.setLayout(new AlignLayout(1, 5, 5));
        this.guiCheck = new JCheckBox(LangTool.getString("sa.guiCheck"));
        this.guiCheck.setSelected(YES.equals(this.getStringProperty("guiInterface")));
        cgp.add(this.guiCheck);
        this.guiShowUnderline = new JCheckBox(LangTool.getString("sa.guiShowUnderline"));
        this.guiShowUnderline.setSelected(YES.equals(this.getStringProperty("guiShowUnderline")));
        cgp.add(this.guiShowUnderline);
        this.contentPane.add(csp);
        this.contentPane.add(sap);
        this.contentPane.add(cgp);
    }

    @Override
    public void applyAttributes() {
        if (this.csHide.isSelected()) {
            this.changes.firePropertyChange(this, "colSeparator", this.getStringProperty("colSeparator"), "Hide");
            this.setProperty("colSeparator", "Hide");
        } else if (this.csLine.isSelected()) {
            this.changes.firePropertyChange(this, "colSeparator", this.getStringProperty("colSeparator"), "Line");
            this.setProperty("colSeparator", "Line");
        } else if (this.csShortLine.isSelected()) {
            this.changes.firePropertyChange(this, "colSeparator", this.getStringProperty("colSeparator"), "ShortLine");
            this.setProperty("colSeparator", "ShortLine");
        } else {
            this.changes.firePropertyChange(this, "colSeparator", this.getStringProperty("colSeparator"), "Dot");
            this.setProperty("colSeparator", "Dot");
        }
        if (this.saNormal.isSelected()) {
            this.changes.firePropertyChange(this, "showAttr", this.getStringProperty("showAttr"), "Normal");
            this.setProperty("showAttr", "Normal");
        } else {
            this.changes.firePropertyChange(this, "showAttr", this.getStringProperty("showAttr"), "Hex");
            this.setProperty("showAttr", "Hex");
        }
        if (this.guiCheck.isSelected()) {
            this.changes.firePropertyChange(this, "guiInterface", this.getStringProperty("guiInterface"), YES);
            this.setProperty("guiInterface", YES);
        } else {
            this.changes.firePropertyChange(this, "guiInterface", this.getStringProperty("guiInterface"), NO);
            this.setProperty("guiInterface", NO);
        }
        if (this.guiShowUnderline.isSelected()) {
            this.changes.firePropertyChange(this, "guiShowUnderline", this.getStringProperty("guiShowUnderline"), YES);
            this.setProperty("guiShowUnderline", YES);
        } else {
            this.changes.firePropertyChange(this, "guiShowUnderline", this.getStringProperty("guiShowUnderline"), NO);
            this.setProperty("guiShowUnderline", NO);
        }
    }
}

