/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.sessionsettings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.tn5250j.SessionConfig;
import org.tn5250j.sessionsettings.AttributesPanel;
import org.tn5250j.tools.AlignLayout;
import org.tn5250j.tools.LangTool;

class FontAttributesPanel
extends AttributesPanel {
    private static final long serialVersionUID = 1L;
    private JComboBox fontsList;
    private JCheckBox useAntialias;
    private JTextField verticalScale;
    private JTextField horizontalScale;
    private JTextField pointSize;

    FontAttributesPanel(SessionConfig config) {
        super(config, "Fonts");
    }

    @Override
    public void initPanel() throws Exception {
        this.setLayout(new BorderLayout());
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BoxLayout(this.contentPane, 1));
        this.add((Component)this.contentPane, "North");
        Font[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        JPanel flp = new JPanel();
        TitledBorder tb = BorderFactory.createTitledBorder(LangTool.getString("sa.font"));
        flp.setBorder(tb);
        this.fontsList = new JComboBox();
        String font = this.getStringProperty("font");
        for (int x = 0; x < fonts.length; ++x) {
            if (fonts[x].getFontName().indexOf(46) >= 0) continue;
            this.fontsList.addItem(fonts[x].getFontName());
        }
        this.fontsList.setSelectedItem(font);
        this.useAntialias = new JCheckBox(LangTool.getString("sa.useAntialias"));
        this.useAntialias.setSelected(this.getBooleanProperty("useAntialias", true));
        flp.add(this.fontsList);
        flp.add(this.useAntialias);
        JPanel fsp = new JPanel();
        fsp.setLayout(new AlignLayout(2, 5, 5));
        tb = BorderFactory.createTitledBorder(LangTool.getString("sa.scaleLabel"));
        fsp.setBorder(tb);
        this.verticalScale = new JTextField("1.2", 5);
        this.horizontalScale = new JTextField("1.0", 5);
        this.pointSize = new JTextField("0", 5);
        if (this.getStringProperty("fontScaleWidth").length() != 0) {
            this.horizontalScale.setText(this.getStringProperty("fontScaleWidth"));
        }
        if (this.getStringProperty("fontScaleHeight").length() != 0) {
            this.verticalScale.setText(this.getStringProperty("fontScaleHeight"));
        }
        if (this.getStringProperty("fontPointSize").length() != 0) {
            this.pointSize.setText(this.getStringProperty("fontPointSize"));
        }
        fsp.add(new JLabel(LangTool.getString("sa.fixedPointSize")));
        fsp.add(this.pointSize);
        fsp.add(new JLabel(LangTool.getString("sa.horScaleLabel")));
        fsp.add(this.horizontalScale);
        fsp.add(new JLabel(LangTool.getString("sa.vertScaleLabel")));
        fsp.add(this.verticalScale);
        this.contentPane.add(flp);
        this.contentPane.add(fsp);
    }

    @Override
    public void applyAttributes() {
        if (!this.getStringProperty("font").equals(this.fontsList.getSelectedItem())) {
            this.changes.firePropertyChange(this, "font", this.getStringProperty("font"), this.fontsList.getSelectedItem());
            this.setProperty("font", (String)this.fontsList.getSelectedItem());
        }
        if (this.useAntialias.isSelected()) {
            this.changes.firePropertyChange(this, "useAntialias", this.getStringProperty("useAntialias"), "Yes");
            this.setProperty("useAntialias", "Yes");
        } else {
            this.changes.firePropertyChange(this, "useAntialias", this.getStringProperty("useAntialias"), "No");
            this.setProperty("useAntialias", "No");
        }
        this.changes.firePropertyChange(this, "fontScaleHeight", this.getStringProperty("fontScaleHeight"), this.verticalScale.getText());
        this.setProperty("fontScaleHeight", this.verticalScale.getText());
        this.changes.firePropertyChange(this, "fontScaleWidth", this.getStringProperty("fontScaleWidth"), this.horizontalScale.getText());
        this.setProperty("fontScaleWidth", this.horizontalScale.getText());
        this.changes.firePropertyChange(this, "fontPointSize", this.getStringProperty("fontPointSize"), this.pointSize.getText());
        this.setProperty("fontPointSize", this.pointSize.getText());
    }
}

