/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.sessionsettings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.tn5250j.SessionConfig;
import org.tn5250j.keyboard.KeyMnemonic;
import org.tn5250j.keyboard.KeyMnemonicResolver;
import org.tn5250j.sessionsettings.AttributesPanel;
import org.tn5250j.tools.LangTool;

class KeypadAttributesPanel
extends AttributesPanel {
    private static final long serialVersionUID = 1L;
    private static final int VISIBLE_ROW_COUNT = 15;
    private JCheckBox keyPadEnable;
    private JTextField fontSize;
    private JList availableButtonsList;
    private JList configuredButtonsList;

    KeypadAttributesPanel(SessionConfig config) {
        super(config, "KP");
    }

    @Override
    public void applyAttributes() {
        this.applyKeypadEnabled();
        this.applyFontSize();
        this.changes.setKeypadMnemonicsAndFireChangeEvent(this.getConfiguredKeypadMnemonics());
    }

    @Override
    public void initPanel() throws Exception {
        this.setLayout(new BorderLayout());
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BoxLayout(this.contentPane, 1));
        this.add((Component)this.contentPane, "North");
        this.contentPane.add(this.createEnableKeypadAndFontSizePanel());
        this.contentPane.add(this.createCustomButtonConfigurationPanel());
    }

    private JPanel createEnableKeypadAndFontSizePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createTitledBorder(LangTool.getString("sa.kpp")));
        panel.add(this.createEnableKeypadCheckboxPanel());
        panel.add(this.createFontSizePanel());
        return panel;
    }

    private JPanel createEnableKeypadCheckboxPanel() {
        JPanel panel = new JPanel();
        this.keyPadEnable = new JCheckBox(LangTool.getString("sa.kpCheck"));
        this.keyPadEnable.setSelected("Yes".equals(this.getStringProperty("keypad")));
        this.keyPadEnable.addActionListener(new UpdateFontSizeTextEnabledAction());
        panel.add(this.keyPadEnable);
        return panel;
    }

    private JPanel createCustomButtonConfigurationPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setBorder(BorderFactory.createTitledBorder(LangTool.getString("sa.kpVisibleButtons")));
        JPanel listPanel = new JPanel();
        listPanel.setLayout(new BoxLayout(listPanel, 0));
        listPanel.add(this.createAvailableButtonsList());
        listPanel.add(this.createListMoveButtons());
        listPanel.add(this.createConfiguredButtonsList());
        listPanel.add(this.createListOrderButtons());
        mainPanel.add(listPanel);
        JButton resetButton = new JButton(LangTool.getString("sa.kpResetDefaults"));
        resetButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeypadAttributesPanel.this.resetModelsToDefaultValues();
            }
        });
        mainPanel.add(resetButton);
        return mainPanel;
    }

    private void resetModelsToDefaultValues() {
        DefaultListModel configuredModel = (DefaultListModel)this.configuredButtonsList.getModel();
        configuredModel.clear();
        for (KeyMnemonic mnemonic : this.changes.getConfig().getDefaultKeypadMnemonics()) {
            configuredModel.addElement(mnemonic);
        }
        DefaultListModel availableModel = (DefaultListModel)this.availableButtonsList.getModel();
        availableModel.clear();
        for (KeyMnemonic mnemonic : this.getAvailableAndNotYetConfiguredMnemonics(this.changes.getConfig().getDefaultKeypadMnemonics())) {
            availableModel.addElement(mnemonic);
        }
    }

    private Component createListMoveButtons() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(KeypadAttributesPanel.createButton(">", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeypadAttributesPanel.this.moveFromTo(KeypadAttributesPanel.this.availableButtonsList, KeypadAttributesPanel.this.configuredButtonsList);
            }
        }));
        panel.add(KeypadAttributesPanel.createButton("<", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeypadAttributesPanel.this.moveFromTo(KeypadAttributesPanel.this.configuredButtonsList, KeypadAttributesPanel.this.availableButtonsList);
            }
        }));
        return panel;
    }

    private Component createListOrderButtons() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(KeypadAttributesPanel.createButton(UIManager.getIcon("Table.ascendingSortIcon"), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeypadAttributesPanel.this.moveUp();
            }
        }));
        panel.add(KeypadAttributesPanel.createButton(UIManager.getIcon("Table.descendingSortIcon"), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeypadAttributesPanel.this.moveDown();
            }
        }));
        return panel;
    }

    private void moveUp() {
        int selectedIndex = this.configuredButtonsList.getSelectedIndex();
        if (selectedIndex > 0) {
            DefaultListModel model = (DefaultListModel)this.configuredButtonsList.getModel();
            Object element = model.remove(selectedIndex);
            model.insertElementAt(element, selectedIndex - 1);
            this.configuredButtonsList.setSelectedIndex(selectedIndex - 1);
        }
    }

    private void moveDown() {
        DefaultListModel model;
        int selectedIndex = this.configuredButtonsList.getSelectedIndex();
        if (selectedIndex < (model = (DefaultListModel)this.configuredButtonsList.getModel()).size() - 1) {
            Object element = model.remove(selectedIndex);
            model.insertElementAt(element, selectedIndex + 1);
            this.configuredButtonsList.setSelectedIndex(selectedIndex + 1);
        }
    }

    private void moveFromTo(JList sourceList, JList destinationList) {
        int[] selectedIndices = sourceList.getSelectedIndices();
        DefaultListModel sourceModel = (DefaultListModel)sourceList.getModel();
        DefaultListModel destinationModel = (DefaultListModel)destinationList.getModel();
        for (int selectedIndex : selectedIndices) {
            Object element = sourceModel.getElementAt(selectedIndex);
            destinationModel.addElement(element);
        }
        KeypadAttributesPanel.safeDeleteByIndex(sourceModel, selectedIndices);
    }

    private JComponent createAvailableButtonsList() {
        KeyMnemonic[] configuredMnemonics = this.changes.getConfig().getKeypadMnemonics();
        KeyMnemonic[] availableMnemonics = this.getAvailableAndNotYetConfiguredMnemonics(configuredMnemonics);
        this.availableButtonsList = new JList(this.createListModelMnemonics(availableMnemonics));
        this.availableButtonsList.setSelectionMode(2);
        this.availableButtonsList.setLayoutOrientation(0);
        this.availableButtonsList.setVisibleRowCount(15);
        this.availableButtonsList.setCellRenderer(new KeypadMnemonicListCellRenderer());
        return this.createScrollPaneForList(this.availableButtonsList);
    }

    private KeyMnemonic[] getAvailableAndNotYetConfiguredMnemonics(KeyMnemonic[] excludedMnemonics) {
        ArrayList<KeyMnemonic> result = new ArrayList<KeyMnemonic>();
        HashSet alreadyConfigured = new HashSet();
        Collections.addAll(alreadyConfigured, excludedMnemonics);
        for (KeyMnemonic mnemonic : KeyMnemonic.values()) {
            if (alreadyConfigured.contains((Object)mnemonic)) continue;
            result.add(mnemonic);
        }
        Collections.sort(result, new KeypadMnemonicDescriptionComparator());
        return result.toArray(new KeyMnemonic[result.size()]);
    }

    private KeyMnemonic[] getConfiguredKeypadMnemonics() {
        DefaultListModel model = (DefaultListModel)this.configuredButtonsList.getModel();
        KeyMnemonic[] newValue = new KeyMnemonic[model.size()];
        Enumeration elements = model.elements();
        int counter = 0;
        while (elements.hasMoreElements()) {
            KeyMnemonic mnemonic = (KeyMnemonic)((Object)elements.nextElement());
            newValue[counter++] = mnemonic;
        }
        return newValue;
    }

    private JComponent createConfiguredButtonsList() {
        this.configuredButtonsList = new JList(this.createListModelMnemonics(this.changes.getConfig().getKeypadMnemonics()));
        this.configuredButtonsList.setSelectionMode(0);
        this.configuredButtonsList.setLayoutOrientation(0);
        this.configuredButtonsList.setVisibleRowCount(15);
        this.configuredButtonsList.setCellRenderer(new KeypadMnemonicListCellRenderer());
        return this.createScrollPaneForList(this.configuredButtonsList);
    }

    private DefaultListModel createListModelMnemonics(KeyMnemonic[] keyMnemonics) {
        DefaultListModel<KeyMnemonic> model = new DefaultListModel<KeyMnemonic>();
        for (KeyMnemonic mnemonic : keyMnemonics) {
            model.addElement(mnemonic);
        }
        return model;
    }

    private JScrollPane createScrollPaneForList(JList list) {
        JScrollPane scrollPane = new JScrollPane(list);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.setPreferredSize(list.getPreferredScrollableViewportSize());
        scrollPane.setVisible(true);
        return scrollPane;
    }

    private JPanel createFontSizePanel() {
        JPanel fontSizePanel = new JPanel();
        this.fontSize = new JTextField(Float.toString(12.0f), 5);
        if (this.getStringProperty("keypadFontSize").length() != 0) {
            this.fontSize.setText(this.getStringProperty("keypadFontSize"));
        }
        fontSizePanel.add(new JLabel(LangTool.getString("spool.labelOptsFontSize")));
        fontSizePanel.add(this.fontSize);
        return fontSizePanel;
    }

    private void applyKeypadEnabled() {
        String newValueEnabled = this.keyPadEnable.isSelected() ? "Yes" : "No";
        this.changes.firePropertyChange(this, "keypad", this.getStringProperty("keypad"), newValueEnabled);
        this.setProperty("keypad", newValueEnabled);
    }

    private void applyFontSize() {
        String newValue = this.ensureValidFloatAsString(this.fontSize.getText());
        this.changes.firePropertyChange(this, "keypadFontSize", this.getStringProperty("keypadFontSize"), newValue);
        this.setProperty("keypadFontSize", newValue);
    }

    private String ensureValidFloatAsString(String value) {
        if (value != null) {
            value = value.trim();
            float v = Float.parseFloat(value);
            return Float.toString(v);
        }
        return Float.toString(12.0f);
    }

    private static void safeDeleteByIndex(DefaultListModel listModel, int[] indexesToBeDeleted) {
        Arrays.sort(indexesToBeDeleted);
        for (int i = indexesToBeDeleted.length - 1; i >= 0; --i) {
            listModel.remove(indexesToBeDeleted[i]);
        }
    }

    private static JButton createButton(Icon icon, AbstractAction action) {
        JButton button = new JButton(icon);
        button.addActionListener(action);
        return button;
    }

    private static JButton createButton(String text, AbstractAction action) {
        JButton button = new JButton(text);
        button.addActionListener(action);
        return button;
    }

    private static class KeypadMnemonicListCellRenderer
    implements ListCellRenderer {
        private DefaultListCellRenderer delegateRenderer = new DefaultListCellRenderer();
        private KeyMnemonicResolver keyMnemonicResolver = new KeyMnemonicResolver();

        private KeypadMnemonicListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String description = this.keyMnemonicResolver.getDescription((KeyMnemonic)((Object)value));
            return this.delegateRenderer.getListCellRendererComponent((JList<?>)list, description, index, isSelected, cellHasFocus);
        }
    }

    private class UpdateFontSizeTextEnabledAction
    extends AbstractAction {
        private UpdateFontSizeTextEnabledAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KeypadAttributesPanel.this.fontSize.setEnabled(KeypadAttributesPanel.this.keyPadEnable.isSelected());
        }
    }

    private static class KeypadMnemonicDescriptionComparator
    implements Comparator<KeyMnemonic> {
        private final KeyMnemonicResolver resolver = new KeyMnemonicResolver();

        private KeypadMnemonicDescriptionComparator() {
        }

        @Override
        public int compare(KeyMnemonic mnemonic1, KeyMnemonic mnemonic2) {
            return this.resolver.getDescription(mnemonic1).compareToIgnoreCase(this.resolver.getDescription(mnemonic2));
        }
    }
}

