/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.sessionsettings;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.tn5250j.SessionConfig;
import org.tn5250j.sessionsettings.AttributesPanel;
import org.tn5250j.sessionsettings.ColorAttributesPanel;
import org.tn5250j.sessionsettings.CursorAttributesPanel;
import org.tn5250j.sessionsettings.DisplayAttributesPanel;
import org.tn5250j.sessionsettings.ErrorResetAttributesPanel;
import org.tn5250j.sessionsettings.FontAttributesPanel;
import org.tn5250j.sessionsettings.HotspotAttributesPanel;
import org.tn5250j.sessionsettings.KeypadAttributesPanel;
import org.tn5250j.sessionsettings.MouseAttributesPanel;
import org.tn5250j.sessionsettings.OnConnectAttributesPanel;
import org.tn5250j.sessionsettings.PrinterAttributesPanel;
import org.tn5250j.sessionsettings.SignoffAttributesPanel;
import org.tn5250j.sessionsettings.TabAttributesPanel;
import org.tn5250j.tools.LangTool;

public class SessionSettings
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final String fileName;
    private final Properties props;
    private JPanel jpm = new JPanel(new BorderLayout());
    private final SessionConfig changes;
    private JTree tree = new JTree();
    private CardLayout cardLayout;
    private JPanel jp;

    public SessionSettings(Frame parent, SessionConfig config) {
        super(parent);
        parent.setCursor(Cursor.getPredefinedCursor(3));
        this.fileName = config.getConfigurationResource();
        this.props = config.getProperties();
        this.changes = config;
        try {
            this.jbInit();
            parent.setCursor(Cursor.getPredefinedCursor(0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.jp = new JPanel();
        this.cardLayout = new CardLayout();
        this.jp.setLayout(this.cardLayout);
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        Enumeration<TreeNode> e = root.children();
        while (e.hasMoreElements()) {
            TreeNode child = e.nextElement();
            Object obj = ((DefaultMutableTreeNode)child).getUserObject();
            if (!(obj instanceof AttributesPanel)) continue;
            this.jp.add((Component)((AttributesPanel)obj), obj.toString());
        }
        DefaultMutableTreeNode top = new DefaultMutableTreeNode(this.fileName);
        this.createNodes(top);
        this.tree = new JTree(top);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)SessionSettings.this.tree.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                SessionSettings.this.showPanel(node.getUserObject());
            }
        });
        JPanel jsp = new JPanel();
        jsp.setBackground(Color.white);
        jsp.add(this.tree);
        this.jpm.add((Component)this.jp, "East");
        this.jpm.add((Component)jsp, "West");
        this.cardLayout.first(this.jp);
    }

    private void showPanel(Object node) {
        this.cardLayout.show(this.jp, node.toString());
    }

    private void createNodes(DefaultMutableTreeNode top) {
        this.createNode(top, new ColorAttributesPanel(this.changes));
        this.createNode(top, new DisplayAttributesPanel(this.changes));
        this.createNode(top, new CursorAttributesPanel(this.changes));
        this.createNode(top, new FontAttributesPanel(this.changes));
        this.createNode(top, new TabAttributesPanel(this.changes));
        this.createNode(top, new SignoffAttributesPanel(this.changes));
        this.createNode(top, new OnConnectAttributesPanel(this.changes));
        this.createNode(top, new MouseAttributesPanel(this.changes));
        this.createNode(top, new HotspotAttributesPanel(this.changes));
        this.createNode(top, new KeypadAttributesPanel(this.changes));
        this.createNode(top, new PrinterAttributesPanel(this.changes));
        this.createNode(top, new ErrorResetAttributesPanel(this.changes));
    }

    private void createNode(DefaultMutableTreeNode top, AttributesPanel ap) {
        top.add(new DefaultMutableTreeNode(ap));
        this.jp.add((Component)ap, ap.toString());
    }

    protected final String getStringProperty(String prop) {
        if (this.props.containsKey(prop)) {
            return (String)this.props.get(prop);
        }
        return "";
    }

    protected final String getStringProperty(String prop, String defaultValue) {
        if (this.props.containsKey(prop)) {
            String p = (String)this.props.get(prop);
            if (p.length() > 0) {
                return p;
            }
            return defaultValue;
        }
        return defaultValue;
    }

    protected final void setProperty(String key, String val) {
        this.props.setProperty(key, val);
    }

    public Properties getProperties() {
        return this.props;
    }

    public void showIt() {
        Object[] message = new Object[]{this.jpm};
        Object[] options = new String[]{LangTool.getString("sa.optApply"), LangTool.getString("sa.optCancel"), LangTool.getString("sa.optSave")};
        final JOptionPane saOptionPane = new JOptionPane(message, -1, 1, null, options, options[1]);
        this.setTitle(LangTool.getString("sa.title"));
        this.setModal(true);
        this.setContentPane(saOptionPane);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
            }
        });
        saOptionPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String prop = e.getPropertyName();
                if (SessionSettings.this.isVisible() && e.getSource() == saOptionPane && (prop.equals("value") || prop.equals("inputValue"))) {
                    saOptionPane.setCursor(Cursor.getPredefinedCursor(3));
                    SessionSettings.this.doOptionStuff(saOptionPane);
                    saOptionPane.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        if (dialogSize.height > screenSize.height) {
            dialogSize.height = screenSize.height;
        }
        if (dialogSize.width > screenSize.width) {
            dialogSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
        this.setVisible(true);
    }

    private void doOptionStuff(JOptionPane optionPane) {
        Object result = optionPane.getValue();
        if (LangTool.getString("sa.optApply").equals(result)) {
            this.applyAttributes();
            optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
        }
        if (LangTool.getString("sa.optCancel").equals(result)) {
            this.setVisible(false);
            this.dispose();
        }
        if (LangTool.getString("sa.optSave").equals(result)) {
            if (this.props.containsKey("saveme")) {
                this.props.remove("saveme");
            }
            this.changes.saveSessionProps();
            this.setVisible(false);
            this.dispose();
        }
    }

    private void applyAttributes() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        Enumeration<TreeNode> e = root.children();
        while (e.hasMoreElements()) {
            TreeNode child = e.nextElement();
            Object obj = ((DefaultMutableTreeNode)child).getUserObject();
            if (!(obj instanceof AttributesPanel)) continue;
            ((AttributesPanel)obj).applyAttributes();
        }
        this.setProperty("saveme", "yes");
    }
}

