/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.sessionsettings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.tn5250j.SessionConfig;
import org.tn5250j.sessionsettings.AttributesPanel;
import org.tn5250j.tools.AlignLayout;
import org.tn5250j.tools.LangTool;

class SignoffAttributesPanel
extends AttributesPanel {
    private static final long serialVersionUID = 1L;
    private JCheckBox signoffCheck;
    private JTextField fromRow;
    private JTextField fromCol;
    private JTextField toRow;
    private JTextField toCol;

    SignoffAttributesPanel(SessionConfig config) {
        super(config, "Signoff");
    }

    @Override
    public void initPanel() throws Exception {
        this.setLayout(new BorderLayout());
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BoxLayout(this.contentPane, 1));
        this.add((Component)this.contentPane, "North");
        JPanel soConfirm = new JPanel();
        soConfirm.setBorder(BorderFactory.createTitledBorder(LangTool.getString("sa.titleSignoff")));
        this.signoffCheck = new JCheckBox(LangTool.getString("sa.confirmSignoff"));
        this.signoffCheck.setSelected(this.getStringProperty("confirmSignoff").equals("Yes"));
        this.signoffCheck.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SignoffAttributesPanel.this.doItemStateChanged(e);
            }
        });
        soConfirm.add(this.signoffCheck);
        JPanel soRegion = new JPanel();
        soRegion.setBorder(BorderFactory.createTitledBorder(LangTool.getString("sa.titleSignoffRegion")));
        AlignLayout rowcol = new AlignLayout(4, 5, 5);
        soRegion.setLayout(rowcol);
        soRegion.add(new JLabel(LangTool.getString("sa.fromRow")));
        this.fromRow = new JTextField("1", 5);
        soRegion.add(this.fromRow);
        soRegion.add(new JLabel(LangTool.getString("sa.fromColumn")));
        this.fromCol = new JTextField("1", 5);
        soRegion.add(this.fromCol);
        soRegion.add(new JLabel(LangTool.getString("sa.toRow")));
        this.toRow = new JTextField("24", 5);
        soRegion.add(this.toRow);
        soRegion.add(new JLabel(LangTool.getString("sa.toColumn")));
        this.toCol = new JTextField("80", 5);
        soRegion.add(this.toCol);
        this.loadRegion();
        this.toggleRegion(this.signoffCheck.isSelected());
        this.contentPane.add(soConfirm);
        this.contentPane.add(soRegion);
    }

    private void loadRegion() {
        Rectangle region = this.getRectangleProperty("signOnRegion");
        if (region.x == 0) {
            this.fromRow.setText("1");
        } else {
            this.fromRow.setText(Integer.toString(region.x));
        }
        if (region.y == 0) {
            this.fromCol.setText("1");
        } else {
            this.fromCol.setText(Integer.toString(region.y));
        }
        if (region.width == 0) {
            this.toRow.setText("24");
        } else {
            this.toRow.setText(Integer.toString(region.width));
        }
        if (region.height == 0) {
            this.toCol.setText("80");
        } else {
            this.toCol.setText(Integer.toString(region.height));
        }
    }

    private void doItemStateChanged(ItemEvent e) {
        this.toggleRegion(false);
        if (e.getStateChange() == 1 && this.signoffCheck.isSelected()) {
            this.toggleRegion(true);
        }
    }

    private void toggleRegion(boolean state) {
        this.fromRow.setEnabled(state);
        this.fromCol.setEnabled(state);
        this.toRow.setEnabled(state);
        this.toCol.setEnabled(state);
    }

    @Override
    public void applyAttributes() {
        if (this.signoffCheck.isSelected()) {
            this.changes.firePropertyChange(this, "confirmSignoff", this.getStringProperty("confirmSignoff"), "Yes");
            this.setProperty("confirmSignoff", "Yes");
        } else {
            this.changes.firePropertyChange(this, "confirmSignoff", this.getStringProperty("confirmSignoff"), "No");
            this.setProperty("confirmSignoff", "No");
        }
        Rectangle region = new Rectangle(Integer.parseInt(this.fromRow.getText()), Integer.parseInt(this.fromCol.getText()), Integer.parseInt(this.toRow.getText()), Integer.parseInt(this.toCol.getText()));
        if (region.x < 0) {
            region.x = 1;
        }
        if (region.y < 0) {
            region.y = 1;
        }
        if (region.width > 24) {
            region.width = 24;
        }
        if (region.height > 80) {
            region.height = 80;
        }
        this.setRectangleProperty("signOnRegion", region);
    }
}

