/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.sql;

import java.io.FileNotFoundException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Vector;
import org.tn5250j.event.FTPStatusEvent;
import org.tn5250j.event.FTPStatusListener;
import org.tn5250j.framework.tn5250.tnvt;
import org.tn5250j.tools.filters.FileFieldDef;
import org.tn5250j.tools.filters.OutputFilterInterface;

public class AS400Xtfr {
    private boolean loggedIn;
    private String hostName;
    private int timeout = 50000;
    private boolean connected;
    private ArrayList ffd;
    private tnvt vt;
    private Vector<FTPStatusListener> listeners;
    private FTPStatusEvent status;
    private boolean aborted;
    private char decChar;
    private OutputFilterInterface ofi;
    private Thread getThread;
    private String user;
    private String pass;
    private Connection connection;

    public AS400Xtfr(tnvt v) {
        this.vt = v;
        this.status = new FTPStatusEvent(this);
        DecimalFormat formatter = (DecimalFormat)NumberFormat.getInstance(Locale.getDefault());
        this.decChar = formatter.getDecimalFormatSymbols().getDecimalSeparator();
    }

    public void setOutputFilter(OutputFilterInterface o) {
        this.ofi = o;
    }

    public void setDecimalChar(char dec) {
        this.decChar = dec;
    }

    public boolean connect(String host) {
        this.connection = null;
        this.hostName = host.toUpperCase();
        try {
            this.printFTPInfo("Connecting to " + this.hostName);
            Driver driver2 = (Driver)Class.forName("com.ibm.as400.access.AS400JDBCDriver").newInstance();
            DriverManager.registerDriver(driver2);
            this.connection = DriverManager.getConnection("jdbc:as400://" + this.hostName + ";decimal separator=" + this.decChar + ";extended metadata=true;translate binary=true", this.user, this.pass);
            this.printFTPInfo("jdbc:as400://" + this.hostName + ";decimal separator=" + this.decChar + ";extended metadata=true;translate binary=true");
            this.fireInfoEvent();
            this.printFTPInfo("Connected to " + this.hostName);
            return true;
        }
        catch (NoClassDefFoundError ncdf) {
            this.printFTPInfo("Error: JDBC Driver not found.  Please check classpath.");
        }
        catch (Exception e) {
            this.printFTPInfo("Error: " + e.getMessage() + "\n\nThere was an error connecting to host " + host.toUpperCase() + "\n\nPlease make sure that you run the command STRHOSTSVR");
            System.out.println("Exception while retrieving data : " + e.getMessage());
        }
        return false;
    }

    public void disconnect() {
    }

    public boolean isConnected() {
        return this.connected;
    }

    public synchronized void addFTPStatusListener(FTPStatusListener listener) {
        if (this.listeners == null) {
            this.listeners = new Vector(3);
        }
        this.listeners.addElement(listener);
    }

    private void fireStatusEvent() {
        if (this.listeners != null) {
            int size = this.listeners.size();
            for (int i = 0; i < size; ++i) {
                FTPStatusListener target = this.listeners.elementAt(i);
                target.statusReceived(this.status);
            }
        }
    }

    private void fireCommandEvent() {
        if (this.listeners != null) {
            int size = this.listeners.size();
            for (int i = 0; i < size; ++i) {
                FTPStatusListener target = this.listeners.elementAt(i);
                target.commandStatusReceived(this.status);
            }
        }
    }

    private void fireInfoEvent() {
        if (this.listeners != null) {
            int size = this.listeners.size();
            for (int i = 0; i < size; ++i) {
                FTPStatusListener target = this.listeners.elementAt(i);
                target.fileInfoReceived(this.status);
            }
        }
    }

    public synchronized void removeFTPStatusListener(FTPStatusListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(listener);
    }

    public boolean login(String user, String passWord) {
        this.aborted = false;
        this.loggedIn = true;
        this.user = user;
        this.pass = passWord;
        return true;
    }

    public boolean isFieldSelected(int which) {
        FileFieldDef ffD = (FileFieldDef)this.ffd.get(which);
        return ffD.isWriteField();
    }

    protected void selectAll() {
        for (int x = 0; x < this.ffd.size(); ++x) {
            FileFieldDef f = (FileFieldDef)this.ffd.get(x);
            f.setWriteField(true);
        }
    }

    protected void selectNone() {
        for (int x = 0; x < this.ffd.size(); ++x) {
            FileFieldDef f = (FileFieldDef)this.ffd.get(x);
            f.setWriteField(false);
        }
    }

    public boolean isFieldsSelected() {
        for (int x = 0; x < this.ffd.size(); ++x) {
            FileFieldDef f = (FileFieldDef)this.ffd.get(x);
            if (!f.isWriteField()) continue;
            return true;
        }
        return false;
    }

    public void setFieldSelected(int which, boolean value) {
        FileFieldDef ffD = (FileFieldDef)this.ffd.get(which);
        ffD.setWriteField(value);
    }

    public String getFieldName(int which) {
        FileFieldDef ffD = (FileFieldDef)this.ffd.get(which);
        return ffD.getFieldName();
    }

    public int getNumberOfFields() {
        return this.ffd.size();
    }

    public boolean getFile(String remoteFile, String localFile, String statement, boolean useInternal) {
        boolean flag = true;
        if (this.connection == null) {
            this.printFTPInfo("Not connected to any server!");
            return false;
        }
        final String localFileF = localFile;
        final String query = statement;
        final boolean internal = useInternal;
        Runnable getRun = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    DatabaseMetaData dmd = AS400Xtfr.this.connection.getMetaData();
                    Statement select = AS400Xtfr.this.connection.createStatement();
                    ResultSet rs = select.executeQuery(query);
                    ResultSetMetaData rsmd = rs.getMetaData();
                    int numCols = rsmd.getColumnCount();
                    ResultSet rsd = dmd.getColumns(null, "VISIONR", "CXREF", null);
                    while (rsd.next()) {
                        System.out.println(rsd.getString(12));
                    }
                    if (AS400Xtfr.this.ffd != null) {
                        AS400Xtfr.this.ffd.clear();
                        AS400Xtfr.this.ffd = null;
                    }
                    AS400Xtfr.this.ffd = new ArrayList();
                    AS400Xtfr.this.printFTPInfo("Number of columns: " + rsmd.getColumnCount());
                    for (int x = 1; x <= numCols; ++x) {
                        AS400Xtfr.this.printFTPInfo("Column " + x + ": " + rsmd.getColumnLabel(x) + " " + rsmd.getColumnName(x) + " " + rsmd.getColumnType(x) + " " + rsmd.getColumnTypeName(x) + " " + rsmd.getPrecision(x) + " " + rsmd.getScale(x) + " cn " + rsmd.getCatalogName(x) + " tn " + rsmd.getTableName(x) + " sn " + rsmd.getSchemaName(x));
                        FileFieldDef ffDesc = new FileFieldDef(AS400Xtfr.this.vt, AS400Xtfr.this.decChar);
                        if (internal) {
                            ffDesc.setFieldName(rsmd.getColumnName(x));
                        } else {
                            ffDesc.setFieldName(rsmd.getColumnLabel(x));
                        }
                        ffDesc.setNeedsTranslation(false);
                        ffDesc.setStartOffset("0");
                        ffDesc.setFieldLength(Integer.toString(rsmd.getColumnDisplaySize(x)));
                        ffDesc.setNumDigits(Integer.toString(rsmd.getPrecision(x)));
                        ffDesc.setDecPositions(Integer.toString(rsmd.getScale(x)));
                        switch (rsmd.getColumnType(x)) {
                            case 2: {
                                ffDesc.setFieldType("S");
                                break;
                            }
                            case 3: {
                                ffDesc.setFieldType("P");
                                break;
                            }
                            default: {
                                ffDesc.setFieldType(" ");
                            }
                        }
                        ffDesc.setFieldText("");
                        ffDesc.setWriteField(true);
                        AS400Xtfr.this.ffd.add(ffDesc);
                    }
                    AS400Xtfr.this.writeHeader(localFileF);
                    int processed = 0;
                    StringBuffer rb = new StringBuffer();
                    while (rs.next() && !AS400Xtfr.this.aborted) {
                        for (int x = 1; x <= numCols; ++x) {
                            ((FileFieldDef)AS400Xtfr.this.ffd.get(x - 1)).setFieldData(rs.getString(x));
                        }
                        AS400Xtfr.this.status.setCurrentRecord(processed++);
                        AS400Xtfr.this.status.setFileLength(processed + 1);
                        rb.setLength(0);
                        AS400Xtfr.this.ofi.parseFields(null, AS400Xtfr.this.ffd, rb);
                        AS400Xtfr.this.fireStatusEvent();
                    }
                    AS400Xtfr.this.printFTPInfo("Transfer Successful ");
                    AS400Xtfr.this.status.setCurrentRecord(processed);
                    AS400Xtfr.this.status.setFileLength(processed);
                    AS400Xtfr.this.fireStatusEvent();
                    AS400Xtfr.this.writeFooter();
                }
                catch (SQLException sqle) {
                    AS400Xtfr.this.printFTPInfo("SQL Exception ! " + sqle.getMessage());
                }
                catch (FileNotFoundException fnfe) {
                    AS400Xtfr.this.printFTPInfo("File Not found Exception ! " + fnfe.getMessage());
                }
                finally {
                    try {
                        if (AS400Xtfr.this.connection != null) {
                            AS400Xtfr.this.connection.close();
                        }
                    }
                    catch (SQLException sqle) {}
                    if (AS400Xtfr.this.ffd != null) {
                        AS400Xtfr.this.ffd.clear();
                        AS400Xtfr.this.ffd = null;
                    }
                    System.gc();
                }
            }
        };
        this.getThread = new Thread(getRun);
        this.getThread.start();
        return flag;
    }

    private void printFTPInfo(String msgText) {
        this.status.setMessage(msgText);
        this.fireCommandEvent();
    }

    private void writeHeader(String fileName) throws FileNotFoundException {
        this.ofi.createFileInstance(fileName);
        this.ofi.writeHeader(fileName, this.hostName, this.ffd, this.decChar);
    }

    private void writeFooter() {
        this.ofi.writeFooter(this.ffd);
    }
}

