/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.tools;

import java.awt.Component;
import java.awt.Container;
import java.util.Hashtable;
import org.tn5250j.tools.ENHGridLayout;

public class AlignLayout
extends ENHGridLayout {
    private static final long serialVersionUID = 1L;
    protected Hashtable alignment;
    protected Hashtable resize_width;
    protected Hashtable resize_height;
    public static final int TOP = 1;
    public static final int MIDDLE = 4;
    public static final int BOTTOM = 5;

    public AlignLayout() {
        this(2, 5, 5);
    }

    public AlignLayout(int cols, int hgap, int vgap) {
        super(0, cols, hgap, vgap);
    }

    private int get(Hashtable table, Component comp, int def) {
        Object v = table != null ? table.get("" + comp.hashCode()) : null;
        return v != null ? (Integer)v : def;
    }

    private boolean get(Hashtable table, Component comp, boolean def) {
        Object v = table != null ? table.get("" + comp.hashCode()) : null;
        return v != null ? (Boolean)v : def;
    }

    public int getLabelVerticalAlignment(Component child) {
        return this.get(this.alignment, child, 4);
    }

    public void setLabelVerticalAlignment(Component child, int align) {
        if (this.alignment == null) {
            this.alignment = new Hashtable(5);
        }
        this.alignment.put("" + child.hashCode(), new Integer(align));
    }

    public boolean getResizeWidth(Component child) {
        return this.get(this.resize_width, child, false);
    }

    public void setResizeWidth(Component child, boolean v) {
        if (this.resize_width == null) {
            this.resize_width = new Hashtable(5);
        }
        this.resize_width.put("" + child.hashCode(), new Boolean(v));
    }

    public boolean getResizeHeight(Component child) {
        return this.get(this.resize_height, child, false);
    }

    public void setResizeHeight(Component child, boolean v) {
        if (this.resize_height == null) {
            this.resize_height = new Hashtable(5);
        }
        this.resize_height.put("" + child.hashCode(), new Boolean(v));
    }

    protected boolean isLabel(int col) {
        return col % 2 == 0;
    }

    @Override
    protected void setBounds(int pos, int row, int col, Component comp, int x, int y, int col_width, int row_height) {
        Component control;
        int comp_w = col_width;
        int comp_h = row_height;
        if (this.isLabel(col) || !this.getResizeHeight(comp)) {
            comp_h = comp.getPreferredSize().height;
        }
        if (!this.isLabel(col)) {
            if (col >= this.col_widths.length - 1) {
                if (this.getResizeWidth(comp)) {
                    Container parent = comp.getParent();
                    comp_w = parent.getSize().width - parent.getInsets().right - x;
                } else {
                    comp_w = comp.getPreferredSize().width;
                }
            }
            comp.setBounds(x, y, comp_w, comp_h);
            return;
        }
        int control_h = row_height;
        if (pos < comp.getParent().getComponentCount() - 1 && (control = comp.getParent().getComponents()[pos + 1]) != null && !this.getResizeHeight(control)) {
            control_h = control.getPreferredSize().height;
        }
        switch (this.getLabelVerticalAlignment(comp)) {
            case 4: {
                y += (control_h - comp_h) / 2;
                break;
            }
            case 5: {
                y += control_h - comp_h;
            }
        }
        comp.setBounds(x, y, comp_w, comp_h);
    }
}

