/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.tools;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;

public class ENHGridLayout
extends GridLayout {
    private static final long serialVersionUID = 1L;
    protected int hgap;
    protected int vgap;
    protected int rows;
    protected int cols;
    protected int[] row_heights = new int[0];
    protected int[] col_widths = new int[0];
    public static final int VARIABLE = 0;

    public ENHGridLayout(int rows, int cols) {
        this(rows, cols, 0, 0);
    }

    public ENHGridLayout(int rows, int cols, int hgap, int vgap) {
        super(rows, cols, hgap, vgap);
        this.rows = rows;
        this.cols = cols;
        this.hgap = hgap;
        this.vgap = vgap;
    }

    protected void getGridSizes(Container parent, boolean min) {
        int ncomponents = parent.getComponentCount();
        if (ncomponents == 0) {
            return;
        }
        int nrows = this.rows;
        int ncols = this.cols;
        if (nrows > 0) {
            ncols = (ncomponents + nrows - 1) / nrows;
        } else {
            nrows = (ncomponents + ncols - 1) / ncols;
        }
        this.row_heights = new int[nrows];
        this.col_widths = new int[ncols];
        for (int i = 0; i < ncomponents; ++i) {
            int col;
            Component comp = parent.getComponent(i);
            Dimension d = min ? comp.getMinimumSize() : comp.getPreferredSize();
            int row = i / ncols;
            if (d.height > this.row_heights[row]) {
                this.row_heights[row] = d.height;
            }
            if (d.width <= this.col_widths[col = i % ncols]) continue;
            this.col_widths[col] = d.width;
        }
    }

    final int sum(int[] array) {
        if (array == null) {
            return 0;
        }
        int s = 0;
        for (int i = 0; i < array.length; ++i) {
            s += array[i];
        }
        return s;
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Insets insets = parent.getInsets();
        this.getGridSizes(parent, false);
        return new Dimension(insets.left + insets.right + this.sum(this.col_widths) + (this.col_widths.length + 1) * this.hgap, insets.top + insets.bottom + this.sum(this.row_heights) + (this.row_heights.length + 1) * this.vgap);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Insets insets = parent.getInsets();
        this.getGridSizes(parent, true);
        return new Dimension(insets.left + insets.right + this.sum(this.col_widths) + (this.col_widths.length + 1) * this.hgap, insets.top + insets.bottom + this.sum(this.row_heights) + (this.row_heights.length + 1) * this.vgap);
    }

    protected void setBounds(int pos, int row, int col, Component comp, int x, int y, int w, int h) {
        comp.setBounds(x, y, w, h);
    }

    @Override
    public void layoutContainer(Container parent) {
        int ncomponents = parent.getComponentCount();
        if (ncomponents == 0) {
            return;
        }
        Insets insets = parent.getInsets();
        this.getGridSizes(parent, false);
        int nrows = this.rows;
        int ncols = this.cols;
        if (nrows > 0) {
            ncols = (ncomponents + nrows - 1) / nrows;
        } else {
            nrows = (ncomponents + ncols - 1) / ncols;
        }
        Dimension psize = parent.getSize();
        int x = insets.left + this.hgap;
        for (int col = 0; col < ncols; ++col) {
            int y = insets.top + this.vgap;
            for (int row = 0; row < nrows; ++row) {
                int i = row * ncols + col;
                if (i < ncomponents) {
                    int w = Math.max(0, Math.min(this.col_widths[col], psize.width - insets.right - x));
                    int h = Math.max(0, Math.min(this.row_heights[row], psize.height - insets.bottom - y));
                    this.setBounds(i, row, col, parent.getComponent(i), x, y, w, h);
                }
                y += this.row_heights[row] + this.vgap;
            }
            x += this.col_widths[col] + this.hgap;
        }
    }
}

