/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.tools;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;

public class FixedCenterLayout
implements LayoutManager2,
Serializable {
    private static final long serialVersionUID = 1L;
    protected int hgap;
    protected Component west;
    protected Component east;
    protected Component center;

    public FixedCenterLayout() {
        this(0);
    }

    public FixedCenterLayout(int hgap) {
        this.hgap = hgap;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            if (constraints != null && !(constraints instanceof String)) {
                throw new IllegalArgumentException("Cannot add to layout: constraint must be a string or null");
            }
            this.addLayoutComponent((String)constraints, comp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(String name, Component comp) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            if (name == null || "Center".equals(name)) {
                this.center = comp;
            } else if ("East".equals(name)) {
                this.east = comp;
            } else if ("West".equals(name)) {
                this.west = comp;
            } else {
                throw new IllegalArgumentException("cannot add to layout: unknown constraint: " + name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLayoutComponent(Component component) {
        Object object = component.getTreeLock();
        synchronized (object) {
            if (component == this.center) {
                this.center = null;
            } else if (component == this.east) {
                this.east = null;
            } else if (component == this.west) {
                this.west = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension d = new Dimension(0, 0);
            this.addMinimumSize(d, this.east);
            this.addMinimumSize(d, this.west);
            this.addMinimumSize(d, this.center);
            Insets insets = target.getInsets();
            d.width += insets.left + insets.right;
            d.height += insets.top + insets.bottom;
            return d;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension d = new Dimension(0, 0);
            this.addPreferredSize(d, this.east);
            this.addPreferredSize(d, this.west);
            this.addPreferredSize(d, this.center);
            Insets insets = target.getInsets();
            d.width += insets.left + insets.right;
            d.height += insets.top + insets.bottom;
            return d;
        }
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            int leftCenter;
            Insets insets = target.getInsets();
            int top = insets.top;
            int bottom = target.getBounds().height - insets.bottom;
            int left = insets.left;
            int right = target.getBounds().width - insets.right;
            int rightCenter = leftCenter = (right - left) / 2;
            if (this.center != null) {
                Dimension d = this.center.getPreferredSize();
                leftCenter = (right - left - d.width) / 2;
                rightCenter = leftCenter + d.width;
                this.center.setBounds(leftCenter, top, d.width, bottom - top);
            }
            if (this.west != null) {
                this.west.setBounds(left, top, leftCenter - left - this.hgap, bottom - top);
            }
            if (this.east != null) {
                this.east.setBounds(rightCenter + this.hgap, top, right - rightCenter - 2 * this.hgap, bottom - top);
            }
        }
    }

    private void addMinimumSize(Dimension d, Component c) {
        if (c != null) {
            this.addSize(d, c.getMinimumSize());
        }
    }

    private void addPreferredSize(Dimension d, Component c) {
        if (c != null) {
            this.addSize(d, c.getPreferredSize());
        }
    }

    private void addSize(Dimension d, Dimension size) {
        d.width += size.width + this.hgap;
        d.height = Math.max(size.height, d.height);
    }

    public String toString() {
        return this.getClass().getName() + "[hgap=" + this.hgap + "]";
    }
}

