/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.tools;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class LangTool {
    private static Locale locale;
    private static ResourceBundle labels;

    public static void init() {
        if (labels != null) {
            return;
        }
        locale = Locale.getDefault();
        LangTool.init("tn5250jMsgs");
    }

    public static void init(Locale l) {
        if (labels != null) {
            return;
        }
        locale = l;
        LangTool.init("tn5250jMsgs");
    }

    public static void init(String initMsgFile) {
        if (labels != null) {
            return;
        }
        try {
            labels = ResourceBundle.getBundle(initMsgFile, locale);
        }
        catch (MissingResourceException mre) {
            System.out.println(mre.getLocalizedMessage());
        }
    }

    public static String getString(String key) {
        try {
            return labels.getString(key);
        }
        catch (MissingResourceException mre) {
            System.out.println(mre.getLocalizedMessage());
            return key;
        }
    }

    public static String getString(String key, String defaultString) {
        try {
            return labels.getString(key);
        }
        catch (MissingResourceException mre) {
            return defaultString;
        }
    }

    public static String messageFormat(String key, Object[] args) {
        return MessageFormat.format(LangTool.getString(key), args);
    }

    static {
        labels = null;
    }
}

