/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.tools;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.tn5250j.SessionPanel;
import org.tn5250j.interfaces.ConfigureFactory;
import org.tn5250j.scripting.ExecuteScriptAction;
import org.tn5250j.scripting.InterpreterDriverManager;
import org.tn5250j.tools.GUIGraphicsUtils;
import org.tn5250j.tools.LangTool;
import org.tn5250j.tools.Macronizer;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

public final class LoadMacroMenu {
    private static Vector macroVector = new Vector();
    private static final TN5250jLogger log = TN5250jLogFactory.getLogger(LoadMacroMenu.class);

    public static void loadMacros(SessionPanel session, JMenu menu) {
        int x;
        final SessionPanel ses = session;
        Vector<String> mv = new Vector<String>();
        menu.addSeparator();
        String[] macrosList = Macronizer.getMacroList();
        for (x = 0; x < macrosList.length; ++x) {
            mv.add(macrosList[x]);
        }
        Collections.sort(mv);
        for (x = 0; x < mv.size(); ++x) {
            AbstractAction action = new AbstractAction((String)mv.get(x)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ses.executeMacro(e);
                }
            };
            JMenuItem mi = menu.add(action);
            mi.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (SwingUtilities.isRightMouseButton(e)) {
                        LoadMacroMenu.doOptionsPopup(e, ses);
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (SwingUtilities.isRightMouseButton(e)) {
                        LoadMacroMenu.doOptionsPopup(e, ses);
                    }
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (SwingUtilities.isRightMouseButton(e)) {
                        LoadMacroMenu.doOptionsPopup(e, ses);
                    }
                }
            });
        }
        LoadMacroMenu.scriptDir("scripts", menu, session);
        String conPath = "";
        String conPath2 = "";
        try {
            conPath = new File("scripts").getCanonicalPath();
            conPath2 = new File(ConfigureFactory.getInstance().getProperty("emulator.settingsDirectory") + "scripts").getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!conPath.equals(conPath2)) {
            LoadMacroMenu.scriptDir(ConfigureFactory.getInstance().getProperty("emulator.settingsDirectory") + "scripts", menu, session);
        }
    }

    private static void doOptionsPopup(MouseEvent e, SessionPanel session) {
        JPopupMenu j = new JPopupMenu("Macro Options");
        AbstractAction action = new AbstractAction(LangTool.getString("popup.delete") + " " + ((JMenuItem)e.getSource()).getText()){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                StringBuffer macro = new StringBuffer(((JMenuItem)e.getSource()).getText());
                macro.delete(0, LangTool.getString("popup.delete").length() + 1);
                Macronizer.removeMacroByName(macro.toString());
            }
        };
        j.add(action);
        final SessionPanel ses = session;
        action = new AbstractAction(LangTool.getString("popup.execute") + " " + ((JMenuItem)e.getSource()).getText()){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                StringBuffer macro = new StringBuffer(((JMenuItem)e.getSource()).getText());
                macro.delete(0, LangTool.getString("popup.execute").length() + 1);
                Macronizer.invoke(macro.toString(), ses);
            }
        };
        j.add(action);
        MouseEvent et = SwingUtilities.convertMouseEvent((JMenuItem)e.getSource(), e, session);
        GUIGraphicsUtils.positionPopup(session, j, et.getX(), et.getY());
    }

    public static void scriptDir(String pathName, JMenu menu, SessionPanel session) {
        File root = new File(pathName);
        try {
            macroVector = new Vector();
            LoadMacroMenu.loadScripts(macroVector, root.getCanonicalPath(), root, session);
            LoadMacroMenu.createScriptsMenu(menu, macroVector, 0);
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
        }
    }

    private static void loadScripts(Vector vector, String path, File directory, SessionPanel session) {
        File[] macroFiles = directory.listFiles();
        if (macroFiles == null || macroFiles.length == 0) {
            return;
        }
        Arrays.sort(macroFiles, new MacroCompare());
        for (int i = 0; i < macroFiles.length; ++i) {
            try {
                File file = macroFiles[i];
                String fileName = file.getName();
                if (file.isHidden()) continue;
                if (file.isDirectory()) {
                    Vector<String> submenu = new Vector<String>();
                    submenu.addElement(fileName.replace('_', ' '));
                    LoadMacroMenu.loadScripts(submenu, path + fileName + '/', file, session);
                    vector.addElement(submenu);
                    continue;
                }
                if (!InterpreterDriverManager.isScriptSupported(fileName)) continue;
                String fn = fileName.replace('_', ' ');
                int index = fn.lastIndexOf(46);
                if (index > 0) {
                    fn = fn.substring(0, index);
                }
                ExecuteScriptAction action = new ExecuteScriptAction(fn, file.getAbsolutePath(), session){
                    private static final long serialVersionUID = 1L;
                };
                vector.addElement(action);
                continue;
            }
            catch (SecurityException se) {
                log.warn(se.getMessage());
            }
        }
    }

    private static void createScriptsMenu(JMenu menu, Vector vector, int start) {
        JPopupMenu jpop = new JPopupMenu();
        jpop.add("Delete");
        for (int i = start; i < vector.size(); ++i) {
            Object obj = vector.elementAt(i);
            if (obj instanceof ExecuteScriptAction) {
                menu.add((ExecuteScriptAction)obj);
                continue;
            }
            if (!(obj instanceof Vector)) continue;
            Vector subvector = (Vector)obj;
            String name = (String)subvector.elementAt(0);
            JMenu submenu = new JMenu(name);
            LoadMacroMenu.createScriptsMenu(submenu, subvector, 1);
            if (submenu.getMenuComponentCount() == 0) {
                submenu.add(LangTool.getString("popup.noScripts"));
            }
            menu.add(submenu);
        }
    }

    public static class MacroCompare
    implements Comparator {
        public int compare(Object one, Object two) {
            String s1 = one.toString();
            String s2 = two.toString();
            return s1.compareToIgnoreCase(s2);
        }
    }
}

