/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.tools.encoder;

import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.tn5250j.tools.encoder.Encoder;
import org.tn5250j.tools.encoder.EncoderException;

public class EncodeComponent {
    public static final Encoding PNG = new Encoding("PNG", "Portable Network Graphics", "org.tn5250j.tools.encoder.PNGEncoder", " PNG Load Error");
    public static final Encoding[] ENCODINGS = new Encoding[]{PNG};

    public static void encode(Encoding encoding, Component component, OutputStream output) throws IOException, EncoderException {
        Encoder encoder = encoding.getEncoder();
        if (encoder == null) {
            throw new EncoderException("Graphics Encoder could not be loaded.");
        }
        encoder.encode(component, output);
    }

    public static void encode(Encoding encoding, Component component, File file) throws IOException, EncoderException {
        FileOutputStream os = new FileOutputStream(file);
        EncodeComponent.encode(encoding, component, os);
        ((OutputStream)os).close();
    }

    public static class Encoding {
        private String shortName;
        private String longName;
        private String encoderClass;
        private String failureMessage;
        private Encoder encoder;

        public Encoding(String short_name, String long_name, String encoder_class, String failure_message) {
            this.shortName = short_name;
            this.longName = long_name;
            this.encoderClass = encoder_class;
            this.failureMessage = failure_message;
        }

        public String getShortName() {
            return this.shortName;
        }

        public String getLongName() {
            return this.longName;
        }

        public String toString() {
            return this.getLongName() + " (" + this.getShortName() + ")";
        }

        public String getFailureMessage() {
            return this.failureMessage != null ? this.failureMessage : "There was a failure loading encoder.";
        }

        public Encoder getEncoder() {
            if (this.encoder == null) {
                Class<?> encoder_class = null;
                try {
                    encoder_class = Class.forName(this.encoderClass);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (encoder_class != null) {
                    try {
                        this.encoder = (Encoder)encoder_class.newInstance();
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
            }
            return this.encoder;
        }
    }
}

