/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.tools.filters;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.tn5250j.tools.AlignLayout;
import org.tn5250j.tools.LangTool;
import org.tn5250j.tools.filters.FileFieldDef;
import org.tn5250j.tools.filters.OutputFilterInterface;

public class DelimitedOutputFilter
implements OutputFilterInterface {
    PrintStream fout = null;
    static String delimiter = ",";
    static String stringQualifier = "\"";
    StringBuffer sb = new StringBuffer();

    @Override
    public void createFileInstance(String fileName) throws FileNotFoundException {
        this.fout = new PrintStream(new FileOutputStream(fileName));
    }

    @Override
    public void parseFields(byte[] cByte, ArrayList ffd, StringBuffer rb) {
        block3: for (int x = 0; x < ffd.size(); ++x) {
            FileFieldDef f = (FileFieldDef)ffd.get(x);
            if (!f.isWriteField()) continue;
            switch (f.getFieldType()) {
                case 'P': 
                case 'S': {
                    rb.append(f.parseData(cByte).trim() + delimiter);
                    continue block3;
                }
                default: {
                    rb.append(stringQualifier + f.parseData(cByte).trim() + stringQualifier + delimiter);
                }
            }
        }
        this.fout.println(rb);
    }

    @Override
    public void writeHeader(String fileName, String host, ArrayList ffd, char decChar) {
        StringBuffer sb = new StringBuffer();
        for (int x = 0; x < ffd.size(); ++x) {
            FileFieldDef f = (FileFieldDef)ffd.get(x);
            if (!f.isWriteField()) continue;
            sb.append(f.getFieldName() + delimiter);
        }
        this.fout.println(sb.toString().toCharArray());
    }

    @Override
    public void writeFooter(ArrayList ffd) {
        this.fout.flush();
        this.fout.close();
    }

    @Override
    public boolean isCustomizable() {
        return true;
    }

    @Override
    public void setCustomProperties() {
        new DelimitedDialog(new JFrame());
    }

    class DelimitedDialog {
        public DelimitedDialog(JFrame parent) {
            JPanel opts = new JPanel();
            opts.setBorder(BorderFactory.createTitledBorder(LangTool.getString("delm.labelOptions")));
            opts.setLayout(new AlignLayout(2, 5, 5));
            JLabel fdl = new JLabel(LangTool.getString("delm.labelField"));
            JComboBox<String> fd = new JComboBox<String>();
            fd.addItem(",");
            fd.addItem(";");
            fd.addItem(":");
            fd.addItem("|");
            fd.addItem(LangTool.getString("delm.labelTab"));
            fd.addItem(LangTool.getString("delm.labelSpace"));
            fd.addItem(LangTool.getString("delm.labelNone"));
            if (delimiter.length() > 0) {
                if (delimiter.equals("\t")) {
                    fd.setSelectedItem(LangTool.getString("delm.labelTab"));
                } else if (delimiter.equals(" ")) {
                    fd.setSelectedItem(LangTool.getString("delm.labelSpace"));
                } else {
                    if (!(delimiter.equals(",") || delimiter.equals(";") || delimiter.equals(":") || delimiter.equals("|"))) {
                        fd.addItem(delimiter);
                    }
                    fd.setSelectedItem(delimiter);
                }
            } else {
                fd.setSelectedItem(LangTool.getString("delm.labelNone"));
            }
            fd.setEditable(true);
            JLabel tdl = new JLabel(LangTool.getString("delm.labelText"));
            JComboBox<String> td = new JComboBox<String>();
            td.addItem("\"");
            td.addItem("'");
            td.addItem(LangTool.getString("delm.labelNone"));
            if (stringQualifier.length() > 0) {
                if (!stringQualifier.equals("'") && !stringQualifier.equals("\"")) {
                    td.addItem(stringQualifier);
                }
                td.setSelectedItem(stringQualifier);
            } else {
                td.setSelectedItem(LangTool.getString("delm.labelNone"));
            }
            td.setEditable(true);
            opts.add(fdl);
            opts.add(fd);
            opts.add(tdl);
            opts.add(td);
            Object[] message = new Object[]{opts};
            Object[] options = new String[]{UIManager.getString("OptionPane.okButtonText"), UIManager.getString("OptionPane.cancelButtonText")};
            int result = JOptionPane.showOptionDialog(parent, message, LangTool.getString("delm.title"), -1, -1, null, options, options[0]);
            switch (result) {
                case 0: {
                    delimiter = (String)fd.getSelectedItem();
                    if (delimiter.equals(LangTool.getString("delm.labelSpace"))) {
                        delimiter = " ";
                    }
                    if (delimiter.equals(LangTool.getString("delm.labelTab"))) {
                        delimiter = "\t";
                    }
                    if (delimiter.equals(LangTool.getString("delm.labelNone"))) {
                        delimiter = "";
                    }
                    if (!(stringQualifier = (String)td.getSelectedItem()).equals(LangTool.getString("delm.labelNone"))) break;
                    stringQualifier = "";
                    break;
                }
                case 1: {
                    break;
                }
            }
        }
    }
}

