/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.tools.filters;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import org.tn5250j.tools.filters.FileFieldDef;
import org.tn5250j.tools.filters.OutputFilterInterface;

public class FixedWidthOutputFilter
implements OutputFilterInterface {
    PrintStream fout = null;
    StringBuffer sb = new StringBuffer();

    @Override
    public void createFileInstance(String fileName) throws FileNotFoundException {
        this.fout = new PrintStream(new FileOutputStream(fileName));
    }

    @Override
    public void parseFields(byte[] cByte, ArrayList ffd, StringBuffer rb) {
        block3: for (int x = 0; x < ffd.size(); ++x) {
            FileFieldDef f = (FileFieldDef)ffd.get(x);
            if (!f.isWriteField()) continue;
            switch (f.getFieldType()) {
                case 'P': 
                case 'S': {
                    rb.append(this.getFixedLength(cByte, f));
                    continue block3;
                }
                default: {
                    rb.append(this.getFixedLength(cByte, f));
                }
            }
        }
        this.fout.println(rb);
    }

    private String getFixedLength(byte[] cByte, FileFieldDef f) {
        this.sb.setLength(0);
        switch (f.getFieldType()) {
            case 'P': 
            case 'S': {
                this.sb.append(f.parseData(cByte));
                this.formatNumeric(this.sb);
                while (this.sb.length() < f.getFieldLength()) {
                    this.sb.insert(0, ' ');
                }
                break;
            }
            default: {
                this.sb.append(f.parseData(cByte));
                while (this.sb.length() < f.getFieldLength()) {
                    this.sb.append(' ');
                }
                break block0;
            }
        }
        return this.sb.toString();
    }

    private void formatNumeric(StringBuffer sb) {
        if (sb.length() == 0) {
            sb.append('0');
            return;
        }
        int len = sb.length();
        int counter = 0;
        boolean done = false;
        boolean neg = false;
        while (!done && counter < len) {
            switch (sb.charAt(counter)) {
                case ' ': 
                case '+': 
                case '0': {
                    sb.setCharAt(counter, ' ');
                    break;
                }
                case '-': {
                    sb.setCharAt(counter, ' ');
                    neg = true;
                    break;
                }
                default: {
                    done = true;
                }
            }
            if (done) continue;
            ++counter;
        }
        if (counter > 0) {
            --counter;
        }
        if (neg) {
            sb.setCharAt(counter, '-');
        }
        if (sb.length() == 0) {
            sb.append('0');
        }
    }

    @Override
    public void writeHeader(String fileName, String host, ArrayList ffd, char decChar) {
    }

    @Override
    public void writeFooter(ArrayList ffd) {
        this.fout.flush();
        this.fout.close();
    }

    @Override
    public boolean isCustomizable() {
        return false;
    }

    @Override
    public void setCustomProperties() {
    }
}

