/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.tools.filters;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import org.tn5250j.tools.filters.FileFieldDef;
import org.tn5250j.tools.filters.OutputFilterInterface;

public class KSpreadOutputFilter
implements OutputFilterInterface {
    private int row;
    StringBuffer sb;
    PrintStream fout = null;

    @Override
    public void createFileInstance(String fileName) throws FileNotFoundException {
        this.fout = new PrintStream(new FileOutputStream(fileName));
        this.row = 0;
        this.sb = new StringBuffer();
    }

    @Override
    public void parseFields(byte[] cByte, ArrayList ffd, StringBuffer rb) {
        ++this.row;
        int column = 1;
        for (int x = 0; x < ffd.size(); ++x) {
            FileFieldDef f = (FileFieldDef)ffd.get(x);
            if (!f.isWriteField()) continue;
            rb.append("    <cell row=\"" + this.row + "\"");
            rb.append(" column=\"" + column++ + "\" > \n");
            switch (f.getFieldType()) {
                case 'P': 
                case 'S': {
                    rb.append("     <format precision=\"" + f.getPrecision() + "\" > \n     </format>\n");
                    break;
                }
                default: {
                    rb.append("     <format/>\n");
                }
            }
            rb.append("    <text>");
            rb.append(this.tr2xml(f.parseData(cByte)));
            rb.append("</text> </cell>\n");
        }
        this.fout.println(rb);
        this.fout.flush();
    }

    private String tr2xml(String s) {
        this.sb.setLength(0);
        block5: for (int x = 0; x < s.length(); ++x) {
            switch (s.charAt(x)) {
                case '<': {
                    this.sb.append("&lt;");
                    continue block5;
                }
                case '>': {
                    this.sb.append("&gt;");
                    continue block5;
                }
                case '&': {
                    this.sb.append("&amp;");
                    continue block5;
                }
                default: {
                    this.sb.append(s.charAt(x));
                }
            }
        }
        return this.sb.toString();
    }

    @Override
    public void writeHeader(String fileName, String host, ArrayList ffd, char decChar) {
        String head = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE spreadsheet > <spreadsheet mime=\"application/x-kspread\" editor=\"KSpread\" >\n <paper format=\"A4\" orientation=\"Portrait\" >\n  <borders right=\"20\" left=\"20\" bottom=\"20\" top=\"20\" />\n  <head/>\n  <foot/>\n </paper>\n <locale positivePrefixCurrencySymbol=\"True\" negativeMonetarySignPosition=\"4\" negativePrefixCurrencySymbol=\"True\" fracDigits=\"2\" thousandsSeparator=\".\" dateFormat=\"%A %d %B %Y\" timeFormat=\"%H:%M:%S\" monetaryDecimalSymbol=\"" + decChar + "\" weekStartsMonday=\"True\" negativeSign=\"-\" positiveSign=\"+\" positiveMonetarySignPosition=\"4\" decimalSymbol=\"" + decChar + "\" dateFormatShort=\"%d.%m.%Y\" />\n <map markerColumn=\"1\" activeTable=\"Table1\" markerRow=\"1\" >\n  <table columnnumber=\"0\" borders=\"0\" hide=\"0\" grid=\"1\" formular=\"0\" lcmode=\"0\" name=\"Table1\" >";
        try {
            this.fout.write(head.getBytes());
            this.fout.write(10);
            ++this.row;
            int column = 1;
            for (int x = 0; x < ffd.size(); ++x) {
                FileFieldDef f = (FileFieldDef)ffd.get(x);
                if (!f.isWriteField()) continue;
                this.fout.print("   <cell row=\"" + this.row + "\"");
                this.fout.print(" column=\"" + column++ + "\" >\n");
                this.fout.print("    <format>\n");
                this.fout.print("     <font size=\"11\" style=\"\" bold=\"yes\" weight=\"75\" />\n");
                this.fout.print("    </format>\n    <text>");
                this.fout.print(f.getFieldName());
                this.fout.print("</text>\n   </cell>\n");
            }
            this.fout.flush();
        }
        catch (IOException ioex) {
            System.out.println(ioex.getMessage());
        }
    }

    @Override
    public void writeFooter(ArrayList ffd) {
        try {
            this.fout.write("  </table>\n".getBytes());
            this.fout.write(" </map>\n".getBytes());
            this.fout.write("</spreadsheet>\n".getBytes());
            this.fout.flush();
            this.fout.close();
        }
        catch (IOException ioex) {
            System.out.println(ioex.getMessage());
        }
    }

    @Override
    public boolean isCustomizable() {
        return false;
    }

    @Override
    public void setCustomProperties() {
    }
}

