/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.tools.filters;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.tn5250j.tools.filters.FileFieldDef;
import org.tn5250j.tools.filters.OutputFilterInterface;

public class OpenOfficeOutputFilter
implements OutputFilterInterface {
    private int row;
    StringBuffer sb;
    ZipOutputStream fout = null;

    @Override
    public void createFileInstance(String fileName) throws FileNotFoundException {
        this.fout = new ZipOutputStream(new FileOutputStream(fileName));
        this.fout.setMethod(8);
        this.writeManifestEntry();
        this.row = 0;
        this.sb = new StringBuffer();
    }

    private void writeManifestEntry() {
        String manifest = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE manifest:manifest PUBLIC \"-//OpenOffice.org//DTD Manifest 1.0//EN\" \"Manifest.dtd\" >\n<manifest:manifest xmlns:manifest=\"http://openoffice.org/2001/manifest\">\n <manifest:file-entry manifest:media-type=\"application/vnd.sun.xml.calc\" manifest:full-path=\"/\"/>\n <manifest:file-entry manifest:media-type=\"\" manifest:full-path=\"Pictures/\"/>\n <manifest:file-entry manifest:media-type=\"text/xml\" manifest:full-path=\"content.xml\"/>\n</manifest:manifest>\n";
        ZipEntry zipentry = new ZipEntry("meta-inf\\manifest.xml");
        zipentry.setTime(System.currentTimeMillis());
        try {
            this.fout.putNextEntry(zipentry);
            this.fout.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE manifest:manifest PUBLIC \"-//OpenOffice.org//DTD Manifest 1.0//EN\" \"Manifest.dtd\" >\n<manifest:manifest xmlns:manifest=\"http://openoffice.org/2001/manifest\">\n <manifest:file-entry manifest:media-type=\"application/vnd.sun.xml.calc\" manifest:full-path=\"/\"/>\n <manifest:file-entry manifest:media-type=\"\" manifest:full-path=\"Pictures/\"/>\n <manifest:file-entry manifest:media-type=\"text/xml\" manifest:full-path=\"content.xml\"/>\n</manifest:manifest>\n".getBytes());
            this.fout.closeEntry();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    @Override
    public void parseFields(byte[] cByte, ArrayList ffd, StringBuffer rb) {
        ++this.row;
        int c = 0;
        rb.append("   <table:table-row table:style-name=\"ro1\">\n");
        int x = 0;
        while (x < ffd.size()) {
            FileFieldDef f = (FileFieldDef)ffd.get(x);
            if (f.isWriteField()) {
                switch (f.getFieldType()) {
                    case 'P': 
                    case 'S': {
                        rb.append("    <table:table-cell table:style-name=\"ce" + c + "\" table:value-type=\"float\" table:value=\"" + this.tr2xml(f.parseData(cByte)) + "\">\n");
                        break;
                    }
                    default: {
                        rb.append("    <table:table-cell>\n");
                    }
                }
                rb.append("     <text:p>");
                rb.append(this.tr2xml(f.parseData(cByte)));
                rb.append("</text:p>\n");
                rb.append("    </table:table-cell>\n");
            }
            ++x;
            ++c;
        }
        rb.append("   </table:table-row>\n");
        try {
            this.fout.write(rb.toString().getBytes());
            this.fout.flush();
        }
        catch (IOException ioe) {
            System.out.println("parse fields " + ioe.getMessage());
        }
    }

    private String tr2xml(String s) {
        this.sb.setLength(0);
        block67: for (int x = 0; x < s.length(); ++x) {
            switch (s.charAt(x)) {
                case '<': {
                    this.sb.append("&lt;");
                    continue block67;
                }
                case '>': {
                    this.sb.append("&gt;");
                    continue block67;
                }
                case '&': {
                    this.sb.append("&amp;");
                    continue block67;
                }
                case '\u00c0': {
                    this.sb.append("&Agrave;");
                    continue block67;
                }
                case '\u00e0': {
                    this.sb.append("&agrave;");
                    continue block67;
                }
                case '\u00c1': {
                    this.sb.append("&Aacute;");
                    continue block67;
                }
                case '\u00e1': {
                    this.sb.append("&aacute;");
                    continue block67;
                }
                case '\u00c2': {
                    this.sb.append("&Acirc;");
                    continue block67;
                }
                case '\u00e2': {
                    this.sb.append("&acirc;");
                    continue block67;
                }
                case '\u00c3': {
                    this.sb.append("&Atilde;");
                    continue block67;
                }
                case '\u00e3': {
                    this.sb.append("&atilde;");
                    continue block67;
                }
                case '\u00c4': {
                    this.sb.append("&Auml;");
                    continue block67;
                }
                case '\u00e4': {
                    this.sb.append("&auml;");
                    continue block67;
                }
                case '\u00c5': {
                    this.sb.append("&Aring;");
                    continue block67;
                }
                case '\u00e5': {
                    this.sb.append("&aring;");
                    continue block67;
                }
                case '\u00c6': {
                    this.sb.append("&AElig;");
                    continue block67;
                }
                case '\u00e6': {
                    this.sb.append("&aelig;");
                    continue block67;
                }
                case '\u00c7': {
                    this.sb.append("&Ccedil;");
                    continue block67;
                }
                case '\u00e7': {
                    this.sb.append("&ccedil;");
                    continue block67;
                }
                case '\u00c8': {
                    this.sb.append("&Egrave;");
                    continue block67;
                }
                case '\u00e8': {
                    this.sb.append("&egrave;");
                    continue block67;
                }
                case '\u00c9': {
                    this.sb.append("&Eacute;");
                    continue block67;
                }
                case '\u00e9': {
                    this.sb.append("&eacute;");
                    continue block67;
                }
                case '\u00ca': {
                    this.sb.append("&Ecirc;");
                    continue block67;
                }
                case '\u00ea': {
                    this.sb.append("&ecirc;");
                    continue block67;
                }
                case '\u00cb': {
                    this.sb.append("&Euml;");
                    continue block67;
                }
                case '\u00eb': {
                    this.sb.append("&euml;");
                    continue block67;
                }
                case '\u00cc': {
                    this.sb.append("&Igrave;");
                    continue block67;
                }
                case '\u00ec': {
                    this.sb.append("&igrave;");
                    continue block67;
                }
                case '\u00cd': {
                    this.sb.append("&Iacute;");
                    continue block67;
                }
                case '\u00ed': {
                    this.sb.append("&iacute;");
                    continue block67;
                }
                case '\u00ce': {
                    this.sb.append("&Icirc;");
                    continue block67;
                }
                case '\u00ee': {
                    this.sb.append("&icirc;");
                    continue block67;
                }
                case '\u00cf': {
                    this.sb.append("&Iuml;");
                    continue block67;
                }
                case '\u00ef': {
                    this.sb.append("&iuml;");
                    continue block67;
                }
                case '\u00d0': {
                    this.sb.append("&ETH;");
                    continue block67;
                }
                case '\u00f0': {
                    this.sb.append("&eth;");
                    continue block67;
                }
                case '\u00d1': {
                    this.sb.append("&Ntilde;");
                    continue block67;
                }
                case '\u00f1': {
                    this.sb.append("&ntilde;");
                    continue block67;
                }
                case '\u00d2': {
                    this.sb.append("&Ograve;");
                    continue block67;
                }
                case '\u00f2': {
                    this.sb.append("&ograve;");
                    continue block67;
                }
                case '\u00d3': {
                    this.sb.append("&Oacute;");
                    continue block67;
                }
                case '\u00f3': {
                    this.sb.append("&oacute;");
                    continue block67;
                }
                case '\u00d4': {
                    this.sb.append("&Ocirc;");
                    continue block67;
                }
                case '\u00f4': {
                    this.sb.append("&ocirc;");
                    continue block67;
                }
                case '\u00d5': {
                    this.sb.append("&Otilde;");
                    continue block67;
                }
                case '\u00f5': {
                    this.sb.append("&otilde;");
                    continue block67;
                }
                case '\u00d6': {
                    this.sb.append("&Ouml;");
                    continue block67;
                }
                case '\u00f6': {
                    this.sb.append("&ouml;");
                    continue block67;
                }
                case '\u00d8': {
                    this.sb.append("&Oslash;");
                    continue block67;
                }
                case '\u00f8': {
                    this.sb.append("&oslash;");
                    continue block67;
                }
                case '\u00d9': {
                    this.sb.append("&Ugrave;");
                    continue block67;
                }
                case '\u00f9': {
                    this.sb.append("&ugrave;");
                    continue block67;
                }
                case '\u00da': {
                    this.sb.append("&Uacute;");
                    continue block67;
                }
                case '\u00fa': {
                    this.sb.append("&uacute;");
                    continue block67;
                }
                case '\u00db': {
                    this.sb.append("&Ucirc;");
                    continue block67;
                }
                case '\u00fb': {
                    this.sb.append("&ucirc;");
                    continue block67;
                }
                case '\u00dc': {
                    this.sb.append("&Uuml;");
                    continue block67;
                }
                case '\u00fc': {
                    this.sb.append("&uuml;");
                    continue block67;
                }
                case '\u00dd': {
                    this.sb.append("&Yacute;");
                    continue block67;
                }
                case '\u00fd': {
                    this.sb.append("&yacute;");
                    continue block67;
                }
                case '\u00de': {
                    this.sb.append("&THORN;");
                    continue block67;
                }
                case '\u00fe': {
                    this.sb.append("&thorn;");
                    continue block67;
                }
                case '\u00df': {
                    this.sb.append("&szlig;");
                    continue block67;
                }
                case '\u00ff': {
                    this.sb.append("&yuml;");
                    continue block67;
                }
                default: {
                    this.sb.append(s.charAt(x));
                }
            }
        }
        return this.sb.toString();
    }

    @Override
    public void writeHeader(String fileName, String host, ArrayList ffd, char decChar) {
        String header1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE office:document-content PUBLIC \"-//OpenOffice.org//DTD OfficeDocument 1.0//EN\" \"office.dtd\" >\n<office:document-content xmlns:office=\"http://openoffice.org/2000/office\" xmlns:style=\"http://openoffice.org/2000/style\" xmlns:text=\"http://openoffice.org/2000/text\" xmlns:table=\"http://openoffice.org/2000/table\" xmlns:draw=\"http://openoffice.org/2000/drawing\" xmlns:fo=\"http://www.w3.org/1999/XSL/Format\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:number=\"http://openoffice.org/2000/datastyle\" xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns:chart=\"http://openoffice.org/2000/chart\" xmlns:dr3d=\"http://openoffice.org/2000/dr3d\" xmlns:math=\"http://www.w3.org/1998/Math/MathML\" xmlns:form=\"http://openoffice.org/2000/form\" xmlns:script=\"http://openoffice.org/2000/script\" office:class=\"spreadsheet\" office:version=\"1.0\">\n <office:script/>\n <office:font-decls>\n  <style:font-decl style:name=\"Arial Unicode MS\" fo:font-family=\"&apos;Arial Unicode MS&apos;\" style:font-pitch=\"variable\"/>\n  <style:font-decl style:name=\"HG Mincho Light J\" fo:font-family=\"&apos;HG Mincho Light J&apos;\" style:font-pitch=\"variable\"/>\n  <style:font-decl style:name=\"Albany\" fo:font-family=\"Albany\" style:font-family-generic=\"swiss\" style:font-pitch=\"variable\"/> \n </office:font-decls>\n <office:automatic-styles>\n  <style:style style:name=\"co1\" style:family=\"table-column\">\n   <style:properties fo:break-before=\"auto\" style:column-width=\"0.8925inch\"/>\n  </style:style>\n  <style:style style:name=\"ro1\" style:family=\"table-row\">\n   <style:properties fo:break-before=\"auto\"/>\n  </style:style>\n  <style:style style:name=\"ta1\" style:family=\"table\" style:master-page-name=\"Default\">\n   <style:properties table:display=\"true\"/>\n  </style:style>\n";
        String header2 = " </office:automatic-styles>\n <office:body>\n  <table:table table:name=\"Sheet1\" table:style-name=\"ta1\">\n   <table:table-column table:style-name=\"co1\" table:number-columns-repeated=\"251\" table:default-cell-style-name=\"Default\"/>\n";
        ZipEntry zipentry = new ZipEntry("content.xml");
        zipentry.setTime(System.currentTimeMillis());
        try {
            FileFieldDef f;
            this.fout.putNextEntry(zipentry);
            this.fout.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE office:document-content PUBLIC \"-//OpenOffice.org//DTD OfficeDocument 1.0//EN\" \"office.dtd\" >\n<office:document-content xmlns:office=\"http://openoffice.org/2000/office\" xmlns:style=\"http://openoffice.org/2000/style\" xmlns:text=\"http://openoffice.org/2000/text\" xmlns:table=\"http://openoffice.org/2000/table\" xmlns:draw=\"http://openoffice.org/2000/drawing\" xmlns:fo=\"http://www.w3.org/1999/XSL/Format\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:number=\"http://openoffice.org/2000/datastyle\" xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns:chart=\"http://openoffice.org/2000/chart\" xmlns:dr3d=\"http://openoffice.org/2000/dr3d\" xmlns:math=\"http://www.w3.org/1998/Math/MathML\" xmlns:form=\"http://openoffice.org/2000/form\" xmlns:script=\"http://openoffice.org/2000/script\" office:class=\"spreadsheet\" office:version=\"1.0\">\n <office:script/>\n <office:font-decls>\n  <style:font-decl style:name=\"Arial Unicode MS\" fo:font-family=\"&apos;Arial Unicode MS&apos;\" style:font-pitch=\"variable\"/>\n  <style:font-decl style:name=\"HG Mincho Light J\" fo:font-family=\"&apos;HG Mincho Light J&apos;\" style:font-pitch=\"variable\"/>\n  <style:font-decl style:name=\"Albany\" fo:font-family=\"Albany\" style:font-family-generic=\"swiss\" style:font-pitch=\"variable\"/> \n </office:font-decls>\n <office:automatic-styles>\n  <style:style style:name=\"co1\" style:family=\"table-column\">\n   <style:properties fo:break-before=\"auto\" style:column-width=\"0.8925inch\"/>\n  </style:style>\n  <style:style style:name=\"ro1\" style:family=\"table-row\">\n   <style:properties fo:break-before=\"auto\"/>\n  </style:style>\n  <style:style style:name=\"ta1\" style:family=\"table\" style:master-page-name=\"Default\">\n   <style:properties table:display=\"true\"/>\n  </style:style>\n".getBytes());
            int n100 = 100;
            int ce = 0;
            String s = "";
            int k = 0;
            while (k < ffd.size()) {
                f = (FileFieldDef)ffd.get(k);
                if (f.isWriteField() && (f.getFieldType() == 'P' || f.getFieldType() == 'S')) {
                    s = "  <number:number-style style:name=\"N" + (n100 + ce) + "\" style:family=\"data-style\" number:title=\"User-defined\">\n   <number:number number:decimal-places=\"" + f.getPrecision() + "\" number:min-integer-digits=\"1\"/>\n  </number:number-style>\n  <style:style style:name=\"ce" + ce + "\" style:family=\"table-cell\" style:parent-style-name=\"Default\" style:data-style-name=\"N" + (n100 + ce) + "\"/>\n";
                    this.fout.write(s.getBytes());
                }
                ++k;
                ++ce;
            }
            this.fout.write(" </office:automatic-styles>\n <office:body>\n  <table:table table:name=\"Sheet1\" table:style-name=\"ta1\">\n   <table:table-column table:style-name=\"co1\" table:number-columns-repeated=\"251\" table:default-cell-style-name=\"Default\"/>\n".getBytes());
            ++this.row;
            boolean column = true;
            this.fout.write("   <table:table-row table:style-name=\"ro1\">\n".getBytes());
            for (int x = 0; x < ffd.size(); ++x) {
                f = (FileFieldDef)ffd.get(x);
                if (!f.isWriteField()) continue;
                this.fout.write("    <table:table-cell>\n".getBytes());
                this.fout.write("     <text:p>".getBytes());
                this.fout.write(f.getFieldName().getBytes());
                this.fout.write("</text:p>\n".getBytes());
                this.fout.write("    </table:table-cell>\n".getBytes());
            }
            this.fout.write("   </table:table-row>\n".getBytes());
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    @Override
    public void writeFooter(ArrayList ffd) {
        String footer = "  </table:table>\n  <table:table table:name=\"Sheet2\" table:style-name=\"ta1\">\n   <table:table-column table:style-name=\"co1\" table:default-cell-style-name=\"Default\"/>\n   <table:table-row table:style-name=\"ro1\">\n    <table:table-cell/>\n   </table:table-row>\n  </table:table>\n  <table:table table:name=\"Sheet3\" table:style-name=\"ta1\">\n   <table:table-column table:style-name=\"co1\" table:default-cell-style-name=\"Default\"/>\n   <table:table-row table:style-name=\"ro1\">\n    <table:table-cell/>\n   </table:table-row>\n  </table:table>\n </office:body>\n</office:document-content>";
        try {
            this.fout.write("  </table:table>\n  <table:table table:name=\"Sheet2\" table:style-name=\"ta1\">\n   <table:table-column table:style-name=\"co1\" table:default-cell-style-name=\"Default\"/>\n   <table:table-row table:style-name=\"ro1\">\n    <table:table-cell/>\n   </table:table-row>\n  </table:table>\n  <table:table table:name=\"Sheet3\" table:style-name=\"ta1\">\n   <table:table-column table:style-name=\"co1\" table:default-cell-style-name=\"Default\"/>\n   <table:table-row table:style-name=\"ro1\">\n    <table:table-cell/>\n   </table:table-row>\n  </table:table>\n </office:body>\n</office:document-content>".getBytes());
            this.fout.flush();
            this.fout.close();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    @Override
    public boolean isCustomizable() {
        return false;
    }

    @Override
    public void setCustomProperties() {
    }
}

