/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.tools.system;

import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Properties;
import org.tn5250j.ExternalProgramConfig;
import org.tn5250j.interfaces.ConfigureFactory;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

public class OperatingSystem {
    private static final TN5250jLogger LOG = TN5250jLogFactory.getLogger("org.tn5250j.tools.system.OperatingSystem");
    private static final String WIN_PATH = "rundll32";
    private static final String WIN_FLAG = "url.dll,FileProtocolHandler";
    private static final String UNIX_PATH = "netscape";
    private static final String UNIX_FLAG = "-remote openURL";
    private static final int UNIX = 201527;
    private static final int WINDOWS_9x = 1600;
    private static final int WINDOWS_NT = 1638;
    private static final int OS2 = 57005;
    private static final int MAC_OS_X = 2748;
    private static final int UNKNOWN = 2989;
    private static final int LINUX = 4919;
    private static int os;
    private static boolean java14;

    public static final Rectangle getScreenBounds() {
        int h;
        int w;
        int y;
        int x;
        int screenX = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        int screenY = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        if (OperatingSystem.isMacOS()) {
            x = 0;
            y = 22;
            w = screenX;
            h = screenY - y - 4;
        } else if (OperatingSystem.isWindows()) {
            x = -4;
            y = -4;
            w = screenX - 2 * x;
            h = screenY - 2 * y;
        } else {
            x = 0;
            y = 0;
            w = screenX;
            h = screenY;
        }
        return new Rectangle(x, y, w, h);
    }

    public static final boolean isWindows() {
        return os == 1600 || os == 1638;
    }

    public static final boolean isUnix() {
        return os == 201527 || os == 2748 || os == 4919;
    }

    public static final boolean isMacOS() {
        return os == 2748;
    }

    public static final boolean hasJava14() {
        return java14;
    }

    public static void displayURL(String url) {
        block16: {
            Object format;
            if (OperatingSystem.launchExternalProgram(url)) {
                return;
            }
            String command = null;
            String protocol = "";
            URL urlUrl = null;
            try {
                urlUrl = new URL(url);
                protocol = urlUrl.getProtocol();
                if (protocol.startsWith("http")) {
                    protocol = "http";
                }
            }
            catch (MalformedURLException e) {
                LOG.warn(e.getMessage());
            }
            Properties props = ConfigureFactory.getInstance().getProperties("sessions");
            if (props.getProperty("emul.protocol." + protocol, "").trim().length() > 0) {
                String commandTemplate = props.getProperty("emul.protocol." + protocol).trim();
                Object[] urlParm = new Object[]{url};
                if (commandTemplate.lastIndexOf("{0}") == -1) {
                    commandTemplate = commandTemplate + " {0}";
                }
                format = new MessageFormat(commandTemplate);
                try {
                    command = ((Format)format).format(urlParm);
                }
                catch (Exception exx) {
                    LOG.warn("Unable to parse the url " + url + " using command " + commandTemplate);
                }
            }
            if (command != null && command.trim().length() > 0) {
                OperatingSystem.execute(command);
            } else {
                boolean windows = OperatingSystem.isWindows();
                String cmd = null;
                try {
                    if (windows) {
                        cmd = "rundll32 url.dll,FileProtocolHandler " + url;
                        format = Runtime.getRuntime().exec(cmd);
                        break block16;
                    }
                    cmd = "netscape -remote openURL(" + url + ")";
                    Process p = Runtime.getRuntime().exec(cmd);
                    try {
                        int exitCode = p.waitFor();
                        if (exitCode != 0) {
                            cmd = "netscape " + url;
                            p = Runtime.getRuntime().exec(cmd);
                        }
                    }
                    catch (InterruptedException x) {
                        LOG.warn("Error bringing up browser, cmd='" + cmd + "'");
                        LOG.warn("Caught: " + x);
                    }
                }
                catch (IOException x) {
                    LOG.warn("Could not invoke browser, command=" + cmd);
                    LOG.warn("Caught: " + x);
                }
            }
        }
    }

    private static boolean launchExternalProgram(String url) {
        try {
            Properties properties = ExternalProgramConfig.getInstance().getEtnPgmProps();
            String count = properties.getProperty("etn.pgm.support.total.num");
            if (count != null && count.length() > 0) {
                int total = Integer.parseInt(count);
                for (int i = 1; i <= total; ++i) {
                    String program = properties.getProperty("etn.pgm." + i + ".command.name");
                    if (!url.toLowerCase().startsWith(program.toLowerCase())) continue;
                    String params = url.substring(program.length() + 1);
                    params = params.replace(',', ' ');
                    String command = OperatingSystem.isWindows() ? properties.getProperty("etn.pgm." + i + ".command.window") + " " + params : properties.getProperty("etn.pgm." + i + ".command.unix") + " " + params;
                    LOG.info("Execute External Program: " + command);
                    OperatingSystem.execute(command);
                    return true;
                }
            }
        }
        catch (Exception exx) {
            LOG.warn("Unable to run External Program: " + exx.getMessage());
        }
        return false;
    }

    public static int execute(String command) {
        int exitCode = -1;
        try {
            LOG.info("Executing command='" + command + "'");
            Process p = Runtime.getRuntime().exec(command);
            exitCode = 0;
        }
        catch (IOException ioe) {
            LOG.warn("Error processing command, command='" + command + "'");
            LOG.warn("Caught: " + ioe.getMessage());
        }
        return exitCode;
    }

    static {
        if (System.getProperty("mrj.version") != null) {
            os = 2748;
        } else {
            String osName = System.getProperty("os.name");
            if (osName.indexOf("Windows 9") != -1 || osName.indexOf("Windows M") != -1) {
                os = 1600;
            } else if (osName.indexOf("Windows") != -1) {
                os = 1638;
            } else if (osName.indexOf("OS/2") != -1) {
                os = 57005;
            } else if (File.separatorChar == '/') {
                os = 201527;
            } else if (osName.toLowerCase().indexOf("linux") != -1) {
                os = 4919;
            } else {
                os = 2989;
                LOG.warn("Unknown operating system: " + osName);
            }
        }
        if (System.getProperty("java.version").compareTo("1.4") >= 0) {
            java14 = true;
        }
    }
}

