/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;
import org.tn5250j.event.BootEvent;
import org.tn5250j.event.BootListener;

public class BootStrapper
extends Thread {
    private Socket socket = null;
    private ServerSocket serverSocket = null;
    boolean listening = true;
    private Vector<BootListener> listeners;
    private BootEvent bootEvent;

    public BootStrapper() {
        super("BootStrapper");
        try {
            this.serverSocket = new ServerSocket(3036);
        }
        catch (IOException e) {
            System.err.println("Could not listen on port: 3036.");
        }
    }

    @Override
    public void run() {
        System.out.println("BootStrapper listening");
        while (true) {
            this.listen();
            this.getNewSessionOptions();
            System.out.println("got one");
        }
    }

    public synchronized void addBootListener(BootListener listener) {
        if (this.listeners == null) {
            this.listeners = new Vector(3);
        }
        this.listeners.addElement(listener);
    }

    private void fireBootEvent() {
        if (this.listeners != null) {
            int size = this.listeners.size();
            for (int i = 0; i < size; ++i) {
                BootListener target = this.listeners.elementAt(i);
                target.bootOptionsReceived(this.bootEvent);
            }
        }
    }

    private void listen() {
        try {
            this.socket = this.serverSocket.accept();
        }
        catch (IOException ioe) {
            System.out.println(this.getName() + ": " + ioe.getMessage());
        }
    }

    private void getNewSessionOptions() {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.bootEvent = new BootEvent(this, in.readLine());
            System.out.println(this.bootEvent.getNewSessionOptions());
            this.fireBootEvent();
            in.close();
            this.socket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

