/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j;

import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import org.tn5250j.SessionConfig;
import org.tn5250j.keyboard.KeyMnemonic;
import org.tn5250j.keyboard.KeyMnemonicResolver;
import org.tn5250j.tools.LangTool;

class KeypadPanel
extends JPanel {
    private static final long serialVersionUID = -7460283401326716314L;
    private static final int MIN_FONT_SIZE = 3;
    private static final int NO_OF_BUTTONS_PER_ROW = 15;
    private final KeyMnemonicResolver keyMnemonicResolver = new KeyMnemonicResolver();
    private final SessionConfig.SessionConfiguration configuration;
    private JButton[] buttons;

    KeypadPanel(SessionConfig.SessionConfiguration sessionConfiguration) {
        this.configuration = sessionConfiguration;
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setLayout(new BoxLayout(this, 1));
        this.addComponentListener(new KeypadPanelComponentListener());
        this.reInitializeButtons(this.configuration.getKeypadMnemonics());
    }

    void reInitializeButtons(KeyMnemonic[] keyMnemonics) {
        this.removeAll();
        Insets noMargin = new Insets(0, 0, 0, 0);
        CompoundBorder minimalBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(), BorderFactory.createEmptyBorder(2, 3, 3, 3));
        this.buttons = new JButton[keyMnemonics.length];
        Container buttonPanel = null;
        for (int i = 0; i < this.buttons.length; ++i) {
            KeyMnemonic mnemonic = keyMnemonics[i];
            this.buttons[i] = this.createButton(mnemonic, noMargin, minimalBorder);
            if (buttonPanel == null || i % 15 == 0) {
                buttonPanel = new JPanel(new GridLayout(1, 15, 0, 0));
                this.add(buttonPanel);
            }
            buttonPanel.add(this.buttons[i]);
        }
        this.addInvisibleButtonsToPreventLayout((JPanel)buttonPanel);
    }

    void updateButtonFontSize(float fontSize) {
        if (0 == this.buttons.length) {
            return;
        }
        JButton referenceButton = this.buttons[0];
        Font buttonFont = referenceButton.getFont();
        buttonFont = buttonFont.deriveFont(fontSize);
        FontMetrics fm = referenceButton.getFontMetrics(buttonFont);
        Rectangle viewRect = referenceButton.getVisibleRect();
        Insets i = referenceButton.getInsets();
        viewRect.x = i.left;
        viewRect.y = i.top;
        viewRect.width = referenceButton.getWidth() - (i.right + viewRect.x);
        viewRect.height = referenceButton.getHeight() - (i.bottom + viewRect.y);
        Rectangle textRect = new Rectangle();
        Rectangle iconRect = new Rectangle();
        boolean textIconGap = false;
        Icon icon = null;
        String largestText = this.findLargestText();
        while (SwingUtilities.layoutCompoundLabel(fm, largestText, icon, referenceButton.getVerticalAlignment(), referenceButton.getHorizontalAlignment(), referenceButton.getVerticalTextPosition(), referenceButton.getHorizontalTextPosition(), viewRect, iconRect, textRect, 0).endsWith("...") && fontSize > 2.0f) {
            buttonFont = buttonFont.deriveFont(fontSize -= 1.0f);
            fm = referenceButton.getFontMetrics(buttonFont);
        }
        if (fontSize >= 3.0f) {
            for (JButton button : this.buttons) {
                button.setFont(buttonFont);
            }
        }
    }

    private JButton createButton(KeyMnemonic mnemonic, Insets noMargin, CompoundBorder minimalBorder) {
        JButton b = new JButton();
        b.setMargin(noMargin);
        b.setBorder(minimalBorder);
        b.setText(LangTool.getString("KP_" + mnemonic.name(), this.keyMnemonicResolver.getDescription(mnemonic)));
        b.setActionCommand(mnemonic.mnemonic);
        return b;
    }

    private void addInvisibleButtonsToPreventLayout(JPanel bottomPanel) {
        if (this.buttons.length > 15 && this.buttons.length % 15 > 0) {
            for (int i = this.buttons.length % 15; i < 15; ++i) {
                JButton button = new JButton();
                button.setVisible(false);
                bottomPanel.add(button);
            }
        }
    }

    void addActionListener(ActionListener actionlistener) {
        for (JButton button : this.buttons) {
            button.addActionListener(actionlistener);
        }
    }

    private void maximizeButtonSize() {
        this.updateButtonFontSize(this.configuration.getKeypadFontSize());
    }

    private String findLargestText() {
        String text = "";
        for (JButton button : this.buttons) {
            if (button.getText().length() <= text.length()) continue;
            text = button.getText();
        }
        return text;
    }

    private class KeypadPanelComponentListener
    extends ComponentAdapter {
        private KeypadPanelComponentListener() {
        }

        @Override
        public void componentShown(ComponentEvent e) {
            KeypadPanel.this.maximizeButtonSize();
        }

        @Override
        public void componentResized(ComponentEvent e) {
            KeypadPanel.this.maximizeButtonSize();
        }
    }
}

