/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.tn5250j.BootStrapper;
import org.tn5250j.Gui5250Frame;
import org.tn5250j.Session5250;
import org.tn5250j.SessionPanel;
import org.tn5250j.connectdialog.ConnectDialog;
import org.tn5250j.event.BootEvent;
import org.tn5250j.event.BootListener;
import org.tn5250j.event.EmulatorActionEvent;
import org.tn5250j.event.EmulatorActionListener;
import org.tn5250j.event.SessionChangeEvent;
import org.tn5250j.event.SessionListener;
import org.tn5250j.framework.Tn5250jController;
import org.tn5250j.framework.common.SessionManager;
import org.tn5250j.framework.common.Sessions;
import org.tn5250j.gui.TN5250jSplashScreen;
import org.tn5250j.interfaces.ConfigureFactory;
import org.tn5250j.interfaces.GUIViewInterface;
import org.tn5250j.tools.LangTool;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

public class My5250
implements BootListener,
SessionListener,
EmulatorActionListener {
    private static final String PARAM_START_SESSION = "-s";
    private GUIViewInterface frame1;
    private String[] sessionArgs = null;
    private static Properties sessions = new Properties();
    private static BootStrapper strapper = null;
    private SessionManager manager;
    private static List<GUIViewInterface> frames;
    private TN5250jSplashScreen splash;
    private int step;
    private StringBuilder viewNamesForNextStartBuilder = null;
    private TN5250jLogger log = TN5250jLogFactory.getLogger(this.getClass());

    My5250() {
        this.splash = new TN5250jSplashScreen("tn5250jSplash.jpg");
        this.splash.setSteps(5);
        this.splash.setVisible(true);
        this.loadLookAndFeel();
        My5250.loadSessions();
        this.splash.updateProgress(++this.step);
        this.initJarPaths();
        this.initScripting();
        frames = new ArrayList<GUIViewInterface>();
        this.newView();
        this.setDefaultLocale();
        this.manager = SessionManager.instance();
        this.splash.updateProgress(++this.step);
        Tn5250jController.getCurrent();
    }

    private void loadLookAndFeel() {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (Exception e) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static boolean checkBootStrapper(String[] args) {
        try {
            Socket boot = new Socket("localhost", 3036);
            PrintWriter out = new PrintWriter(boot.getOutputStream(), true);
            String opts = null;
            for (int x = 0; x < args.length; ++x) {
                opts = opts != null ? opts + args[x] + " " : args[x] + " ";
            }
            out.println(opts);
            out.flush();
            out.close();
            boot.close();
            return true;
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void bootOptionsReceived(BootEvent bootEvent) {
        this.log.info(" boot options received " + bootEvent.getNewSessionOptions());
        ConfigureFactory.getInstance().reloadSettings();
        if (!bootEvent.getNewSessionOptions().equals("null")) {
            String[] args = new String[20];
            My5250.parseArgs(bootEvent.getNewSessionOptions(), args);
            if (My5250.isSpecified(PARAM_START_SESSION, args)) {
                String sd = My5250.getParm(PARAM_START_SESSION, args);
                if (sessions.containsKey(sd)) {
                    My5250.parseArgs(sessions.getProperty(sd), args);
                    final String[] args2 = args;
                    final String sd2 = sd;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            My5250.this.newSession(sd2, args2);
                        }
                    });
                }
            } else if (args[0].startsWith("-")) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        My5250.this.startNewSession();
                    }
                });
            } else {
                final String[] args2 = args;
                final String sd2 = args[0];
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        My5250.this.newSession(sd2, args2);
                    }
                });
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    My5250.this.startNewSession();
                }
            });
        }
    }

    public static void main(String[] args) {
        if (!My5250.isSpecified("-nc", args)) {
            if (!My5250.checkBootStrapper(args)) {
                if (My5250.isSpecified("-d", args)) {
                    strapper = new BootStrapper();
                    strapper.start();
                }
            } else {
                System.exit(0);
            }
        }
        My5250 m = new My5250();
        if (strapper != null) {
            strapper.addBootListener(m);
        }
        if (args.length > 0) {
            if (My5250.isSpecified("-width", args) || My5250.isSpecified("-height", args)) {
                int width = m.frame1.getWidth();
                int height = m.frame1.getHeight();
                if (My5250.isSpecified("-width", args)) {
                    width = Integer.parseInt(My5250.getParm("-width", args));
                }
                if (My5250.isSpecified("-height", args)) {
                    height = Integer.parseInt(My5250.getParm("-height", args));
                }
                m.frame1.setSize(width, height);
                m.frame1.centerFrame();
            }
            if (args[0].startsWith("-")) {
                if (My5250.isSpecified(PARAM_START_SESSION, args)) {
                    String sd = My5250.getParm(PARAM_START_SESSION, args);
                    if (sessions.containsKey(sd)) {
                        sessions.setProperty("emul.default", sd);
                    } else {
                        args = null;
                    }
                }
                if (My5250.isSpecified("-L", args)) {
                    Locale.setDefault(My5250.parseLocal(My5250.getParm("-L", args)));
                }
                LangTool.init();
            } else {
                LangTool.init();
            }
        } else {
            LangTool.init();
        }
        List<String> lastViewNames = new ArrayList<String>();
        lastViewNames.addAll(My5250.loadLastSessionViewNames());
        lastViewNames.addAll(My5250.loadLastSessionViewNamesFrom(args));
        lastViewNames = My5250.filterExistingViewNames(lastViewNames);
        if (lastViewNames.size() > 0) {
            My5250.insertDefaultSessionIfConfigured(lastViewNames);
            My5250.startSessionsFromList(m, lastViewNames);
            if (sessions.containsKey("emul.showConnectDialog")) {
                m.openConnectSessionDialogAndStartSelectedSession();
            }
        } else {
            m.startNewSession();
        }
    }

    private static void startSessionsFromList(My5250 m, List<String> lastViewNames) {
        for (int i = 0; i < lastViewNames.size(); ++i) {
            String viewName = lastViewNames.get(i);
            if (!m.frame1.isVisible()) {
                m.splash.updateProgress(++m.step);
                m.splash.setVisible(false);
                m.frame1.setVisible(true);
                m.frame1.setCursor(Cursor.getPredefinedCursor(0));
            }
            m.sessionArgs = new String[20];
            My5250.parseArgs(sessions.getProperty(viewName), m.sessionArgs);
            m.newSession(viewName, m.sessionArgs);
        }
    }

    private static void insertDefaultSessionIfConfigured(List<String> lastViewNames) {
        if (My5250.getDefaultSession() != null && !lastViewNames.contains(My5250.getDefaultSession())) {
            lastViewNames.add(0, My5250.getDefaultSession());
        }
    }

    static List<String> loadLastSessionViewNamesFrom(String[] commandLineArgs) {
        ArrayList<String> sessionNames = new ArrayList<String>();
        boolean foundRightParam = false;
        for (String arg : commandLineArgs) {
            if (foundRightParam && !PARAM_START_SESSION.equals(arg)) {
                sessionNames.add(arg);
            }
            foundRightParam = PARAM_START_SESSION.equals(arg);
        }
        return sessionNames;
    }

    static List<String> loadLastSessionViewNames() {
        ArrayList<String> sessionNames = new ArrayList<String>();
        if (sessions.containsKey("emul.startLastView")) {
            String sessname;
            String emulview = sessions.getProperty("emul.view", "");
            int idxstart = 0;
            int idxend = emulview.indexOf(PARAM_START_SESSION, idxstart);
            while (idxend > -1) {
                sessname = emulview.substring(idxstart, idxend).trim();
                if (sessname.length() > 0) {
                    sessionNames.add(sessname);
                }
                idxstart = idxend + PARAM_START_SESSION.length();
                idxend = emulview.indexOf(PARAM_START_SESSION, idxstart);
            }
            if (idxstart + PARAM_START_SESSION.length() < emulview.length() && (sessname = emulview.substring(idxstart + PARAM_START_SESSION.length() - 1).trim()).length() > 0) {
                sessionNames.add(sessname);
            }
        }
        return sessionNames;
    }

    static List<String> filterExistingViewNames(List<String> lastViewNames) {
        ArrayList<String> result = new ArrayList<String>();
        for (String viewName : lastViewNames) {
            if (!sessions.containsKey(viewName)) continue;
            result.add(viewName);
        }
        return result;
    }

    private static boolean containsNotOnlyNullValues(String[] stringArray) {
        if (stringArray != null) {
            for (String s : stringArray) {
                if (s == null) continue;
                return true;
            }
        }
        return false;
    }

    private void setDefaultLocale() {
        if (sessions.containsKey("emul.locale")) {
            Locale.setDefault(My5250.parseLocal(sessions.getProperty("emul.locale")));
        }
    }

    private static String getParm(String parm, String[] args) {
        for (int x = 0; x < args.length; ++x) {
            if (!args[x].equals(parm)) continue;
            return args[x + 1];
        }
        return null;
    }

    private static boolean isSpecified(String parm, String[] args) {
        if (args == null) {
            return false;
        }
        for (int x = 0; x < args.length; ++x) {
            if (args[x] == null || !args[x].equals(parm)) continue;
            return true;
        }
        return false;
    }

    private static String getDefaultSession() {
        String defaultSession = sessions.getProperty("emul.default");
        if (defaultSession != null && !defaultSession.trim().isEmpty()) {
            return defaultSession;
        }
        return null;
    }

    private void startNewSession() {
        String sel = "";
        sel = My5250.containsNotOnlyNullValues(this.sessionArgs) && !this.sessionArgs[0].startsWith("-") ? this.sessionArgs[0] : My5250.getDefaultSession();
        Sessions sess = this.manager.getSessions();
        if (sel != null && sess.getCount() == 0 && sessions.containsKey(sel)) {
            this.sessionArgs = new String[20];
            My5250.parseArgs(sessions.getProperty(sel), this.sessionArgs);
        }
        if (this.sessionArgs == null || sess.getCount() > 0 || sessions.containsKey("emul.showConnectDialog")) {
            this.openConnectSessionDialogAndStartSelectedSession();
        } else {
            this.newSession(sel, this.sessionArgs);
        }
    }

    private void openConnectSessionDialogAndStartSelectedSession() {
        String sel = this.openConnectSessionDialog();
        Sessions sess = this.manager.getSessions();
        if (sel != null) {
            String selArgs = sessions.getProperty(sel);
            this.sessionArgs = new String[20];
            My5250.parseArgs(selArgs, this.sessionArgs);
            this.newSession(sel, this.sessionArgs);
        } else if (sess.getCount() == 0) {
            System.exit(0);
        }
    }

    private void startDuplicateSession(SessionPanel ses) {
        My5250.loadSessions();
        if (ses == null) {
            Sessions sess = this.manager.getSessions();
            for (int x = 0; x < sess.getCount(); ++x) {
                if (!sess.item(x).getGUI().isVisible()) continue;
                ses = sess.item(x).getGUI();
                break;
            }
        }
        String selArgs = sessions.getProperty(ses.getSessionName());
        this.sessionArgs = new String[20];
        My5250.parseArgs(selArgs, this.sessionArgs);
        this.newSession(ses.getSessionName(), this.sessionArgs);
    }

    private String openConnectSessionDialog() {
        this.splash.setVisible(false);
        ConnectDialog sc = new ConnectDialog((Frame)this.frame1, LangTool.getString("ss.title"), sessions);
        My5250.loadSessions();
        return sc.getConnectKey();
    }

    private synchronized void newSession(String sel, String[] args) {
        Properties sesProps = new Properties();
        String propFileName = null;
        String session = args[0];
        sesProps.put("SESSION_HOST", session);
        if (My5250.isSpecified("-e", args)) {
            sesProps.put("SESSION_TN_ENHANCED", "1");
        }
        if (My5250.isSpecified("-p", args)) {
            sesProps.put("SESSION_HOST_PORT", My5250.getParm("-p", args));
        }
        if (My5250.isSpecified("-f", args)) {
            propFileName = My5250.getParm("-f", args);
        }
        if (My5250.isSpecified("-cp", args)) {
            sesProps.put("SESSION_CODE_PAGE", My5250.getParm("-cp", args));
        }
        if (My5250.isSpecified("-gui", args)) {
            sesProps.put("SESSION_USE_GUI", "1");
        }
        if (My5250.isSpecified("-t", args)) {
            sesProps.put("SESSION_TERM_NAME_SYSTEM", "1");
        }
        if (My5250.isSpecified("-132", args)) {
            sesProps.put("SESSION_SCREEN_SIZE", "1");
        } else {
            sesProps.put("SESSION_SCREEN_SIZE", "0");
        }
        if (My5250.isSpecified("-usp", args)) {
            if (My5250.isSpecified("-sph", args)) {
                sesProps.put("SESSION_PROXY_HOST", My5250.getParm("-sph", args));
            }
            if (My5250.isSpecified("-spp", args)) {
                sesProps.put("SESSION_PROXY_PORT", My5250.getParm("-spp", args));
            }
        }
        if (My5250.isSpecified("-sslType", args)) {
            sesProps.put("-sslType", My5250.getParm("-sslType", args));
        }
        if (My5250.isSpecified("-dn=hostname", args)) {
            String dnParam;
            try {
                dnParam = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException uhe) {
                dnParam = "UNKNOWN_HOST";
            }
            sesProps.put("SESSION_DEVICE_NAME", dnParam);
        } else if (My5250.isSpecified("-dn", args)) {
            sesProps.put("SESSION_DEVICE_NAME", My5250.getParm("-dn", args));
        }
        if (My5250.isSpecified("-hb", args)) {
            sesProps.put("SESSION_KEEP_ALIVE_ENABLED", "1");
        }
        int sessionCount = this.manager.getSessions().getCount();
        Session5250 s2 = this.manager.openSession(sesProps, propFileName, sel);
        SessionPanel s = new SessionPanel(s2);
        if (!this.frame1.isVisible()) {
            this.splash.updateProgress(++this.step);
            if (My5250.isSpecified("-noembed", args) && sessionCount > 0) {
                this.newView();
            }
            this.splash.setVisible(false);
            this.frame1.setVisible(true);
            this.frame1.setCursor(Cursor.getPredefinedCursor(0));
        } else if (My5250.isSpecified("-noembed", args)) {
            this.splash.updateProgress(++this.step);
            this.newView();
            this.splash.setVisible(false);
            this.frame1.setVisible(true);
            this.frame1.setCursor(Cursor.getPredefinedCursor(0));
        }
        if (My5250.isSpecified("-t", args)) {
            this.frame1.addSessionView(sel, s);
        } else {
            this.frame1.addSessionView(session, s);
        }
        s.connect();
        s.addEmulatorActionListener(this);
    }

    private void newView() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int width = screenSize.width;
        int height = screenSize.height;
        if (sessions.containsKey("emul.width")) {
            width = Integer.parseInt(sessions.getProperty("emul.width"));
        }
        if (sessions.containsKey("emul.height")) {
            height = Integer.parseInt(sessions.getProperty("emul.height"));
        }
        this.frame1 = new Gui5250Frame(this);
        this.frame1.setCursor(Cursor.getPredefinedCursor(3));
        if (sessions.containsKey("emul.frame" + this.frame1.getFrameSequence())) {
            String location = sessions.getProperty("emul.frame" + this.frame1.getFrameSequence());
            this.restoreFrame(this.frame1, location);
        } else {
            this.frame1.setSize(width, height);
            this.frame1.centerFrame();
        }
        frames.add(this.frame1);
    }

    private void restoreFrame(GUIViewInterface frame, String location) {
        StringTokenizer tokenizer = new StringTokenizer(location, ",");
        int x = Integer.parseInt(tokenizer.nextToken());
        int y = Integer.parseInt(tokenizer.nextToken());
        int width = Integer.parseInt(tokenizer.nextToken());
        int height = Integer.parseInt(tokenizer.nextToken());
        frame.setLocation(x, y);
        frame.setSize(width, height);
    }

    protected void closingDown(GUIViewInterface view) {
        Sessions sess = this.manager.getSessions();
        if (this.log.isDebugEnabled()) {
            this.log.debug("number of active sessions we have " + sess.getCount());
        }
        if (this.viewNamesForNextStartBuilder == null) {
            this.viewNamesForNextStartBuilder = new StringBuilder();
        }
        while (view.getSessionViewCount() > 0) {
            SessionPanel sesspanel = view.getSessionAt(0);
            this.viewNamesForNextStartBuilder.append("-s ").append(sesspanel.getSessionName()).append(" ");
            this.closeSessionInternal(sesspanel);
        }
        sessions.setProperty("emul.frame" + view.getFrameSequence(), view.getX() + "," + view.getY() + "," + view.getWidth() + "," + view.getHeight());
        frames.remove(view);
        view.dispose();
        if (this.log.isDebugEnabled()) {
            this.log.debug("number of active sessions we have after shutting down " + sess.getCount());
        }
        this.log.info("view settings " + this.viewNamesForNextStartBuilder);
        if (sess.getCount() == 0) {
            sessions.setProperty("emul.width", Integer.toString(view.getWidth()));
            sessions.setProperty("emul.height", Integer.toString(view.getHeight()));
            sessions.setProperty("emul.view", this.viewNamesForNextStartBuilder.toString());
            ConfigureFactory.getInstance().saveSettings("sessions", "sessions", "------ Defaults --------");
            if (strapper != null) {
                strapper.interrupt();
            }
            System.exit(0);
        }
    }

    protected void closeSessionInternal(SessionPanel sesspanel) {
        GUIViewInterface f = this.getParentView(sesspanel);
        if (f == null) {
            return;
        }
        Sessions sessions = this.manager.getSessions();
        if (sessions.item(sesspanel.getSession()) != null) {
            f.removeSessionView(sesspanel);
            this.manager.closeSession(sesspanel);
        }
        if (this.manager.getSessions().getCount() < 1) {
            this.closingDown(f);
        }
    }

    private static void parseArgs(String theStringList, String[] s) {
        int x = 0;
        StringTokenizer tokenizer = new StringTokenizer(theStringList, " ");
        while (tokenizer.hasMoreTokens()) {
            s[x++] = tokenizer.nextToken();
        }
    }

    private static Locale parseLocal(String localString) {
        int x = 0;
        String[] s = new String[]{"", "", ""};
        StringTokenizer tokenizer = new StringTokenizer(localString, "_");
        while (tokenizer.hasMoreTokens()) {
            s[x++] = tokenizer.nextToken();
        }
        return new Locale(s[0], s[1], s[2]);
    }

    private static void loadSessions() {
        sessions = ConfigureFactory.getInstance().getProperties("sessions");
    }

    @Override
    public void onSessionChanged(SessionChangeEvent changeEvent) {
        Session5250 ses5250 = (Session5250)changeEvent.getSource();
        SessionPanel ses = ses5250.getGUI();
        switch (changeEvent.getState()) {
            case 2: {
                this.closeSessionInternal(ses);
            }
        }
    }

    @Override
    public void onEmulatorAction(EmulatorActionEvent actionEvent) {
        SessionPanel ses = (SessionPanel)actionEvent.getSource();
        switch (actionEvent.getAction()) {
            case 1: {
                this.closeSessionInternal(ses);
                break;
            }
            case 3: {
                throw new UnsupportedOperationException("Not yet implemented!");
            }
            case 2: {
                this.startNewSession();
                break;
            }
            case 4: {
                this.startDuplicateSession(ses);
            }
        }
    }

    private GUIViewInterface getParentView(SessionPanel session) {
        GUIViewInterface f = null;
        for (int x = 0; x < frames.size(); ++x) {
            f = frames.get(x);
            if (!f.containsSession(session)) continue;
            return f;
        }
        return null;
    }

    private void initScripting() {
        try {
            Class.forName("org.tn5250j.scripting.JPythonInterpreterDriver");
        }
        catch (NoClassDefFoundError ncdfe) {
            this.log.warn("Information Message: Can not find scripting support files, scripting will not be available: Failed to load interpreter drivers " + ncdfe);
        }
        catch (Exception ex) {
            this.log.warn("Information Message: Can not find scripting support files, scripting will not be available: Failed to load interpreter drivers " + ex);
        }
        this.splash.updateProgress(++this.step);
    }

    private void initJarPaths() {
        String jarClassPaths = System.getProperty("python.path") + File.pathSeparator + "jython.jar" + File.pathSeparator + "jythonlib.jar" + File.pathSeparator + "jt400.jar" + File.pathSeparator + "itext.jar";
        if (sessions.containsKey("emul.scriptClassPath")) {
            jarClassPaths = jarClassPaths + File.pathSeparator + sessions.getProperty("emul.scriptClassPath");
        }
        System.setProperty("python.path", jarClassPaths);
        this.splash.updateProgress(++this.step);
    }

    static Properties getSessions() {
        return sessions;
    }
}

