/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j;

import java.awt.Dimension;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JApplet;
import javax.swing.SwingUtilities;
import org.tn5250j.Session5250;
import org.tn5250j.SessionPanel;
import org.tn5250j.framework.common.SessionManager;
import org.tn5250j.gui.TN5250jSecurityAccessDialog;
import org.tn5250j.tools.LangTool;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

public class My5250Applet
extends JApplet {
    private static final long serialVersionUID = 1L;
    boolean isStandalone = true;
    private SessionManager manager;
    private TN5250jLogger log;

    public String getParameter(String key, String def) {
        return this.isStandalone ? System.getProperty(key, def) : (this.getParameter(key) != null ? this.getParameter(key) : def);
    }

    @Override
    public void init() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            if (this.log == null) {
                System.out.println(e.getMessage());
            }
            this.log.warn("In constructor: ", e);
        }
    }

    private void jbInit() throws Exception {
        this.setSize(new Dimension(400, 300));
        if (this.isSpecified("-L")) {
            LangTool.init(My5250Applet.parseLocale(this.getParameter("-L")));
        } else {
            LangTool.init();
        }
        try {
            System.getProperty(".java.policy");
        }
        catch (SecurityException e) {
            e.printStackTrace();
            TN5250jSecurityAccessDialog.showErrorMessage(e);
            return;
        }
        this.log = TN5250jLogFactory.getLogger(this.getClass());
        Properties sesProps = new Properties();
        this.log.info(" We have loaded a new one");
        sesProps.put("SESSION_HOST", this.getParameter("host"));
        if (this.isSpecified("-e")) {
            sesProps.put("SESSION_TN_ENHANCED", "1");
        }
        if (this.isSpecified("-p")) {
            sesProps.put("SESSION_HOST_PORT", this.getParameter("-p"));
        }
        if (this.isSpecified("-cp")) {
            sesProps.put("SESSION_CODE_PAGE", this.getParameter("-cp"));
        }
        if (this.isSpecified("-gui")) {
            sesProps.put("SESSION_USE_GUI", "1");
        }
        if (this.isSpecified("-t")) {
            sesProps.put("SESSION_TERM_NAME_SYSTEM", "1");
        }
        if (this.isSpecified("-132")) {
            sesProps.put("SESSION_SCREEN_SIZE", "1");
        } else {
            sesProps.put("SESSION_SCREEN_SIZE", "0");
        }
        if (this.isSpecified("-sph")) {
            sesProps.put("SESSION_PROXY_HOST", this.getParameter("-sph"));
        }
        if (this.isSpecified("-spp")) {
            sesProps.put("SESSION_PROXY_PORT", this.getParameter("-spp"));
        }
        if (this.isSpecified("-dn")) {
            sesProps.put("SESSION_DEVICE_NAME", this.getParameter("-dn"));
        }
        if (this.isSpecified("-sslType")) {
            sesProps.put("-sslType", this.getParameter("-sslType"));
        }
        this.loadSystemProperty("SESSION_CONNECT_USER");
        this.loadSystemProperty("SESSION_CONNECT_PASSWORD");
        this.loadSystemProperty("SESSION_CONNECT_PROGRAM");
        this.loadSystemProperty("SESSION_CONNECT_LIBRARY");
        this.loadSystemProperty("SESSION_CONNECT_MENU");
        this.manager = SessionManager.instance();
        Session5250 s = this.manager.openSession(sesProps, "", "Test Applet");
        final SessionPanel gui = new SessionPanel(s);
        this.getContentPane().add(gui);
        s.connect();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                gui.grabFocus();
            }
        });
    }

    private void loadSystemProperty(String param) {
        if (this.isSpecified(param)) {
            System.getProperties().put(param, this.getParameter(param));
        }
    }

    @Override
    public String getAppletInfo() {
        return "tn5250j - 0.8.0-Snapshot - Java tn5250 Client";
    }

    @Override
    public String[][] getParameterInfo() {
        return null;
    }

    private boolean isSpecified(String parm) {
        if (this.getParameter(parm) != null) {
            this.log.info("Parameter " + parm + " is specified as: " + this.getParameter(parm));
            return true;
        }
        return false;
    }

    protected static Locale parseLocale(String localString) {
        int x = 0;
        String[] s = new String[]{"", "", ""};
        StringTokenizer tokenizer = new StringTokenizer(localString, "_");
        while (tokenizer.hasMoreTokens()) {
            s[x++] = tokenizer.nextToken();
        }
        return new Locale(s[0], s[1], s[2]);
    }
}

