/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import org.tn5250j.SessionConfig;
import org.tn5250j.SessionPanel;
import org.tn5250j.framework.tn5250.Screen5250;

class PrinterThread
extends Thread
implements Printable {
    private char[] screen;
    private char[] screenExtendedAttr;
    private char[] screenAttrPlace;
    private int numCols;
    private int numRows;
    private Font font;
    private SessionPanel session;
    private SessionConfig config;

    PrinterThread(Screen5250 scr, Font font, int cols, int rows, Color colorBg, boolean toDefaultPrinter, SessionPanel ses) {
        this.setPriority(1);
        this.session = ses;
        this.session.setCursor(Cursor.getPredefinedCursor(3));
        this.config = ses.getSession().getConfiguration();
        int len = scr.getScreenLength();
        this.screen = new char[len];
        this.screenExtendedAttr = new char[len];
        this.screenAttrPlace = new char[len];
        scr.GetScreen(this.screen, len, 1);
        scr.GetScreen(this.screenExtendedAttr, len, 4);
        scr.GetScreen(this.screenAttrPlace, len, 8);
        this.numCols = cols;
        this.numRows = rows;
        this.font = font;
    }

    @Override
    public void run() {
        Paper paper;
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setJobName("tn5250j");
        PageFormat pf = printJob.defaultPage();
        if (this.numCols == 132) {
            pf.setOrientation(0);
        } else {
            pf.setOrientation(1);
        }
        if (this.numCols != 132) {
            if (this.config.getStringProperty("print.portWidth").length() != 0 && this.config.getStringProperty("print.portHeight").length() != 0 && this.config.getStringProperty("print.portImageWidth").length() != 0 && this.config.getStringProperty("print.portImageHeight").length() != 0 && this.config.getStringProperty("print.portImage.X").length() != 0 && this.config.getStringProperty("print.portImage.Y").length() != 0) {
                paper = pf.getPaper();
                paper.setSize(Double.parseDouble(this.config.getStringProperty("print.portWidth")), Double.parseDouble(this.config.getStringProperty("print.portHeight")));
                paper.setImageableArea(Double.parseDouble(this.config.getStringProperty("print.portImage.X")), Double.parseDouble(this.config.getStringProperty("print.portImage.Y")), Double.parseDouble(this.config.getStringProperty("print.portImageWidth")), Double.parseDouble(this.config.getStringProperty("print.portImageHeight")));
                pf.setPaper(paper);
            }
        } else if (this.config.getStringProperty("print.landWidth").length() != 0 && this.config.getStringProperty("print.landHeight").length() != 0 && this.config.getStringProperty("print.landImageWidth").length() != 0 && this.config.getStringProperty("print.landImageHeight").length() != 0 && this.config.getStringProperty("print.landImage.X").length() != 0 && this.config.getStringProperty("print.landImage.Y").length() != 0) {
            paper = pf.getPaper();
            paper.setSize(Double.parseDouble(this.config.getStringProperty("print.landWidth")), Double.parseDouble(this.config.getStringProperty("print.landHeight")));
            paper.setImageableArea(Double.parseDouble(this.config.getStringProperty("print.landImage.X")), Double.parseDouble(this.config.getStringProperty("print.landImage.Y")), Double.parseDouble(this.config.getStringProperty("print.landImageWidth")), Double.parseDouble(this.config.getStringProperty("print.landImageHeight")));
        }
        if (this.config.getStringProperty("print.font").length() > 0) {
            this.font = new Font(this.config.getStringProperty("print.font"), 0, 8);
        }
        printJob.setPrintable(this, pf);
        this.session.setCursor(Cursor.getPredefinedCursor(0));
        if (printJob.printDialog()) {
            try {
                this.session.requestFocus();
                printJob.print();
            }
            catch (Exception PrintException) {
                PrintException.printStackTrace();
            }
        } else {
            this.session.requestFocus();
        }
        this.session = null;
        this.screen = null;
        this.screenExtendedAttr = null;
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int page) {
        if (page == 0) {
            LineMetrics l;
            Font k;
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(Color.black);
            g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            int w = (int)pageFormat.getImageableWidth() / this.numCols;
            int h = (int)pageFormat.getImageableHeight() / this.numRows;
            FontRenderContext f = null;
            for (float j = 1.0f; j < 50.0f; j += 1.0f) {
                k = this.font.deriveFont(j);
                f = new FontRenderContext(k.getTransform(), true, true);
                l = k.getLineMetrics("Wy", f);
                if (w < (int)k.getStringBounds("W", f).getWidth() || h < (int)(k.getStringBounds("y", f).getHeight() + (double)l.getDescent() + (double)l.getLeading())) break;
            }
            k = this.font.deriveFont(j -= 1.0f);
            f = new FontRenderContext(k.getTransform(), true, true);
            l = k.getLineMetrics("Wy", f);
            g2.setFont(k);
            int w1 = (int)k.getStringBounds("W", f).getWidth();
            int h1 = (int)(k.getStringBounds("y", f).getHeight() + (double)l.getDescent() + (double)l.getLeading());
            for (int m = 0; m < this.numRows; ++m) {
                for (int i = 0; i < this.numCols; ++i) {
                    int x = w1 * i;
                    int y = h1 * (m + 1);
                    if (this.screen[this.getPos(m, i)] >= ' ' && (this.screenExtendedAttr[this.getPos(m, i)] & '\u0001') == 0) {
                        g2.drawChars(this.screen, this.getPos(m, i), 1, x, (int)((float)(y + h1) - (l.getDescent() + l.getLeading()) - 2.0f));
                    }
                    if ((this.screenExtendedAttr[this.getPos(m, i)] & 8) == 0 || this.screenAttrPlace[this.getPos(m, i)] == '\u0001') continue;
                    g.drawLine(x, (int)((float)y + ((float)h1 - l.getLeading() - 3.0f)), x + w1, (int)((float)y + ((float)h1 - l.getLeading()) - 3.0f));
                }
            }
            return 0;
        }
        return 1;
    }

    private int getPos(int row, int col) {
        return row * this.numCols + col;
    }
}

