/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.SwingUtilities;
import org.tn5250j.RubberBandCanvasIF;

public abstract class RubberBand {
    private volatile RubberBandCanvasIF canvas;
    protected volatile Point startPoint;
    protected volatile Point endPoint;
    private volatile boolean eraseSomething = false;
    private volatile boolean isSomethingBounded = false;
    private volatile boolean isDragging = false;

    public boolean isDragging() {
        return this.isDragging;
    }

    public RubberBand(RubberBandCanvasIF c) {
        this.setCanvas(c);
        this.getCanvas().addMouseListener(new MouseHandler());
        this.getCanvas().addMouseMotionListener(new MouseMotionHandler());
    }

    protected void draw() {
        Graphics g = this.getCanvas().getDrawingGraphics();
        if (g != null) {
            try {
                if (this.getCanvas().canDrawRubberBand(this)) {
                    g.setXORMode(this.canvas.getBackground());
                    this.drawRubberBand(g);
                    this.setEraseSomething(true);
                }
            }
            finally {
                g.dispose();
            }
        }
    }

    protected abstract void drawBoundingShape(Graphics var1, int var2, int var3, int var4, int var5);

    protected void drawRubberBand(Graphics g) {
        if (this.getEndPoint().x > this.getStartPoint().x && this.getEndPoint().y > this.getStartPoint().y) {
            this.drawBoundingShape(g, this.getStartPoint().x, this.getStartPoint().y, this.getEndPoint().x - this.getStartPoint().x, this.getEndPoint().y - this.getStartPoint().y);
        } else if (this.getEndPoint().x < this.getStartPoint().x && this.getEndPoint().y < this.getStartPoint().y) {
            this.drawBoundingShape(g, this.getEndPoint().x, this.getEndPoint().y, this.getStartPoint().x - this.getEndPoint().x, this.getStartPoint().y - this.getEndPoint().y);
        } else if (this.getEndPoint().x > this.getStartPoint().x && this.getEndPoint().y < this.getStartPoint().y) {
            this.drawBoundingShape(g, this.getStartPoint().x, this.getEndPoint().y, this.getEndPoint().x - this.getStartPoint().x, this.getStartPoint().y - this.getEndPoint().y);
        } else if (this.getEndPoint().x < this.getStartPoint().x && this.getEndPoint().y > this.getStartPoint().y) {
            this.drawBoundingShape(g, this.getEndPoint().x, this.getStartPoint().y, this.getStartPoint().x - this.getEndPoint().x, this.getEndPoint().y - this.getStartPoint().y);
        }
        this.isSomethingBounded = true;
    }

    protected void erase() {
        if (this.getEraseSomething()) {
            this.draw();
            this.setEraseSomething(false);
        }
    }

    public final RubberBandCanvasIF getCanvas() {
        return this.canvas;
    }

    protected Point getEndPoint() {
        if (this.endPoint == null) {
            this.setEndPoint(new Point(0, 0));
        }
        return this.endPoint;
    }

    protected Point getStartPoint() {
        if (this.startPoint == null) {
            this.setStartPoint(new Point(0, 0));
        }
        return this.startPoint;
    }

    protected final boolean getEraseSomething() {
        return this.eraseSomething;
    }

    protected void notifyRubberBandCanvas() {
        int endY;
        int startY;
        int endX;
        int startX;
        if (this.getStartPoint().x < this.getEndPoint().x) {
            startX = this.getStartPoint().x;
            endX = this.getEndPoint().x;
        } else {
            startX = this.getEndPoint().x;
            endX = this.getStartPoint().x;
        }
        if (this.getStartPoint().y < this.getEndPoint().y) {
            startY = this.getStartPoint().y;
            endY = this.getEndPoint().y;
        } else {
            startY = this.getEndPoint().y;
            endY = this.getStartPoint().y;
        }
        this.getCanvas().areaBounded(this, startX, startY, endX, endY);
    }

    public final void setCanvas(RubberBandCanvasIF c) {
        this.canvas = c;
    }

    protected final void setEndPoint(Point newValue) {
        this.endPoint = newValue;
    }

    protected final void setEraseSomething(boolean newValue) {
        this.eraseSomething = newValue;
    }

    protected final void setStartPoint(Point newValue) {
        this.startPoint = newValue;
        if (this.startPoint == null) {
            this.endPoint = null;
        }
    }

    protected void start(Point p) {
        this.setEndPoint(p);
        this.setStartPoint(p);
    }

    protected void stop(Point p) {
        if (p.x < 0) {
            p.x = 0;
        }
        if (p.y < 0) {
            p.y = 0;
        }
        this.setEndPoint(p);
    }

    protected void reset() {
        this.setStartPoint(null);
        this.setEndPoint(null);
        this.isSomethingBounded = false;
    }

    protected final boolean isAreaSelected() {
        return this.isSomethingBounded;
    }

    private class MouseMotionHandler
    extends MouseMotionAdapter {
        private MouseMotionHandler() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!SwingUtilities.isRightMouseButton(e) && RubberBand.this.getCanvas().canDrawRubberBand(RubberBand.this)) {
                RubberBand.this.erase();
                if (!RubberBand.this.isDragging) {
                    RubberBand.this.reset();
                    RubberBand.this.start(RubberBand.this.canvas.translateStart(e.getPoint()));
                }
                RubberBand.this.isDragging = true;
                RubberBand.this.stop(RubberBand.this.canvas.translateEnd(e.getPoint()));
                RubberBand.this.notifyRubberBandCanvas();
                RubberBand.this.draw();
                RubberBand.this.notifyRubberBandCanvas();
            }
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!SwingUtilities.isRightMouseButton(e) && !RubberBand.this.isSomethingBounded) {
                RubberBand.this.start(RubberBand.this.canvas.translateStart(e.getPoint()));
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            RubberBand.this.isDragging = false;
        }
    }
}

