/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j;

import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.tn5250j.SessionPanel;
import org.tn5250j.framework.tn5250.Screen5250;
import org.tn5250j.framework.tn5250.ScreenField;
import org.tn5250j.framework.tn5250.ScreenFields;
import org.tn5250j.framework.tn5250.tnvt;
import org.tn5250j.gui.HexCharMapDialog;
import org.tn5250j.interfaces.OptionAccessFactory;
import org.tn5250j.keyboard.KeyMnemonic;
import org.tn5250j.keyboard.configure.KeyConfigure;
import org.tn5250j.mailtools.SendEMailDialog;
import org.tn5250j.spoolfile.SpoolExporter;
import org.tn5250j.tools.GUIGraphicsUtils;
import org.tn5250j.tools.LangTool;
import org.tn5250j.tools.LoadMacroMenu;
import org.tn5250j.tools.Macronizer;
import org.tn5250j.tools.SendScreenImageToFile;
import org.tn5250j.tools.SendScreenToFile;
import org.tn5250j.tools.XTFRFile;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

public class SessionPopup {
    private final Screen5250 screen;
    private final SessionPanel sessiongui;
    private final tnvt vt;
    private final TN5250jLogger log = TN5250jLogFactory.getLogger(this.getClass());

    public SessionPopup(SessionPanel ses, MouseEvent me) {
        AbstractAction action;
        JPopupMenu popup = new JPopupMenu();
        this.sessiongui = ses;
        this.vt = this.sessiongui.getSession().getVT();
        this.screen = this.sessiongui.getScreen();
        final int pos = this.sessiongui.getPosFromView(me.getX(), me.getY());
        if (!this.sessiongui.rubberband.isAreaSelected() && this.screen.isInField(pos, false)) {
            action = new AbstractAction(LangTool.getString("popup.screenFieldId") + ": " + this.getCurrentScreenField()){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            };
            popup.add(action);
            popup.addSeparator();
            action = new AbstractAction(LangTool.getString("popup.copy")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    String fcontent = SessionPopup.this.screen.copyTextField(pos);
                    StringSelection contents = new StringSelection(fcontent);
                    Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
                    cb.setContents(contents, null);
                    SessionPopup.this.sessiongui.getFocusForMe();
                }
            };
            popup.add(this.createMenuItem((Action)action, KeyMnemonic.COPY));
            action = new AbstractAction(LangTool.getString("popup.paste")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    SessionPopup.this.paste(false);
                }
            };
            popup.add(this.createMenuItem((Action)action, KeyMnemonic.PASTE));
            action = new AbstractAction(LangTool.getString("popup.pasteSpecial")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    SessionPopup.this.paste(true);
                }
            };
            popup.add(action);
            popup.addSeparator();
            action = new AbstractAction(LangTool.getString("popup.hexMap")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    SessionPopup.this.showHexMap();
                    SessionPopup.this.sessiongui.getFocusForMe();
                }
            };
            popup.add(this.createMenuItem((Action)action, ""));
            popup.addSeparator();
        } else {
            action = new AbstractAction(LangTool.getString("popup.copy")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    SessionPopup.this.sessiongui.actionCopy();
                    SessionPopup.this.sessiongui.getFocusForMe();
                }
            };
            popup.add(this.createMenuItem((Action)action, KeyMnemonic.COPY));
            action = new AbstractAction(LangTool.getString("popup.paste")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    SessionPopup.this.paste(false);
                }
            };
            popup.add(this.createMenuItem((Action)action, KeyMnemonic.PASTE));
            action = new AbstractAction(LangTool.getString("popup.pasteSpecial")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    SessionPopup.this.paste(true);
                }
            };
            popup.add(action);
            Rectangle workR = new Rectangle();
            if (this.sessiongui.rubberband.isAreaSelected()) {
                JMenuItem menuItem;
                this.sessiongui.getBoundingArea(workR);
                popup.addSeparator();
                if (workR.height == 1) {
                    menuItem = new JMenuItem(LangTool.getString("popup.startPos") + " " + workR.getMinY() + ":" + workR.getMinX());
                    popup.add(menuItem);
                }
                menuItem = new JMenuItem(LangTool.getString("popup.selectedColumns") + " " + workR.width);
                menuItem.setArmed(false);
                popup.add(menuItem);
                menuItem = new JMenuItem(LangTool.getString("popup.selectedRows") + " " + workR.height);
                menuItem.setArmed(false);
                popup.add(menuItem);
                JMenu sumMenu = new JMenu(LangTool.getString("popup.calc"));
                popup.add(sumMenu);
                action = new AbstractAction(LangTool.getString("popup.calcGroupCD")){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SessionPopup.this.sumArea(true);
                    }
                };
                sumMenu.add(action);
                action = new AbstractAction(LangTool.getString("popup.calcGroupDC")){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SessionPopup.this.sumArea(false);
                    }
                };
                sumMenu.add(action);
            }
            popup.addSeparator();
            action = new AbstractAction(LangTool.getString("popup.printScreen")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    SessionPopup.this.sessiongui.printMe();
                    SessionPopup.this.sessiongui.getFocusForMe();
                }
            };
            popup.add(this.createMenuItem((Action)action, KeyMnemonic.PRINT_SCREEN));
            popup.addSeparator();
            JMenu kbMenu = new JMenu(LangTool.getString("popup.keyboard"));
            popup.add(kbMenu);
            action = new AbstractAction(LangTool.getString("popup.mapKeys")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    SessionPopup.this.mapMeKeys();
                }
            };
            kbMenu.add(action);
            kbMenu.addSeparator();
            this.createKeyboardItem(kbMenu, KeyMnemonic.ATTN);
            this.createKeyboardItem(kbMenu, KeyMnemonic.RESET);
            this.createKeyboardItem(kbMenu, KeyMnemonic.SYSREQ);
            if (this.screen.getOIA().isMessageWait() && OptionAccessFactory.getInstance().isValidOption(KeyMnemonic.DISP_MESSAGES.mnemonic)) {
                action = new AbstractAction(LangTool.getString("popup.displayMessages")){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SessionPopup.this.vt.systemRequest('4');
                    }
                };
                kbMenu.add(this.createMenuItem((Action)action, KeyMnemonic.DISP_MESSAGES));
            }
            kbMenu.addSeparator();
            this.createKeyboardItem(kbMenu, KeyMnemonic.DUP_FIELD);
            this.createKeyboardItem(kbMenu, KeyMnemonic.HELP);
            this.createKeyboardItem(kbMenu, KeyMnemonic.ERASE_EOF);
            this.createKeyboardItem(kbMenu, KeyMnemonic.FIELD_PLUS);
            this.createKeyboardItem(kbMenu, KeyMnemonic.FIELD_MINUS);
            this.createKeyboardItem(kbMenu, KeyMnemonic.NEW_LINE);
            if (OptionAccessFactory.getInstance().isValidOption(KeyMnemonic.PRINT.mnemonic)) {
                action = new AbstractAction(LangTool.getString("popup.hostPrint")){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SessionPopup.this.vt.hostPrint(1);
                    }
                };
                kbMenu.add(this.createMenuItem((Action)action, KeyMnemonic.PRINT));
            }
            this.createShortCutItems(kbMenu);
            if (this.screen.getOIA().isMessageWait() && OptionAccessFactory.getInstance().isValidOption(KeyMnemonic.DISP_MESSAGES.mnemonic)) {
                action = new AbstractAction(LangTool.getString("popup.displayMessages")){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SessionPopup.this.vt.systemRequest('4');
                    }
                };
                popup.add(this.createMenuItem((Action)action, KeyMnemonic.DISP_MESSAGES));
            }
            popup.addSeparator();
            action = new AbstractAction(LangTool.getString("popup.hexMap")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    SessionPopup.this.showHexMap();
                    SessionPopup.this.sessiongui.getFocusForMe();
                }
            };
            popup.add(this.createMenuItem((Action)action, ""));
            action = new AbstractAction(LangTool.getString("popup.mapKeys")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    SessionPopup.this.mapMeKeys();
                    SessionPopup.this.sessiongui.getFocusForMe();
                }
            };
            popup.add(this.createMenuItem((Action)action, ""));
            if (OptionAccessFactory.getInstance().isValidOption(KeyMnemonic.DISP_ATTRIBUTES.mnemonic)) {
                action = new AbstractAction(LangTool.getString("popup.settings")){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SessionPopup.this.sessiongui.actionAttributes();
                        SessionPopup.this.sessiongui.getFocusForMe();
                    }
                };
                popup.add(this.createMenuItem((Action)action, KeyMnemonic.DISP_ATTRIBUTES));
            }
            popup.addSeparator();
            if (this.sessiongui.isMacroRunning()) {
                action = new AbstractAction(LangTool.getString("popup.stopScript")){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SessionPopup.this.sessiongui.setStopMacroRequested();
                    }
                };
                popup.add(action);
            } else {
                JMenu macMenu = new JMenu(LangTool.getString("popup.macros"));
                action = this.sessiongui.isSessionRecording() ? new AbstractAction(LangTool.getString("popup.stop")){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SessionPopup.this.sessiongui.stopRecordingMe();
                        SessionPopup.this.sessiongui.getFocusForMe();
                    }
                } : new AbstractAction(LangTool.getString("popup.record")){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SessionPopup.this.sessiongui.startRecordingMe();
                        SessionPopup.this.sessiongui.getFocusForMe();
                    }
                };
                macMenu.add(action);
                if (Macronizer.isMacrosExist()) {
                    this.addMacros(macMenu);
                }
                popup.add(macMenu);
            }
            popup.addSeparator();
            JMenu xtfrMenu = new JMenu(LangTool.getString("popup.export"));
            if (OptionAccessFactory.getInstance().isValidOption(KeyMnemonic.FILE_TRANSFER.mnemonic)) {
                action = new AbstractAction(LangTool.getString("popup.xtfrFile")){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SessionPopup.this.doMeTransfer();
                        SessionPopup.this.sessiongui.getFocusForMe();
                    }
                };
                xtfrMenu.add(this.createMenuItem((Action)action, KeyMnemonic.FILE_TRANSFER));
            }
            if (OptionAccessFactory.getInstance().isValidOption(KeyMnemonic.SPOOL_FILE.mnemonic)) {
                action = new AbstractAction(LangTool.getString("popup.xtfrSpool")){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SessionPopup.this.doMeSpool();
                        SessionPopup.this.sessiongui.getFocusForMe();
                    }
                };
                xtfrMenu.add(action);
            }
            popup.add(xtfrMenu);
            JMenu sendMenu = new JMenu(LangTool.getString("popup.send"));
            popup.add(sendMenu);
            if (OptionAccessFactory.getInstance().isValidOption(KeyMnemonic.QUICK_MAIL.mnemonic)) {
                action = new AbstractAction(LangTool.getString("popup.quickmail")){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SessionPopup.this.sendQuickEMail();
                        SessionPopup.this.sessiongui.getFocusForMe();
                    }
                };
                sendMenu.add(this.createMenuItem((Action)action, KeyMnemonic.QUICK_MAIL));
            }
            if (OptionAccessFactory.getInstance().isValidOption(KeyMnemonic.E_MAIL.mnemonic)) {
                action = new AbstractAction(LangTool.getString("popup.email")){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SessionPopup.this.sendScreenEMail();
                        SessionPopup.this.sessiongui.getFocusForMe();
                    }
                };
                sendMenu.add(this.createMenuItem((Action)action, KeyMnemonic.E_MAIL));
            }
            action = new AbstractAction(LangTool.getString("popup.file")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    SessionPopup.this.sendMeToFile();
                }
            };
            sendMenu.add(action);
            action = new AbstractAction(LangTool.getString("popup.toImage")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    SessionPopup.this.sendMeToImageFile();
                }
            };
            sendMenu.add(action);
            popup.addSeparator();
        }
        if (OptionAccessFactory.getInstance().isValidOption(KeyMnemonic.OPEN_NEW.mnemonic)) {
            action = new AbstractAction(LangTool.getString("popup.connections")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    SessionPopup.this.sessiongui.startNewSession();
                }
            };
            popup.add(this.createMenuItem((Action)action, KeyMnemonic.OPEN_NEW));
        }
        popup.addSeparator();
        if (OptionAccessFactory.getInstance().isValidOption(KeyMnemonic.TOGGLE_CONNECTION.mnemonic)) {
            action = this.vt.isConnected() ? new AbstractAction(LangTool.getString("popup.disconnect")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    SessionPopup.this.sessiongui.toggleConnection();
                    SessionPopup.this.sessiongui.getFocusForMe();
                }
            } : new AbstractAction(LangTool.getString("popup.connect")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    SessionPopup.this.sessiongui.toggleConnection();
                    SessionPopup.this.sessiongui.getFocusForMe();
                }
            };
            popup.add(this.createMenuItem((Action)action, KeyMnemonic.TOGGLE_CONNECTION));
        }
        if (OptionAccessFactory.getInstance().isValidOption(KeyMnemonic.CLOSE.mnemonic)) {
            action = new AbstractAction(LangTool.getString("popup.close")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    SessionPopup.this.sessiongui.confirmCloseSession(true);
                }
            };
            popup.add(this.createMenuItem((Action)action, KeyMnemonic.CLOSE));
        }
        GUIGraphicsUtils.positionPopup(me.getComponent(), popup, me.getX(), me.getY());
    }

    private void createKeyboardItem(JMenu menu, KeyMnemonic keyMnemonic) {
        this.createKeyboardItem(menu, keyMnemonic.mnemonic);
    }

    private void createKeyboardItem(JMenu menu, String key) {
        if (OptionAccessFactory.getInstance().isValidOption(key)) {
            final String key2 = key;
            AbstractAction action = new AbstractAction(LangTool.getString("key." + key)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    SessionPopup.this.screen.sendKeys(key2);
                }
            };
            menu.add(this.createMenuItem((Action)action, key));
        }
    }

    private void addMacros(JMenu menu) {
        LoadMacroMenu.loadMacros(this.sessiongui, menu);
    }

    private JMenuItem createMenuItem(Action action, KeyMnemonic keyMnemonic) {
        return this.createMenuItem(action, keyMnemonic.mnemonic);
    }

    private JMenuItem createMenuItem(Action action, String accelKey) {
        JMenuItem mi = new JMenuItem();
        mi.setAction(action);
        if (this.sessiongui.keyHandler.isKeyStrokeDefined(accelKey)) {
            mi.setAccelerator(this.sessiongui.keyHandler.getKeyStroke(accelKey));
        } else {
            KeyStroke[] allKeys;
            InputMap map = this.sessiongui.getInputMap();
            for (KeyStroke keyStroke : allKeys = map.allKeys()) {
                if (!map.get(keyStroke).equals(accelKey)) continue;
                mi.setAccelerator(keyStroke);
                break;
            }
        }
        return mi;
    }

    private void createShortCutItems(JMenu menu) {
        JMenu sm = new JMenu(LangTool.getString("popup.shortCuts"));
        menu.addSeparator();
        menu.add(sm);
        InputMap map = this.sessiongui.getInputMap();
        KeyStroke[] allKeys = map.allKeys();
        ActionMap aMap = this.sessiongui.getActionMap();
        for (KeyStroke allKey : allKeys) {
            Action a = aMap.get(map.get(allKey));
            JMenuItem mi = new JMenuItem();
            mi.setAction(a);
            mi.setText(LangTool.getString("key." + map.get(allKey)));
            mi.setAccelerator(allKey);
            sm.add(mi);
        }
    }

    private int getCurrentScreenField() {
        int y = this.screen.getCurrentRow() - 1;
        int x = this.screen.getCurrentCol() - 1;
        ScreenFields allScreenFields = this.screen.getScreenFields();
        for (ScreenField aField : allScreenFields.getFields()) {
            if (aField.startRow() != y || aField.startCol() > x || aField.startCol() + aField.getFieldLength() < x) continue;
            this.log.info("Screenfield found with id: " + aField.getFieldId());
            return aField.getFieldId();
        }
        return -1;
    }

    private void sumArea(boolean which) {
        Vector<Double> sumVector = this.sessiongui.sumThem(which);
        Iterator l = sumVector.iterator();
        double sum = 0.0;
        while (l.hasNext()) {
            double inter = 0.0;
            try {
                inter = (Double)l.next();
            }
            catch (Exception e) {
                this.log.warn(e);
            }
            sum += inter;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Vector sum " + sum);
        }
        DecimalFormat df = (DecimalFormat)NumberFormat.getInstance();
        DecimalFormatSymbols dfs = df.getDecimalFormatSymbols();
        if (which) {
            dfs.setDecimalSeparator('.');
            dfs.setGroupingSeparator(',');
        } else {
            dfs.setDecimalSeparator(',');
            dfs.setGroupingSeparator('.');
        }
        df.setDecimalFormatSymbols(dfs);
        df.setMinimumFractionDigits(6);
        JOptionPane.showMessageDialog(null, df.format(sum), LangTool.getString("popup.calc"), 1);
    }

    private void showHexMap() {
        HexCharMapDialog dlg = new HexCharMapDialog(this.sessiongui, this.vt.getCodePage());
        String key = dlg.showModal();
        if (key != null) {
            this.screen.sendKeys(key);
        }
    }

    private void mapMeKeys() {
        Frame parent = (Frame)SwingUtilities.getRoot(this.sessiongui);
        if (Macronizer.isMacrosExist()) {
            String[] macrosList = Macronizer.getMacroList();
            new KeyConfigure(parent, macrosList, this.vt.getCodePage());
        } else {
            new KeyConfigure(parent, null, this.vt.getCodePage());
        }
    }

    private void doMeTransfer() {
        new XTFRFile((Frame)SwingUtilities.getRoot(this.sessiongui), this.vt, this.sessiongui);
    }

    private void doMeSpool() {
        try {
            SpoolExporter spooler = new SpoolExporter(this.vt, this.sessiongui);
            spooler.setVisible(true);
        }
        catch (NoClassDefFoundError ncdfe) {
            JOptionPane.showMessageDialog(this.sessiongui, LangTool.getString("messages.noAS400Toolbox"), "Error", 0, null);
        }
    }

    private void sendScreenEMail() {
        new SendEMailDialog((Frame)SwingUtilities.getRoot(this.sessiongui), this.sessiongui);
    }

    private void sendQuickEMail() {
        new SendEMailDialog((Frame)SwingUtilities.getRoot(this.sessiongui), this.sessiongui, false);
    }

    private void sendMeToFile() {
        SendScreenToFile.showDialog(SwingUtilities.getRoot(this.sessiongui), this.screen);
    }

    private void sendMeToImageFile() {
        new SendScreenImageToFile((Frame)SwingUtilities.getRoot(this.sessiongui), this.sessiongui);
    }

    private void paste(boolean special) {
        try {
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable transferable = cb.getContents(this);
            if (transferable != null) {
                String content = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                this.screen.pasteText(content, special);
                this.sessiongui.getFocusForMe();
            }
        }
        catch (HeadlessException e1) {
            this.log.debug("HeadlessException", e1);
        }
        catch (UnsupportedFlavorException e1) {
            this.log.debug("the requested data flavor is not supported", e1);
        }
        catch (IOException e1) {
            this.log.debug("data is no longer available in the requested flavor", e1);
        }
    }
}

