/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.connectdialog;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.tn5250j.TN5250jConstants;
import org.tn5250j.encoding.CharMappings;
import org.tn5250j.tools.AlignLayout;
import org.tn5250j.tools.LangTool;

class Configure {
    private static Properties props = null;
    private static JTextField systemName = null;
    private static JTextField systemId = null;
    private static JTextField port = null;
    private static JTextField deviceName = null;
    private static JTextField fpn = null;
    private static JComboBox cpb = null;
    private static JCheckBox jtb = null;
    private static JCheckBox ec = null;
    private static JCheckBox tc = null;
    private static JCheckBox sdn = null;
    private static JRadioButton sdNormal = null;
    private static JCheckBox useProxy = null;
    private static JTextField proxyHost = null;
    private static JTextField proxyPort = null;
    private static JCheckBox noEmbed = null;
    private static JCheckBox deamon = null;
    private static JCheckBox newJVM = null;
    private static JComboBox sslType = null;
    private static JCheckBox heartBeat = null;
    private static JTabbedPane confTabs;
    private static JDialog dialog;
    private static Object[] options;

    Configure() {
    }

    public static String doEntry(Frame parent, String propKey, Properties props2) {
        String title;
        int x;
        props = props2;
        confTabs = new JTabbedPane();
        ec = new JCheckBox(LangTool.getString("conf.labelEnhanced"));
        tc = new JCheckBox(LangTool.getString("conf.labelUseSystemName"));
        sdn = new JCheckBox(LangTool.getString("conf.labelUseHostName"));
        useProxy = new JCheckBox(LangTool.getString("conf.labelUseProxy"));
        sdNormal = new JRadioButton(LangTool.getString("conf.label24"));
        JRadioButton sdBig = new JRadioButton(LangTool.getString("conf.label27"));
        noEmbed = new JCheckBox(LangTool.getString("conf.labelEmbed"));
        deamon = new JCheckBox(LangTool.getString("conf.labelDeamon"));
        newJVM = new JCheckBox(LangTool.getString("conf.labelNewJVM"));
        heartBeat = new JCheckBox(LangTool.getString("conf.labelHeartBeat"));
        jtb = new JCheckBox("AS/400 Toolbox");
        jtb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Configure.doCPStateChanged(e);
            }
        });
        cpb = new JComboBox();
        String[] availCP = Configure.getAvailableCodePages();
        cpb.addItem(LangTool.getString("conf.labelDefault"));
        for (x = 0; x < availCP.length; ++x) {
            cpb.addItem(availCP[x]);
        }
        sslType = new JComboBox();
        for (x = 0; x < TN5250jConstants.SSL_TYPES.length; ++x) {
            sslType.addItem(TN5250jConstants.SSL_TYPES[x]);
        }
        if (propKey == null) {
            systemName = new JTextField(20);
            systemId = new JTextField(20);
            port = new JTextField("23", 5);
            deviceName = new JTextField(20);
            fpn = new JTextField(20);
            proxyHost = new JTextField(20);
            proxyPort = new JTextField("1080", 5);
            ec.setSelected(true);
            tc.setSelected(true);
            jtb.setSelected(false);
            sdNormal.setSelected(true);
            deamon.setSelected(true);
            newJVM.setEnabled(false);
            noEmbed.setEnabled(false);
            deamon.setEnabled(false);
            systemName.setDocument(new SomethingEnteredDocument());
        } else {
            String[] args = new String[20];
            Configure.parseArgs((String)props.get(propKey), args);
            systemName = new JTextField(propKey, 20);
            systemName.setEditable(false);
            systemName.setEnabled(false);
            systemId = new JTextField(args[0], 20);
            port = Configure.isSpecified("-p", args) ? new JTextField(Configure.getParm("-p", args), 5) : new JTextField("23", 5);
            if (Configure.isSpecified("-sslType", args)) {
                sslType.setSelectedItem(Configure.getParm("-sslType", args));
            }
            proxyHost = Configure.isSpecified("-sph", args) ? new JTextField(Configure.getParm("-sph", args), 20) : new JTextField(20);
            fpn = Configure.isSpecified("-f", args) ? new JTextField(Configure.getParm("-f", args), 20) : new JTextField(20);
            if (Configure.isSpecified("-cp", args)) {
                String codepage = Configure.getParm("-cp", args);
                String[] acps = CharMappings.getAvailableCodePages();
                jtb.setSelected(true);
                for (String acp : acps) {
                    if (!acp.equals(codepage)) continue;
                    jtb.setSelected(false);
                }
                cpb.setSelectedItem(codepage);
            }
            if (Configure.isSpecified("-e", args)) {
                ec.setSelected(true);
            } else {
                ec.setSelected(false);
            }
            if (Configure.isSpecified("-t", args)) {
                tc.setSelected(true);
            } else {
                tc.setSelected(false);
            }
            if (Configure.isSpecified("-132", args)) {
                sdBig.setSelected(true);
            } else {
                sdNormal.setSelected(true);
            }
            deviceName = Configure.isSpecified("-dn", args) ? new JTextField(Configure.getParm("-dn", args), 20) : new JTextField(20);
            if (Configure.isSpecified("-dn=hostname", args)) {
                sdn.setSelected(true);
                deviceName.setEnabled(false);
            } else {
                sdn.setSelected(false);
                deviceName.setEnabled(true);
            }
            proxyPort = Configure.isSpecified("-spp", args) ? new JTextField(Configure.getParm("-spp", args), 5) : new JTextField("1080", 5);
            if (Configure.isSpecified("-usp", args)) {
                useProxy.setSelected(true);
            } else {
                useProxy.setSelected(false);
            }
            if (Configure.isSpecified("-noembed", args)) {
                noEmbed.setSelected(true);
            } else {
                noEmbed.setSelected(false);
            }
            if (Configure.isSpecified("-d", args)) {
                deamon.setSelected(true);
            } else {
                deamon.setSelected(false);
            }
            if (Configure.isSpecified("-nc", args)) {
                newJVM.setSelected(true);
            } else {
                newJVM.setSelected(false);
            }
            if (Configure.isSpecified("-hb", args)) {
                heartBeat.setSelected(true);
            } else {
                heartBeat.setSelected(false);
            }
            if (Configure.isSpecified("-hb", args)) {
                heartBeat.setSelected(true);
            } else {
                heartBeat.setSelected(false);
            }
        }
        JPanel mp = new JPanel();
        BoxLayout mpLayout = new BoxLayout(mp, 1);
        mp.setLayout(mpLayout);
        JPanel snp = new JPanel();
        AlignLayout snpLayout = new AlignLayout(2, 5, 5);
        snp.setLayout(snpLayout);
        snp.setBorder(BorderFactory.createEtchedBorder());
        Configure.addLabelComponent(LangTool.getString("conf.labelSystemName"), systemName, snp);
        Configure.addLabelComponent(" ", noEmbed, snp);
        Configure.addLabelComponent(" ", deamon, snp);
        Configure.addLabelComponent(" ", newJVM, snp);
        JPanel sip = new JPanel();
        AlignLayout al = new AlignLayout(2, 5, 5);
        sip.setLayout(al);
        sip.setBorder(BorderFactory.createTitledBorder(LangTool.getString("conf.labelSystemIdTitle")));
        Configure.addLabelComponent(LangTool.getString("conf.labelSystemId"), systemId, sip);
        Configure.addLabelComponent(LangTool.getString("conf.labelPort"), port, sip);
        Configure.addLabelComponent(LangTool.getString("conf.labelDeviceName"), deviceName, sip);
        Configure.addLabelComponent("", sdn, sip);
        sdn.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Configure.doItemStateChanged(e);
            }
        });
        Configure.addLabelComponent(LangTool.getString("conf.labelSSLType"), sslType, sip);
        Configure.addLabelComponent("", heartBeat, sip);
        JPanel op = new JPanel();
        BoxLayout opLayout = new BoxLayout(op, 1);
        op.setLayout(opLayout);
        op.setBorder(BorderFactory.createTitledBorder(LangTool.getString("conf.labelOptionsTitle")));
        JPanel fp = new JPanel();
        BoxLayout fpLayout = new BoxLayout(fp, 1);
        fp.setLayout(fpLayout);
        fp.setBorder(BorderFactory.createTitledBorder(LangTool.getString("conf.labelConfFile")));
        fp.add(fpn);
        JPanel sdp = new JPanel();
        BoxLayout sdpLayout = new BoxLayout(sdp, 0);
        sdp.setLayout(sdpLayout);
        sdp.setBorder(BorderFactory.createTitledBorder(LangTool.getString("conf.labelDimensions")));
        ButtonGroup sdGroup = new ButtonGroup();
        sdGroup.add(sdNormal);
        sdGroup.add(sdBig);
        sdp.add(sdNormal);
        sdp.add(sdBig);
        JPanel cp = new JPanel();
        BoxLayout cpLayout = new BoxLayout(cp, 0);
        cp.setLayout(cpLayout);
        cp.setBorder(BorderFactory.createTitledBorder(LangTool.getString("conf.labelCodePage")));
        cp.add(cpb);
        cp.add(jtb);
        JPanel ep = new JPanel();
        BoxLayout epLayout = new BoxLayout(ep, 0);
        ep.setLayout(epLayout);
        ep.setBorder(BorderFactory.createTitledBorder(LangTool.getString("conf.labelEmulateMode")));
        ep.add(ec);
        JPanel tp = new JPanel();
        BoxLayout tpLayout = new BoxLayout(tp, 0);
        tp.setLayout(tpLayout);
        tp.setBorder(BorderFactory.createTitledBorder(""));
        Configure.addLabelComponent("", tc, tp);
        op.add(fp);
        op.add(sdp);
        op.add(cp);
        op.add(ep);
        op.add(tp);
        JPanel sprox = new JPanel();
        AlignLayout spal = new AlignLayout(2, 5, 5);
        sprox.setLayout(spal);
        sprox.setBorder(BorderFactory.createEtchedBorder());
        Configure.addLabelComponent("", useProxy, sprox);
        Configure.addLabelComponent(LangTool.getString("conf.labelProxyHost"), proxyHost, sprox);
        Configure.addLabelComponent(LangTool.getString("conf.labelProxyPort"), proxyPort, sprox);
        confTabs.addTab(LangTool.getString("conf.tabGeneral"), snp);
        confTabs.addTab(LangTool.getString("conf.tabTCP"), sip);
        confTabs.addTab(LangTool.getString("conf.tabOptions"), op);
        confTabs.addTab(LangTool.getString("conf.tabProxy"), sprox);
        if (systemName.getText().trim().length() <= 0) {
            confTabs.setEnabledAt(1, false);
            confTabs.setEnabledAt(2, false);
            confTabs.setEnabledAt(3, false);
        }
        systemName.setAlignmentX(0.5f);
        systemId.setAlignmentX(0.5f);
        fpn.setAlignmentX(0.5f);
        cpb.setAlignmentX(0.5f);
        Object[] message = new Object[]{confTabs};
        options = new JButton[2];
        final String propKey2 = propKey;
        if (propKey2 == null) {
            AbstractAction add = new AbstractAction(LangTool.getString("conf.optAdd")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    Configure.doConfigureAction(propKey2);
                }
            };
            Configure.options[0] = new JButton(add);
            ((JButton)options[0]).setEnabled(false);
            title = LangTool.getString("conf.addEntryATitle");
        } else {
            AbstractAction edit = new AbstractAction(LangTool.getString("conf.optEdit")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    Configure.doConfigureAction(propKey2);
                }
            };
            Configure.options[0] = new JButton(edit);
            title = LangTool.getString("conf.addEntryETitle");
        }
        AbstractAction cancel = new AbstractAction(LangTool.getString("conf.optCancel")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        };
        Configure.options[1] = new JButton(cancel);
        JOptionPane pane = new JOptionPane(message, -1, -1, null, options, options[0]);
        pane.setInitialValue(options[0]);
        pane.setComponentOrientation(parent.getComponentOrientation());
        dialog = pane.createDialog(parent, title);
        dialog.setVisible(true);
        return systemName.getText();
    }

    private static String[] getAvailableCodePages() {
        return CharMappings.getAvailableCodePages();
    }

    private static void doConfigureAction(String propKey) {
        if (propKey == null) {
            props.put(systemName.getText(), Configure.toArgString());
        } else {
            props.setProperty(systemName.getText(), Configure.toArgString());
        }
        dialog.dispose();
    }

    private static void doItemStateChanged(ItemEvent e) {
        deviceName.setEnabled(true);
        if (e.getStateChange() == 1 && sdn.isSelected()) {
            deviceName.setEnabled(false);
        }
    }

    private static void doCPStateChanged(ItemEvent e) {
        String[] availCP = Configure.getAvailableCodePages();
        cpb.removeAllItems();
        cpb.addItem(LangTool.getString("conf.labelDefault"));
        for (int x = 0; x < availCP.length; ++x) {
            cpb.addItem(availCP[x]);
        }
    }

    private static void addLabelComponent(String text, Component comp, Container container) {
        JLabel label = new JLabel(text);
        label.setAlignmentX(0.0f);
        label.setHorizontalTextPosition(2);
        container.add(label);
        container.add(comp);
    }

    private static String getParm(String parm, String[] args) {
        for (int x = 0; x < args.length; ++x) {
            if (!args[x].equals(parm)) continue;
            return args[x + 1];
        }
        return null;
    }

    private static boolean isSpecified(String parm, String[] args) {
        for (int x = 0; x < args.length; ++x) {
            if (args[x] == null || !args[x].equals(parm)) continue;
            return true;
        }
        return false;
    }

    private static void doSomethingEntered() {
        confTabs.setEnabledAt(1, true);
        confTabs.setEnabledAt(2, true);
        confTabs.setEnabledAt(3, true);
        ((JButton)options[0]).setEnabled(true);
        newJVM.setEnabled(true);
        noEmbed.setEnabled(true);
        deamon.setEnabled(true);
    }

    private static void doNothingEntered() {
        confTabs.setEnabledAt(1, false);
        confTabs.setEnabledAt(2, false);
        confTabs.setEnabledAt(3, false);
        ((JButton)options[0]).setEnabled(false);
        newJVM.setEnabled(false);
        noEmbed.setEnabled(false);
        deamon.setEnabled(false);
    }

    private static String toArgString() {
        StringBuilder sb = new StringBuilder();
        sb.append(systemId.getText());
        if (port.getText() != null && port.getText().trim().length() > 0) {
            sb.append(" -p " + port.getText().trim());
        }
        if (fpn.getText() != null && fpn.getText().length() > 0) {
            sb.append(" -f " + fpn.getText());
        }
        if (!LangTool.getString("conf.labelDefault").equals(cpb.getSelectedItem())) {
            sb.append(" -cp " + (String)cpb.getSelectedItem());
        }
        if (!"NONE".equals(sslType.getSelectedItem())) {
            sb.append(" -sslType " + (String)sslType.getSelectedItem());
        }
        if (ec.isSelected()) {
            sb.append(" -e");
        }
        if (tc.isSelected()) {
            sb.append(" -t");
        }
        if (!sdNormal.isSelected()) {
            sb.append(" -132");
        }
        if (deviceName.getText() != null && !sdn.isSelected() && deviceName.getText().trim().length() > 0) {
            if (deviceName.getText().trim().length() > 10) {
                sb.append(" -dn " + deviceName.getText().trim().substring(0, 10).toUpperCase());
            } else {
                sb.append(" -dn " + deviceName.getText().trim().toUpperCase());
            }
        }
        if (sdn.isSelected()) {
            sb.append(" -dn=hostname");
        }
        if (useProxy.isSelected()) {
            sb.append(" -usp");
        }
        if (proxyHost.getText() != null && proxyHost.getText().length() > 0) {
            sb.append(" -sph " + proxyHost.getText());
        }
        if (proxyPort.getText() != null && proxyPort.getText().length() > 0) {
            sb.append(" -spp " + proxyPort.getText());
        }
        if (noEmbed.isSelected()) {
            sb.append(" -noembed ");
        }
        if (deamon.isSelected()) {
            sb.append(" -d ");
        }
        if (newJVM.isSelected()) {
            sb.append(" -nc ");
        }
        if (heartBeat.isSelected()) {
            sb.append(" -hb ");
        }
        return sb.toString();
    }

    static void parseArgs(String theStringList, String[] s) {
        int x = 0;
        StringTokenizer tokenizer = new StringTokenizer(theStringList, " ");
        while (tokenizer.hasMoreTokens()) {
            s[x++] = tokenizer.nextToken();
        }
    }

    static {
        dialog = null;
    }

    private static class SomethingEnteredDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;

        private SomethingEnteredDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            super.insertString(offs, str, a);
            if (this.getText(0, this.getLength()).length() > 0) {
                Configure.doSomethingEntered();
            }
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            super.remove(offs, len);
            if (this.getText(0, this.getLength()).length() == 0) {
                Configure.doNothingEntered();
            }
        }
    }
}

