/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.connectdialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.tn5250j.ExternalProgramConfig;
import org.tn5250j.connectdialog.Configure;
import org.tn5250j.connectdialog.CustomizedTableModel;
import org.tn5250j.connectdialog.MultiSelectListComponent;
import org.tn5250j.connectdialog.SessionsDataModel;
import org.tn5250j.connectdialog.SessionsTableModel;
import org.tn5250j.gui.JSortTable;
import org.tn5250j.interfaces.ConfigureFactory;
import org.tn5250j.interfaces.OptionAccessFactory;
import org.tn5250j.keyboard.KeyMnemonicResolver;
import org.tn5250j.tools.AlignLayout;
import org.tn5250j.tools.DESSHA1;
import org.tn5250j.tools.GUIGraphicsUtils;
import org.tn5250j.tools.LangTool;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

public class ConnectDialog
extends JDialog
implements ActionListener,
ChangeListener {
    private static final String USER_PREF_LAST_SESSION = "last_session";
    private static final long serialVersionUID = 1L;
    private static volatile TN5250jLogger LOG = TN5250jLogFactory.getLogger(ConnectDialog.class);
    private final KeyMnemonicResolver keyMnemonicResolver = new KeyMnemonicResolver();
    private JPanel configOptions = new JPanel();
    private JPanel sessionPanel = new JPanel();
    private JPanel options = new JPanel(new FlowLayout(1, 30, 10));
    private JPanel sessionOpts = new JPanel();
    private JPanel sessionOptPanel = new JPanel(new FlowLayout(1, 30, 10));
    private JPanel emulOptPanel = new JPanel();
    private JPanel accessPanel = new JPanel();
    private JPanel loggingPanel = new JPanel();
    private JPanel externalPanel = new JPanel();
    private JPanel externalOpts = new JPanel();
    private JPanel externalOptPanel = new JPanel(new FlowLayout(1, 30, 10));
    private JPanel aboutPanel = null;
    private JTable sessions = null;
    private JTable externals = null;
    private GridBagConstraints gbc;
    private JRadioButton intOFF = null;
    private JRadioButton intDEBUG = null;
    private JRadioButton intINFO = null;
    private JRadioButton intWARN = null;
    private JRadioButton intERROR = null;
    private JRadioButton intFATAL = null;
    private JButton editButton = null;
    private JButton removeButton = null;
    private JButton connectButton = null;
    private JButton cAddButton = null;
    private JButton cEditButton = null;
    private JButton cRemoveButton = null;
    private SessionsTableModel ctm = null;
    private CustomizedTableModel etm = null;
    private ListSelectionModel rowSM = null;
    private ListSelectionModel rowSM2 = null;
    private Properties properties = null;
    private Properties externalProgramConfig = null;
    private JCheckBox hideTabBar = null;
    private JCheckBox showMe = null;
    private JCheckBox lastView = null;
    private BorderLayout borderLayout = new BorderLayout();
    private MultiSelectListComponent accessOptions;
    private JPasswordField password;
    private JButton setPassButton;
    private String connectKey = null;
    private JRadioButton intConsole;
    private JRadioButton intFile;
    private JRadioButton intBoth;
    private JTextField browser;
    private JTextField mailer;

    public ConnectDialog(Frame frame, String title, Properties prop) {
        super(frame, title, true);
        this.properties = ConfigureFactory.getInstance().getProperties("sessions");
        this.externalProgramConfig = ExternalProgramConfig.getInstance().getEtnPgmProps();
        try {
            this.jbInit();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension frameSize = this.getSize();
            if (frameSize.height > screenSize.height) {
                frameSize.height = screenSize.height;
            }
            if (frameSize.width > screenSize.width) {
                frameSize.width = screenSize.width;
            }
            int w2 = frame.getWidth();
            int h2 = frame.getHeight();
            int x2 = frame.getX();
            int y2 = frame.getY();
            this.setLocation(x2 + w2 / 2 - frameSize.width / 2, y2 + h2 / 2 - frameSize.height / 2);
            this.setVisible(true);
        }
        catch (Exception ex) {
            LOG.warn("Error while initializing!", ex);
        }
    }

    private void jbInit() throws Exception {
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.createSessionsPanel();
        this.createEmulatorOptionsPanel();
        this.createButtonOptions();
        JTabbedPane optionTabs = new JTabbedPane();
        optionTabs.addChangeListener(this);
        optionTabs.addTab(LangTool.getString("ss.labelConnections"), this.sessionPanel);
        optionTabs.addTab(LangTool.getString("ss.labelOptions1"), this.emulOptPanel);
        this.createLoggingPanel();
        optionTabs.addTab(LangTool.getString("ss.labelLogging"), this.loggingPanel);
        this.createAccessPanel();
        optionTabs.addTab(LangTool.getString("ss.labelOptions2"), this.accessPanel);
        this.createExternalProgramsPanel();
        optionTabs.addTab(LangTool.getString("ss.labelExternal"), this.externalPanel);
        this.createAboutPanel();
        optionTabs.addTab("About", this.aboutPanel);
        this.getContentPane().add((Component)optionTabs, "Center");
        this.getContentPane().add((Component)this.options, "South");
        this.pack();
        if (this.sessions.getRowCount() > 0) {
            String lastConKey;
            int selInterval = -1;
            for (int x = 0; x < this.sessions.getRowCount(); ++x) {
                if (!Boolean.TRUE.equals(this.ctm.getValueAt(x, 2))) continue;
                selInterval = x;
                break;
            }
            if (selInterval < 0 && (lastConKey = this.loadSelectedSessionPreference()) != null) {
                for (int x = 0; x < this.sessions.getRowCount(); ++x) {
                    if (!lastConKey.equals(this.ctm.getValueAt(x, 0))) continue;
                    selInterval = x;
                    break;
                }
            }
            if (selInterval < 0) {
                selInterval = 0;
            }
            this.sessions.getSelectionModel().setSelectionInterval(selInterval, selInterval);
            int targetrow = Math.min(this.sessions.getRowCount() - 1, selInterval + 3);
            Rectangle cellRect = this.sessions.getCellRect(targetrow, 0, true);
            this.sessions.scrollRectToVisible(cellRect);
        } else {
            this.connectButton.setEnabled(false);
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ConnectDialog.this.sessions.requestFocus();
                    }
                });
            }
        });
        this.setIconImages(GUIGraphicsUtils.getApplicationIcons());
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int index;
        JTabbedPane p = (JTabbedPane)e.getSource();
        if (!p.getTitleAt(index = p.getSelectedIndex()).equals(LangTool.getString("ss.labelConnections"))) {
            this.connectButton.setEnabled(false);
            this.setTitle(LangTool.getString("ss.title") + " - " + p.getTitleAt(index));
        } else {
            this.setTitle(LangTool.getString("ss.title") + " - " + LangTool.getString("ss.labelConnections"));
            this.connectButton.setEnabled(true);
        }
    }

    private void createSessionsPanel() {
        this.ctm = new SessionsTableModel(this.properties);
        this.sessions = new JSortTable(this.ctm);
        this.sessions.getColumnModel().getColumn(0).setPreferredWidth(250);
        this.sessions.getColumnModel().getColumn(1).setPreferredWidth(250);
        this.sessions.getColumnModel().getColumn(2).setPreferredWidth(65);
        AbstractAction connect = new AbstractAction("connect"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectDialog.this.doActionConnect();
            }
        };
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0, false);
        this.sessions.getInputMap().put(enter, "connect");
        this.sessions.getActionMap().put("connect", connect);
        this.sessions.setSelectionMode(0);
        this.sessions.setPreferredScrollableViewportSize(new Dimension(500, 200));
        this.sessions.setShowGrid(false);
        JScrollPane scrollPane = new JScrollPane(this.sessions);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(30);
        this.sessions.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    ConnectDialog.this.doActionConnect();
                }
            }
        });
        this.rowSM = this.sessions.getSelectionModel();
        this.rowSM.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (lsm.isSelectionEmpty()) {
                    ConnectDialog.this.editButton.setEnabled(false);
                    ConnectDialog.this.removeButton.setEnabled(false);
                    ConnectDialog.this.connectButton.setEnabled(false);
                } else {
                    ConnectDialog.this.editButton.setEnabled(true);
                    ConnectDialog.this.removeButton.setEnabled(true);
                    ConnectDialog.this.connectButton.setEnabled(true);
                }
            }
        });
        this.configOptions.setLayout(this.borderLayout);
        this.sessionPanel.setLayout(this.borderLayout);
        this.configOptions.add((Component)this.sessionPanel, "Center");
        this.sessionOpts.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        this.sessionOpts.add((Component)scrollPane, "Center");
        this.sessionPanel.add((Component)this.sessionOpts, "North");
        this.sessionPanel.add((Component)this.sessionOptPanel, "South");
        this.addOptButton(LangTool.getString("ss.optAdd"), "ADD", this.sessionOptPanel);
        this.removeButton = this.addOptButton(LangTool.getString("ss.optDelete"), "REMOVE", this.sessionOptPanel, false);
        this.editButton = this.addOptButton(LangTool.getString("ss.optEdit"), "EDIT", this.sessionOptPanel, false);
    }

    private void createEmulatorOptionsPanel() {
        this.emulOptPanel.setLayout(new BorderLayout());
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        this.emulOptPanel.add((Component)contentPane, "North");
        JPanel interfacePanel = new JPanel(new GridBagLayout());
        TitledBorder tb = BorderFactory.createTitledBorder(LangTool.getString("conf.labelPresentation"));
        tb.setTitleJustification(2);
        interfacePanel.setBorder(tb);
        ButtonGroup intGroup = new ButtonGroup();
        this.hideTabBar = new JCheckBox(LangTool.getString("conf.labelHideTabBar"));
        this.hideTabBar.setSelected(false);
        if (this.properties.containsKey("emul.hideTabBar") && this.properties.getProperty("emul.hideTabBar").equals("yes")) {
            this.hideTabBar.setSelected(true);
        }
        this.hideTabBar.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ConnectDialog.this.hideTabBar_itemStateChanged(e);
            }
        });
        JRadioButton intTABS = new JRadioButton(LangTool.getString("conf.labelTABS"));
        intTABS.setSelected(true);
        intTABS.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
            }
        });
        intGroup.add(intTABS);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(10, 10, 5, 10);
        interfacePanel.add((Component)intTABS, this.gbc);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 27, 5, 10);
        interfacePanel.add((Component)this.hideTabBar, this.gbc);
        JPanel startupPanel = new JPanel();
        startupPanel.setLayout(new AlignLayout(1, 5, 5));
        TitledBorder smb = BorderFactory.createTitledBorder(LangTool.getString("ss.labelStartup"));
        smb.setTitleJustification(2);
        startupPanel.setBorder(smb);
        this.showMe = new JCheckBox(LangTool.getString("ss.labelShowMe"));
        if (this.properties.containsKey("emul.showConnectDialog")) {
            this.showMe.setSelected(true);
        }
        this.showMe.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ConnectDialog.this.showMe_itemStateChanged(e);
            }
        });
        this.lastView = new JCheckBox(LangTool.getString("ss.labelLastView"));
        if (this.properties.containsKey("emul.startLastView")) {
            this.lastView.setSelected(true);
        }
        this.lastView.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ConnectDialog.this.lastView_itemStateChanged(e);
            }
        });
        startupPanel.add(this.showMe);
        startupPanel.add(this.lastView);
        contentPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        contentPane.add(interfacePanel);
        contentPane.add(Box.createVerticalStrut(10));
        contentPane.add(startupPanel);
    }

    private void createLoggingPanel() {
        this.loggingPanel.setLayout(new GridBagLayout());
        JPanel levelPanel = new JPanel(new GridBagLayout());
        TitledBorder tb = BorderFactory.createTitledBorder(LangTool.getString("logscr.Level"));
        tb.setTitleJustification(2);
        levelPanel.setBorder(tb);
        int logLevel = Integer.parseInt(this.properties.getProperty("emul.logLevel", Integer.toString(2)));
        ButtonGroup levelGroup = new ButtonGroup();
        this.intOFF = new JRadioButton(LangTool.getString("logscr.Off"));
        this.intOFF.setSelected(true);
        this.intOFF.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ConnectDialog.this.intOFF_itemStateChanged(e);
            }
        });
        this.intDEBUG = new JRadioButton(LangTool.getString("logscr.Debug"));
        this.intDEBUG.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ConnectDialog.this.intDEBUG_itemStateChanged(e);
            }
        });
        this.intINFO = new JRadioButton(LangTool.getString("logscr.Info"));
        this.intINFO.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ConnectDialog.this.intINFO_itemStateChanged(e);
            }
        });
        this.intWARN = new JRadioButton(LangTool.getString("logscr.Warn"));
        this.intWARN.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ConnectDialog.this.intWARN_itemStateChanged(e);
            }
        });
        this.intERROR = new JRadioButton(LangTool.getString("logscr.Error"));
        this.intERROR.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ConnectDialog.this.intERROR_itemStateChanged(e);
            }
        });
        this.intFATAL = new JRadioButton(LangTool.getString("logscr.Fatal"));
        this.intFATAL.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ConnectDialog.this.intFATAL_itemStateChanged(e);
            }
        });
        levelGroup.add(this.intOFF);
        levelGroup.add(this.intDEBUG);
        levelGroup.add(this.intINFO);
        levelGroup.add(this.intWARN);
        levelGroup.add(this.intERROR);
        levelGroup.add(this.intFATAL);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(20, 20, 5, 20);
        levelPanel.add((Component)this.intOFF, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 20, 5, 20);
        levelPanel.add((Component)this.intDEBUG, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 2;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 20, 5, 20);
        levelPanel.add((Component)this.intINFO, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 3;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 20, 5, 20);
        levelPanel.add((Component)this.intWARN, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 4;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 20, 5, 20);
        levelPanel.add((Component)this.intERROR, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 5;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 20, 20, 20);
        levelPanel.add((Component)this.intFATAL, this.gbc);
        JPanel appenderPanel = new JPanel(new GridBagLayout());
        tb = BorderFactory.createTitledBorder(LangTool.getString("logscr.Appender"));
        tb.setTitleJustification(2);
        appenderPanel.setBorder(tb);
        ButtonGroup appenderGroup = new ButtonGroup();
        this.intConsole = new JRadioButton(LangTool.getString("logscr.Console"));
        this.intConsole.setSelected(true);
        this.intConsole.setEnabled(false);
        this.intConsole.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
            }
        });
        this.intFile = new JRadioButton(LangTool.getString("logscr.File"));
        this.intFile.setEnabled(false);
        this.intBoth = new JRadioButton(LangTool.getString("logscr.Both"));
        this.intBoth.setEnabled(false);
        appenderGroup.add(this.intConsole);
        appenderGroup.add(this.intFile);
        appenderGroup.add(this.intBoth);
        switch (logLevel) {
            case 32: {
                this.intOFF.setSelected(true);
                break;
            }
            case 1: {
                this.intDEBUG.setSelected(true);
                break;
            }
            case 2: {
                this.intINFO.setSelected(true);
                break;
            }
            case 4: {
                this.intWARN.setSelected(true);
                break;
            }
            case 8: {
                this.intERROR.setSelected(true);
                break;
            }
            case 16: {
                this.intFATAL.setSelected(true);
                break;
            }
            default: {
                this.intINFO.setSelected(true);
            }
        }
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(20, 20, 5, 20);
        appenderPanel.add((Component)this.intConsole, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 20, 5, 20);
        appenderPanel.add((Component)this.intFile, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 2;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 20, 20, 20);
        appenderPanel.add((Component)this.intBoth, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(10, 10, 10, 20);
        this.loggingPanel.add((Component)levelPanel, this.gbc);
        this.gbc.gridx = 1;
        this.gbc.gridy = 0;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(10, 20, 10, 10);
        this.loggingPanel.add((Component)appenderPanel, this.gbc);
    }

    private void createAccessPanel() {
        this.accessOptions = new MultiSelectListComponent();
        if (this.properties.getProperty("emul.accessDigest") != null) {
            this.accessOptions.setEnabled(false);
        }
        String[] options = this.keyMnemonicResolver.getMnemonicsSorted();
        Hashtable<String, String> ht = new Hashtable<String, String>(options.length);
        for (String option : options) {
            ht.put(LangTool.getString("key." + option), option);
        }
        Object[] descriptions = this.keyMnemonicResolver.getMnemonicDescriptions();
        Arrays.sort(descriptions);
        this.accessOptions.setListData(descriptions);
        int num = OptionAccessFactory.getInstance().getNumberOfRestrictedOptions();
        int[] si = new int[num];
        int i = 0;
        for (int x = 0; x < descriptions.length; ++x) {
            if (OptionAccessFactory.getInstance().isValidOption((String)ht.get(descriptions[x]))) continue;
            si[i++] = x;
        }
        this.accessOptions.setSelectedIndices(si);
        this.accessOptions.setSourceHeader(LangTool.getString("ss.labelActive"), 0);
        this.accessOptions.setSelectionHeader(LangTool.getString("ss.labelRestricted"), 0);
        this.accessPanel.setLayout(new BorderLayout());
        this.accessPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 10, 5));
        this.accessPanel.add((Component)this.accessOptions, "Center");
        JPanel passPanel = new JPanel();
        passPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
        passPanel.setLayout(new FlowLayout(1, 10, 0));
        AbstractAction action = new AbstractAction(LangTool.getString("ss.labelSetPass")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConnectDialog.this.password.getPassword().length > 0) {
                    try {
                        DESSHA1 sha = new DESSHA1();
                        ConnectDialog.this.properties.setProperty("emul.accessDigest", sha.digest(new String(ConnectDialog.this.password.getPassword()), "tn5205j"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        };
        this.setPassButton = new JButton(action);
        if (this.properties.getProperty("emul.accessDigest") != null) {
            this.setPassButton.setEnabled(false);
        }
        passPanel.add(this.setPassButton);
        this.password = new JPasswordField(15);
        this.password.setDocument(new CheckPasswordDocument());
        passPanel.add(this.password);
        this.accessPanel.add((Component)passPanel, "North");
    }

    private void createExternalProgramsPanel() {
        JPanel externalPrograms = new JPanel();
        this.externalPanel.setLayout(new BorderLayout());
        this.externalPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 10, 5));
        externalPrograms.setLayout(new AlignLayout(3, 5, 5));
        externalPrograms.setBorder(BorderFactory.createTitledBorder(LangTool.getString("external.title")));
        externalPrograms.add(new JLabel(LangTool.getString("external.http")));
        this.browser = new JTextField(30);
        if (this.properties.containsKey("emul.protocol.http")) {
            this.browser.setText(this.properties.getProperty("emul.protocol.http"));
        }
        externalPrograms.add(this.browser);
        externalPrograms.add(new JButton("..."));
        externalPrograms.add(new JLabel(LangTool.getString("external.mailto")));
        this.mailer = new JTextField(30);
        if (this.properties.containsKey("emul.protocol.mailto")) {
            this.mailer.setText(this.properties.getProperty("emul.protocol.mailto"));
        }
        externalPrograms.add(this.mailer);
        externalPrograms.add(new JButton("..."));
        this.externalPanel.add((Component)externalPrograms, "North");
        this.etm = new CustomizedTableModel(this.externalProgramConfig);
        this.externals = new JSortTable(this.etm);
        this.externals.setSelectionMode(0);
        this.externals.setPreferredScrollableViewportSize(new Dimension(500, 100));
        this.externals.setShowGrid(false);
        JScrollPane scrollPane2 = new JScrollPane(this.externals);
        scrollPane2.setVerticalScrollBarPolicy(20);
        scrollPane2.setHorizontalScrollBarPolicy(30);
        this.externals.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    ConnectDialog.this.doActionConnect();
                }
            }
        });
        this.rowSM2 = this.externals.getSelectionModel();
        this.rowSM2.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (lsm.isSelectionEmpty()) {
                    ConnectDialog.this.cEditButton.setEnabled(false);
                    ConnectDialog.this.cRemoveButton.setEnabled(false);
                    ConnectDialog.this.cAddButton.setEnabled(false);
                } else {
                    ConnectDialog.this.cEditButton.setEnabled(true);
                    ConnectDialog.this.cRemoveButton.setEnabled(true);
                    ConnectDialog.this.cAddButton.setEnabled(true);
                }
            }
        });
        JPanel cExternalPrograms = new JPanel();
        cExternalPrograms.setLayout(new BorderLayout());
        cExternalPrograms.setBorder(BorderFactory.createTitledBorder(LangTool.getString("customized.title")));
        this.externalOpts.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        this.externalOpts.add((Component)scrollPane2, "Center");
        cExternalPrograms.add((Component)this.externalOpts, "North");
        cExternalPrograms.add((Component)this.externalOptPanel, "South");
        this.cAddButton = this.addOptButton(LangTool.getString("ss.optAdd"), "cADD", this.externalOptPanel);
        this.cRemoveButton = this.addOptButton(LangTool.getString("ss.optDelete"), "cREMOVE", this.externalOptPanel, false);
        this.cEditButton = this.addOptButton(LangTool.getString("ss.optEdit"), "cEDIT", this.externalOptPanel, false);
        this.externalPanel.add((Component)cExternalPrograms, "Center");
    }

    private void doSomethingEntered() {
        if (this.properties.getProperty("emul.accessDigest") != null) {
            try {
                DESSHA1 sha = new DESSHA1();
                if (this.properties.getProperty("emul.accessDigest").equals(sha.digest(new String(this.password.getPassword()), "tn5205j"))) {
                    this.accessOptions.setEnabled(true);
                    this.setPassButton.setEnabled(true);
                }
            }
            catch (Exception ex) {
                LOG.warn(ex.getMessage(), ex);
            }
        }
    }

    private void doNothingEntered() {
    }

    private void createButtonOptions() {
        this.connectButton = this.addOptButton(LangTool.getString("ss.optConnect"), "CONNECT", this.options, false);
        this.addOptButton(LangTool.getString("ss.optApply"), "APPLY", this.options, true);
        this.addOptButton(LangTool.getString("ss.optCancel"), "DONE", this.options);
    }

    private void createAboutPanel() {
        this.aboutPanel = new JPanel();
        JPanel contenpane = new JPanel();
        TitledBorder tb = BorderFactory.createTitledBorder("About");
        tb.setTitleJustification(2);
        contenpane.add(new JLabel("TN5250j"));
        contenpane.add(new JLabel("Version: 0.8.0-Snapshot"));
        contenpane.setLayout(new BoxLayout(contenpane, 1));
        this.aboutPanel.add(contenpane);
        this.aboutPanel.setBorder(tb);
    }

    private JButton addOptButton(String text, String ac, Container container) {
        return this.addOptButton(text, ac, container, true);
    }

    private JButton addOptButton(String text, String ac, Container container, boolean enabled) {
        JButton button = new JButton(text);
        button.setEnabled(enabled);
        button.setActionCommand(ac);
        button.setPreferredSize(new Dimension(140, 28));
        int mnemIdx = text.indexOf("&");
        if (mnemIdx >= 0) {
            StringBuilder sb = new StringBuilder(text);
            sb.deleteCharAt(mnemIdx);
            button.setText(sb.toString());
            button.setMnemonic(text.charAt(mnemIdx + 1));
        }
        button.addActionListener(this);
        button.setAlignmentX(0.5f);
        container.add(button);
        return button;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int x;
        int selInterval;
        if (e.getActionCommand().equals("DONE")) {
            this.saveProps();
            this.setVisible(false);
        }
        if (e.getActionCommand().equals("ADD")) {
            String systemName = Configure.doEntry((JFrame)this.getParent(), null, this.properties);
            this.ctm.addSession();
            if (this.ctm.getRowCount() == 1) {
                this.sessions.getSelectionModel().setSelectionInterval(0, 0);
            } else {
                selInterval = 0;
                for (x = 0; x < this.sessions.getRowCount(); ++x) {
                    if (!((String)this.ctm.getValueAt(x, 0)).equals(systemName)) continue;
                    selInterval = x;
                }
                this.sessions.getSelectionModel().setSelectionInterval(selInterval, selInterval);
            }
            this.sessions.requestFocus();
        }
        if (e.getActionCommand().equals("REMOVE")) {
            this.removeEntry();
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }
        if (e.getActionCommand().equals("EDIT")) {
            int selectedRow = this.rowSM.getMinSelectionIndex();
            Configure.doEntry((JFrame)this.getParent(), (String)this.ctm.getValueAt(selectedRow, 0), this.properties);
            this.ctm.chgSession(selectedRow);
            this.sessions.requestFocus();
        }
        if (e.getActionCommand().equals("cADD")) {
            String name = ExternalProgramConfig.doEntry((JFrame)this.getParent(), null, this.externalProgramConfig);
            this.etm.addSession();
            if (this.etm.getRowCount() == 1) {
                this.externals.getSelectionModel().setSelectionInterval(0, 0);
            } else {
                selInterval = 0;
                for (x = 0; x < this.externals.getRowCount(); ++x) {
                    if (!((String)this.etm.getValueAt(x, 0)).equals(name)) continue;
                    selInterval = x;
                }
                this.externals.getSelectionModel().setSelectionInterval(selInterval, selInterval);
            }
            this.externals.requestFocus();
        }
        if (e.getActionCommand().equals("cEDIT")) {
            int selectedRow = this.rowSM2.getMinSelectionIndex();
            ExternalProgramConfig.doEntry((JFrame)this.getParent(), (String)this.etm.getValueAt(selectedRow, 0), this.externalProgramConfig);
            this.etm.chgSession(selectedRow);
            this.externals.requestFocus();
        }
        if (e.getActionCommand().equals("cREMOVE")) {
            this.removeExternalProgram();
            this.cEditButton.setEnabled(false);
            this.cRemoveButton.setEnabled(false);
        }
        if (e.getActionCommand().equals("CONNECT")) {
            this.doActionConnect();
        }
        if (e.getActionCommand().equals("APPLY")) {
            this.saveProps();
        }
    }

    private void doActionConnect() {
        if (!this.connectButton.isEnabled()) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        int selectedRow = this.rowSM.getMinSelectionIndex();
        this.connectKey = (String)this.ctm.getValueAt(selectedRow, 0);
        this.saveProps();
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.dispose();
    }

    public String getConnectKey() {
        return this.connectKey;
    }

    private void saveProps() {
        if (this.connectKey != null) {
            this.saveSelectedSessionPreference(this.connectKey);
        }
        this.setOptionAccess();
        this.setExternalPrograms();
        this.setLogLevel();
        ConfigureFactory.getInstance().saveSettings("sessions", "------ Session Information --------");
        ConfigureFactory.getInstance().saveSettings("etnPgmProps", "tn5250jExternalProgram.properties", "External Program Settings");
        OptionAccessFactory.getInstance().reload();
    }

    private void saveSelectedSessionPreference(String connectKey) {
        Preferences userpref = Preferences.userNodeForPackage(SessionsDataModel.class);
        userpref.put(USER_PREF_LAST_SESSION, connectKey);
    }

    private String loadSelectedSessionPreference() {
        Preferences userpref = Preferences.userNodeForPackage(SessionsDataModel.class);
        return userpref.get(USER_PREF_LAST_SESSION, null);
    }

    private void setExternalPrograms() {
        if (this.browser.getText().trim().length() > 0) {
            this.properties.setProperty("emul.protocol.http", this.browser.getText().trim());
        } else {
            this.properties.remove("emul.protocol.http");
        }
        if (this.mailer.getText().trim().length() > 0) {
            this.properties.setProperty("emul.protocol.mailto", this.mailer.getText().trim());
        } else {
            this.properties.remove("emul.protocol.mailto");
        }
    }

    private void setLogLevel() {
        if (this.intOFF.isSelected()) {
            this.properties.setProperty("emul.logLevel", Integer.toString(32));
        }
        if (this.intDEBUG.isSelected()) {
            this.properties.setProperty("emul.logLevel", Integer.toString(1));
        }
        if (this.intINFO.isSelected()) {
            this.properties.setProperty("emul.logLevel", Integer.toString(2));
        }
        if (this.intWARN.isSelected()) {
            this.properties.setProperty("emul.logLevel", Integer.toString(4));
        }
        if (this.intERROR.isSelected()) {
            this.properties.setProperty("emul.logLevel", Integer.toString(8));
        }
        if (this.intFATAL.isSelected()) {
            this.properties.setProperty("emul.logLevel", Integer.toString(16));
        }
    }

    private void setOptionAccess() {
        String[] options = this.keyMnemonicResolver.getMnemonicsSorted();
        Hashtable<String, String> ht = new Hashtable<String, String>(options.length);
        for (int x = 0; x < options.length; ++x) {
            ht.put(LangTool.getString("key." + options[x]), options[x]);
        }
        Object[] restrict = this.accessOptions.getSelectedValues();
        String s = "";
        for (int x = 0; x < restrict.length; ++x) {
            s = s + (String)ht.get(restrict[x]) + ";";
        }
        this.properties.setProperty("emul.restricted", s);
    }

    private void removeEntry() {
        int selectedRow = this.rowSM.getMinSelectionIndex();
        this.properties.remove(this.ctm.getValueAt(selectedRow, 0));
        this.ctm.removeSession(selectedRow);
    }

    private void removeExternalProgram() {
        int selectedRow = this.rowSM2.getMinSelectionIndex();
        String propKey = (String)this.etm.getValueAt(selectedRow, 0);
        int num = 0;
        Enumeration<Object> e = this.externalProgramConfig.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (propKey == null || !propKey.equals(this.externalProgramConfig.getProperty(key))) continue;
            String subKey = key.substring(8);
            int index = subKey.indexOf(".");
            num = Integer.parseInt(subKey.substring(0, index));
            break;
        }
        Properties newProps = new Properties();
        String count = this.externalProgramConfig.getProperty("etn.pgm.support.total.num");
        if (count != null && count.length() > 0) {
            int total = Integer.parseInt(count);
            for (int i = 1; i <= total; ++i) {
                int order = i;
                if (i > num) {
                    order = i - 1;
                }
                if (i == num) continue;
                String program = this.externalProgramConfig.getProperty("etn.pgm." + i + ".command.name");
                String wCommand = this.externalProgramConfig.getProperty("etn.pgm." + i + ".command.window");
                String uCommand = this.externalProgramConfig.getProperty("etn.pgm." + i + ".command.unix");
                newProps.setProperty("etn.pgm." + order + ".command.name", program);
                newProps.setProperty("etn.pgm." + order + ".command.window", wCommand);
                newProps.setProperty("etn.pgm." + order + ".command.unix", uCommand);
            }
            newProps.setProperty("etn.pgm.support.total.num", String.valueOf(total - 1));
        }
        this.externalProgramConfig.clear();
        this.externalProgramConfig.putAll((Map<?, ?>)newProps);
        this.etm.removeSession(selectedRow);
    }

    private void hideTabBar_itemStateChanged(ItemEvent e) {
        if (this.hideTabBar.isSelected()) {
            this.properties.setProperty("emul.hideTabBar", "yes");
        } else {
            this.properties.remove("emul.hideTabBar");
        }
    }

    private void showMe_itemStateChanged(ItemEvent e) {
        if (this.showMe.isSelected()) {
            this.properties.setProperty("emul.showConnectDialog", "");
        } else {
            this.properties.remove("emul.showConnectDialog");
        }
    }

    private void lastView_itemStateChanged(ItemEvent e) {
        if (this.lastView.isSelected()) {
            this.properties.setProperty("emul.startLastView", "");
        } else {
            this.properties.remove("emul.startLastView");
        }
    }

    private void intOFF_itemStateChanged(ItemEvent e) {
        if (!this.intOFF.isSelected() && TN5250jLogFactory.isLog4j()) {
            this.intConsole.setEnabled(true);
            this.intFile.setEnabled(true);
            this.intBoth.setEnabled(true);
        } else {
            this.intConsole.setEnabled(false);
            this.intConsole.setSelected(true);
            this.intFile.setEnabled(false);
            this.intBoth.setEnabled(false);
            TN5250jLogFactory.setLogLevels(32);
        }
    }

    private void intDEBUG_itemStateChanged(ItemEvent e) {
        if (this.intDEBUG.isSelected()) {
            TN5250jLogFactory.setLogLevels(1);
        }
    }

    private void intINFO_itemStateChanged(ItemEvent e) {
        if (this.intINFO.isSelected()) {
            TN5250jLogFactory.setLogLevels(2);
        }
    }

    private void intWARN_itemStateChanged(ItemEvent e) {
        if (this.intWARN.isSelected()) {
            TN5250jLogFactory.setLogLevels(4);
        }
    }

    private void intERROR_itemStateChanged(ItemEvent e) {
        if (this.intERROR.isSelected()) {
            TN5250jLogFactory.setLogLevels(8);
        }
    }

    private void intFATAL_itemStateChanged(ItemEvent e) {
        if (this.intFATAL.isSelected()) {
            TN5250jLogFactory.setLogLevels(16);
        }
    }

    private class CheckPasswordDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;

        private CheckPasswordDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            super.insertString(offs, str, a);
            if (this.getText(0, this.getLength()).length() > 0) {
                ConnectDialog.this.doSomethingEntered();
            }
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            super.remove(offs, len);
            if (this.getText(0, this.getLength()).length() == 0) {
                ConnectDialog.this.doNothingEntered();
            }
        }
    }
}

