/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.connectdialog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.swing.table.AbstractTableModel;
import org.tn5250j.connectdialog.CustomizedExternalProgram;
import org.tn5250j.gui.SortTableModel;
import org.tn5250j.tools.LangTool;

class CustomizedTableModel
extends AbstractTableModel
implements SortTableModel {
    private static final long serialVersionUID = 1L;
    private final String[] cols = new String[]{LangTool.getString("customized.name"), LangTool.getString("customized.window"), LangTool.getString("customized.unix")};
    private List<CustomizedExternalProgram> externalPrograms = new ArrayList<CustomizedExternalProgram>();
    private int sortedColumn = 0;
    private boolean isAscending = true;
    private final Properties externalProgramConfig;

    CustomizedTableModel(Properties externalProgramConfig) {
        this.externalProgramConfig = externalProgramConfig;
        this.resetSorted();
    }

    private void resetSorted() {
        this.externalPrograms.clear();
        String count = this.externalProgramConfig.getProperty("etn.pgm.support.total.num");
        if (count != null && count.length() > 0) {
            int total = Integer.parseInt(count);
            for (int i = 1; i <= total; ++i) {
                String program = this.externalProgramConfig.getProperty("etn.pgm." + i + ".command.name");
                String wCommand = this.externalProgramConfig.getProperty("etn.pgm." + i + ".command.window");
                String uCommand = this.externalProgramConfig.getProperty("etn.pgm." + i + ".command.unix");
                this.externalPrograms.add(new CustomizedExternalProgram(program, wCommand, uCommand));
            }
        }
        this.sortColumn(this.sortedColumn, this.isAscending);
    }

    @Override
    public boolean isSortable(int col) {
        return col == 0;
    }

    @Override
    public void sortColumn(int col, boolean ascending) {
        this.sortedColumn = col;
        this.isAscending = ascending;
        Collections.sort(this.externalPrograms);
        if (!this.isAscending) {
            Collections.reverse(this.externalPrograms);
        }
    }

    @Override
    public int getColumnCount() {
        return this.cols.length;
    }

    @Override
    public String getColumnName(int col) {
        return this.cols[col];
    }

    @Override
    public int getRowCount() {
        return this.externalPrograms.size();
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
    }

    @Override
    public Object getValueAt(int row, int col) {
        CustomizedExternalProgram c = this.externalPrograms.get(row);
        if (col == 0) {
            return c.getName();
        }
        if (col == 1) {
            return c.getWCommand();
        }
        if (col == 2) {
            return c.getUCommand();
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public Class<?> getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    void addSession() {
        this.resetSorted();
        this.fireTableRowsInserted(this.externalPrograms.size() - 1, this.externalPrograms.size() - 1);
    }

    void chgSession(int row) {
        this.resetSorted();
        this.fireTableRowsUpdated(row, row);
    }

    void removeSession(int row) {
        this.resetSorted();
        this.fireTableRowsDeleted(row, row);
    }
}

