/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.connectdialog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.swing.table.AbstractTableModel;
import org.tn5250j.connectdialog.Configure;
import org.tn5250j.connectdialog.SessionsDataModel;
import org.tn5250j.gui.SortTableModel;
import org.tn5250j.tools.LangTool;

class SessionsTableModel
extends AbstractTableModel
implements SortTableModel {
    private static final long serialVersionUID = 1L;
    private final Properties properties;
    private final String[] COLS = new String[]{LangTool.getString("conf.tableColA"), LangTool.getString("conf.tableColB"), LangTool.getString("conf.tableColC")};
    private List<SessionsDataModel> sortedItems = new ArrayList<SessionsDataModel>();

    SessionsTableModel(Properties properties) {
        this.properties = properties;
        this.resetSorted();
    }

    private void resetSorted() {
        Enumeration<Object> e = this.properties.keys();
        this.sortedItems.clear();
        String ses = null;
        while (e.hasMoreElements()) {
            ses = (String)e.nextElement();
            if (ses.startsWith("emul.")) continue;
            String[] args = new String[20];
            Configure.parseArgs(this.properties.getProperty(ses), args);
            boolean deflt = ses.equals(this.properties.getProperty("emul.default", ""));
            this.sortedItems.add(new SessionsDataModel(ses, args[0], deflt));
        }
        this.sortColumn(0, true);
    }

    @Override
    public boolean isSortable(int col) {
        if (col == 0) {
            return true;
        }
        return col == 1;
    }

    @Override
    public void sortColumn(int col, final boolean ascending) {
        if (col == 0) {
            Collections.sort(this.sortedItems, new Comparator<SessionsDataModel>(){

                @Override
                public int compare(SessionsDataModel sdm1, SessionsDataModel sdm2) {
                    if (ascending) {
                        return sdm1.name.compareToIgnoreCase(sdm2.name);
                    }
                    return sdm2.name.compareToIgnoreCase(sdm1.name);
                }
            });
        }
        if (col == 1) {
            Collections.sort(this.sortedItems, new Comparator<SessionsDataModel>(){

                @Override
                public int compare(SessionsDataModel sdm1, SessionsDataModel sdm2) {
                    if (ascending) {
                        return sdm1.host.compareToIgnoreCase(sdm2.host);
                    }
                    return sdm2.host.compareToIgnoreCase(sdm1.host);
                }
            });
        }
    }

    @Override
    public int getColumnCount() {
        return this.COLS.length;
    }

    @Override
    public String getColumnName(int col) {
        return this.COLS[col];
    }

    @Override
    public int getRowCount() {
        return this.sortedItems.size();
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        boolean which = (Boolean)value;
        String newDefaultSession = this.sortedItems.get((int)row).name;
        if (which) {
            this.properties.setProperty("emul.default", newDefaultSession);
        } else {
            this.properties.setProperty("emul.default", "");
        }
        int len = this.sortedItems.size();
        for (int i = 0; i < len; ++i) {
            SessionsDataModel oldsdm = this.sortedItems.get(i);
            if (newDefaultSession.equals(oldsdm.name)) {
                this.sortedItems.set(i, new SessionsDataModel(oldsdm.name, oldsdm.host, (Boolean)value));
                continue;
            }
            if (!oldsdm.deflt.booleanValue()) continue;
            this.sortedItems.set(i, new SessionsDataModel(oldsdm.name, oldsdm.host, Boolean.FALSE));
        }
        this.fireTableDataChanged();
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return this.sortedItems.get((int)row).name;
            }
            case 1: {
                return this.sortedItems.get((int)row).host;
            }
            case 2: {
                return this.sortedItems.get((int)row).deflt;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 2;
    }

    @Override
    public Class<?> getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    void addSession() {
        this.resetSorted();
        this.fireTableRowsInserted(this.properties.size() - 1, this.properties.size() - 1);
    }

    void chgSession(int row) {
        this.resetSorted();
        this.fireTableRowsUpdated(row, row);
    }

    void removeSession(int row) {
        this.resetSorted();
        this.fireTableRowsDeleted(row, row);
    }
}

