/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.encoding;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.tn5250j.encoding.ICodePage;
import org.tn5250j.encoding.builtin.CCSID1025;
import org.tn5250j.encoding.builtin.CCSID1026;
import org.tn5250j.encoding.builtin.CCSID1112;
import org.tn5250j.encoding.builtin.CCSID1140;
import org.tn5250j.encoding.builtin.CCSID1141;
import org.tn5250j.encoding.builtin.CCSID1147;
import org.tn5250j.encoding.builtin.CCSID1148;
import org.tn5250j.encoding.builtin.CCSID273;
import org.tn5250j.encoding.builtin.CCSID277;
import org.tn5250j.encoding.builtin.CCSID278;
import org.tn5250j.encoding.builtin.CCSID280;
import org.tn5250j.encoding.builtin.CCSID284;
import org.tn5250j.encoding.builtin.CCSID285;
import org.tn5250j.encoding.builtin.CCSID297;
import org.tn5250j.encoding.builtin.CCSID37;
import org.tn5250j.encoding.builtin.CCSID424;
import org.tn5250j.encoding.builtin.CCSID500;
import org.tn5250j.encoding.builtin.CCSID870;
import org.tn5250j.encoding.builtin.CCSID871;
import org.tn5250j.encoding.builtin.CCSID875;
import org.tn5250j.encoding.builtin.ICodepageConverter;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

class BuiltInCodePageFactory {
    private static BuiltInCodePageFactory singleton;
    private final List<Class<?>> clazzes = new ArrayList();
    private final TN5250jLogger log = TN5250jLogFactory.getLogger(this.getClass());

    private BuiltInCodePageFactory() {
        this.register();
    }

    public static final synchronized BuiltInCodePageFactory getInstance() {
        if (singleton == null) {
            singleton = new BuiltInCodePageFactory();
        }
        return singleton;
    }

    private void register() {
        this.clazzes.add(CCSID37.class);
        this.clazzes.add(CCSID273.class);
        this.clazzes.add(CCSID277.class);
        this.clazzes.add(CCSID278.class);
        this.clazzes.add(CCSID280.class);
        this.clazzes.add(CCSID284.class);
        this.clazzes.add(CCSID285.class);
        this.clazzes.add(CCSID297.class);
        this.clazzes.add(CCSID424.class);
        this.clazzes.add(CCSID500.class);
        this.clazzes.add(CCSID870.class);
        this.clazzes.add(CCSID871.class);
        this.clazzes.add(CCSID875.class);
        this.clazzes.add(CCSID1025.class);
        this.clazzes.add(CCSID1026.class);
        this.clazzes.add(CCSID1112.class);
        this.clazzes.add(CCSID1140.class);
        this.clazzes.add(CCSID1141.class);
        this.clazzes.add(CCSID1147.class);
        this.clazzes.add(CCSID1148.class);
    }

    public String[] getAvailableCodePages() {
        HashSet<String> cpset = new HashSet<String>();
        for (Class<?> clazz : this.clazzes) {
            ICodepageConverter converter = this.getConverterFromClassName(clazz);
            if (converter == null) continue;
            cpset.add(converter.getName());
        }
        return cpset.toArray(new String[cpset.size()]);
    }

    public ICodePage getCodePage(String encoding) {
        for (Class<?> clazz : this.clazzes) {
            ICodepageConverter converter = this.getConverterFromClassName(clazz);
            if (converter == null || !converter.getName().equals(encoding)) continue;
            return converter;
        }
        return null;
    }

    private ICodepageConverter getConverterFromClassName(Class<?> clazz) {
        try {
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            ICodepageConverter converter = (ICodepageConverter)constructor.newInstance(new Object[0]);
            converter.init();
            return converter;
        }
        catch (Exception e) {
            this.log.error("Couldn't load code page converter class:" + clazz.getCanonicalName(), e);
            return null;
        }
    }
}

