/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.encoding.builtin;

import java.util.Arrays;
import org.tn5250j.encoding.builtin.ICodepageConverter;

public abstract class CodepageConverterAdapter
implements ICodepageConverter {
    private char[] codepage = null;
    private int[] reverse_codepage = null;

    @Override
    public ICodepageConverter init() {
        int i;
        this.codepage = this.getCodePage();
        int size = 0;
        for (i = 0; i < this.codepage.length; ++i) {
            size = Math.max(size, this.codepage[i]);
        }
        assert (size + 1 < 0x100000);
        this.reverse_codepage = new int[size + 1];
        Arrays.fill(this.reverse_codepage, 63);
        for (i = 0; i < this.codepage.length; ++i) {
            this.reverse_codepage[this.codepage[i]] = i;
        }
        return this;
    }

    @Override
    public byte uni2ebcdic(char index) {
        assert (index < this.reverse_codepage.length);
        return (byte)this.reverse_codepage[index];
    }

    @Override
    public char ebcdic2uni(int index) {
        assert ((index &= 0xFF) < 256);
        return this.codepage[index];
    }

    protected abstract char[] getCodePage();
}

