/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.framework.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.tn5250j.Session5250;
import org.tn5250j.SessionConfig;
import org.tn5250j.SessionPanel;
import org.tn5250j.framework.common.Sessions;
import org.tn5250j.interfaces.SessionManagerInterface;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

public class SessionManager
implements SessionManagerInterface {
    private static Sessions sessions;
    private static List<SessionConfig> configs;
    private TN5250jLogger log = TN5250jLogFactory.getLogger(this.getClass());
    private static SessionManager _instance;

    protected SessionManager() {
        if (_instance == null) {
            this.initialize();
            _instance = this;
        }
    }

    public static SessionManager instance() {
        if (_instance == null) {
            _instance = new SessionManager();
        }
        return _instance;
    }

    private void initialize() {
        this.log.info("New session Manager initialized");
        sessions = new Sessions();
        configs = new ArrayList<SessionConfig>();
    }

    @Override
    public Sessions getSessions() {
        return sessions;
    }

    @Override
    public void closeSession(SessionPanel sesspanel) {
        sesspanel.closeDown();
        sessions.removeSession(sesspanel.getSession());
    }

    @Override
    public synchronized Session5250 openSession(Properties sesProps, String configurationResource, String sessionName) {
        if (sessionName == null) {
            sesProps.put("SESSION_TERM_NAME", sesProps.getProperty("SESSION_HOST"));
        } else {
            sesProps.put("SESSION_TERM_NAME", sessionName);
        }
        if (configurationResource == null) {
            configurationResource = "";
        }
        sesProps.put("SESSION_CONFIG_RESOURCE", configurationResource);
        SessionConfig useConfig = null;
        for (SessionConfig conf : configs) {
            if (!conf.getSessionName().equals(sessionName)) continue;
            useConfig = conf;
        }
        if (useConfig == null) {
            useConfig = new SessionConfig(configurationResource, sessionName);
            configs.add(useConfig);
        }
        Session5250 newSession = new Session5250(sesProps, configurationResource, sessionName, useConfig);
        sessions.addSession(newSession);
        return newSession;
    }
}

