/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.framework.tn5250;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.SocketException;
import java.util.concurrent.BlockingQueue;
import org.tn5250j.encoding.ICodePage;
import org.tn5250j.framework.tn5250.DataStreamDumper;
import org.tn5250j.framework.tn5250.tnvt;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

public class DataStreamProducer
implements Runnable {
    private static final int MINIMAL_PARTIAL_STREAM_LEN = 2;
    private BufferedInputStream bin;
    private ByteArrayOutputStream baosin;
    private byte[] saveStream;
    private final BlockingQueue<Object> dsq;
    private tnvt vt;
    private byte[] dataStream;
    private DataStreamDumper dataStreamDumper = new DataStreamDumper();
    private TN5250jLogger log = TN5250jLogFactory.getLogger(this.getClass());

    public DataStreamProducer(tnvt vt, BufferedInputStream in, BlockingQueue<Object> queue, byte[] init) {
        this.bin = in;
        this.vt = vt;
        this.baosin = new ByteArrayOutputStream();
        this.dsq = queue;
        this.dataStream = init;
    }

    @Override
    public final void run() {
        boolean done = false;
        Thread me = Thread.currentThread();
        this.loadStream(this.dataStream, 0);
        while (!done) {
            try {
                byte[] abyte0 = this.readIncoming();
                if (abyte0 == null) continue;
                if (abyte0.length > 0) {
                    this.loadStream(abyte0, 0);
                    continue;
                }
                done = true;
                this.vt.disconnect();
            }
            catch (SocketException se) {
                this.log.warn("   DataStreamProducer thread interrupted and stopping " + se.getMessage());
                done = true;
            }
            catch (IOException ioe) {
                this.log.warn(ioe.getMessage());
                if (!me.isInterrupted()) continue;
                done = true;
            }
            catch (Exception ex) {
                this.log.warn(ex.getMessage());
                if (!me.isInterrupted()) continue;
                done = true;
            }
        }
    }

    private void loadStream(byte[] streamBuffer, int offset) {
        int partialLen = (streamBuffer[offset] & 0xFF) << 8 | streamBuffer[offset + 1] & 0xFF;
        int bufferLen = streamBuffer.length;
        if (this.log.isDebugEnabled()) {
            this.log.debug("loadStream() offset=" + offset + " partialLen=" + partialLen + " bufferLen=" + bufferLen);
        }
        if (this.saveStream != null) {
            this.log.debug("partial stream found");
            bufferLen = this.saveStream.length + streamBuffer.length;
            byte[] inter = new byte[bufferLen];
            System.arraycopy(this.saveStream, 0, inter, 0, this.saveStream.length);
            System.arraycopy(streamBuffer, 0, inter, this.saveStream.length, streamBuffer.length);
            streamBuffer = new byte[bufferLen];
            System.arraycopy(inter, 0, streamBuffer, 0, bufferLen);
            this.saveStream = null;
        }
        if (partialLen > bufferLen) {
            this.saveStream = new byte[streamBuffer.length];
            this.log.debug("partial stream saved");
            System.arraycopy(streamBuffer, 0, this.saveStream, 0, streamBuffer.length);
        } else {
            int buf_len = partialLen + 2;
            byte[] buf = new byte[buf_len];
            if (this.isBufferShifted(partialLen, bufferLen) && this.isOpcodeShifted(streamBuffer, offset)) {
                this.log.debug("Invalid stream buffer detected. Ignoring the inserted byte.");
                System.arraycopy(streamBuffer, offset, buf, 0, 2);
                System.arraycopy(streamBuffer, offset + 2 + 1, buf, 2, partialLen);
            } else {
                System.arraycopy(streamBuffer, offset, buf, 0, buf_len);
            }
            try {
                this.dsq.put(buf);
                if (streamBuffer.length > buf.length + offset + 2) {
                    this.loadStream(streamBuffer, offset + buf_len);
                }
            }
            catch (InterruptedException ex) {
                this.log.warn("load stream error.", ex);
            }
        }
    }

    private boolean isOpcodeShifted(byte[] streamBuffer, int offset) {
        byte code = streamBuffer[offset + 1 + 9];
        return 0 <= code && code <= 12;
    }

    private boolean isBufferShifted(int partialLen, int bufferLen) {
        return partialLen + 2 + 1 == bufferLen;
    }

    public final byte[] readIncoming() throws IOException {
        boolean done = false;
        boolean negotiate = false;
        this.baosin.reset();
        int j = -1;
        while (!done) {
            int i = this.bin.read();
            if (i == -1) {
                done = true;
                this.vt.disconnect();
                continue;
            }
            if (j == 255 && i == 255) {
                j = -1;
                continue;
            }
            this.baosin.write(i);
            if (j == 255 && i == 239) {
                done = true;
            }
            if (i == 253 && j == 255) {
                done = true;
                negotiate = true;
            }
            j = i;
        }
        byte[] rBytes = this.baosin.toByteArray();
        this.dataStreamDumper.dump(rBytes);
        if (negotiate) {
            this.baosin.write(this.bin.read());
            this.vt.negotiate(rBytes);
            return null;
        }
        return rBytes;
    }

    protected void toggleDebug(ICodePage codePage) {
        this.dataStreamDumper.toggleDebug(codePage);
    }
}

