/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.framework.tn5250;

import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

public class KeyStrokenizer {
    private StringBuffer keyStrokes;
    private StringBuffer sb;
    private int index;
    private int length;
    private final TN5250jLogger log = TN5250jLogFactory.getLogger(this.getClass());

    public KeyStrokenizer() {
        this.sb = new StringBuffer();
        this.setKeyStrokes(null);
    }

    public void setKeyStrokes(String strokes) {
        if (strokes != null) {
            this.keyStrokes.setLength(0);
            this.log.debug("set " + this.keyStrokes);
            this.length = strokes.length();
        } else {
            this.keyStrokes = new StringBuffer();
            this.length = 0;
        }
        this.keyStrokes.append(strokes);
        this.index = 0;
    }

    public boolean hasMoreKeyStrokes() {
        return this.length > this.index;
    }

    public String nextKeyStroke() {
        String s = "";
        boolean gotOne = false;
        if (this.length > this.index) {
            this.sb.setLength(0);
            char c = this.keyStrokes.charAt(this.index);
            switch (c) {
                case '[': {
                    this.sb.append(c);
                    ++this.index;
                    if (this.index >= this.length) {
                        this.log.warn(" mnemonic key was incomplete :1 at position " + this.index + " len " + this.length);
                        break;
                    }
                    c = this.keyStrokes.charAt(this.index);
                    if (c == '[') {
                        ++this.index;
                        break;
                    }
                    while (!gotOne) {
                        if (c == ']') {
                            this.sb.append(c);
                            ++this.index;
                            gotOne = true;
                            continue;
                        }
                        this.sb.append(c);
                        ++this.index;
                        if (this.index >= this.length) {
                            this.log.warn(" mnemonic key was incomplete ending not found :2 at position " + this.index);
                        }
                        c = this.keyStrokes.charAt(this.index);
                    }
                    break;
                }
                case ']': {
                    ++this.index;
                    if (this.index >= this.length) {
                        this.log.warn(" mnemonic key was incomplete ending not found :3 at position " + this.index);
                        this.sb.append(c);
                        ++this.index;
                        break;
                    }
                    c = this.keyStrokes.charAt(this.index);
                    if (c == ']') {
                        this.sb.append(c);
                        ++this.index;
                        break;
                    }
                    this.log.warn(" mnemonic key was incomplete beginning not found :4 at position " + this.index);
                    break;
                }
                default: {
                    this.sb.append(c);
                    ++this.index;
                }
            }
            if (this.sb != null) {
                s = new String(this.sb);
            }
        }
        this.log.debug("next " + this.keyStrokes);
        return s;
    }

    public String getUnprocessedKeyStroked() {
        if (this.index >= this.length) {
            return null;
        }
        return this.keyStrokes.substring(this.index);
    }
}

