/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.framework.tn5250;

import java.util.Vector;
import org.tn5250j.event.ScreenOIAListener;
import org.tn5250j.framework.tn5250.Screen5250;

public class ScreenOIA {
    public static final int OIA_LEVEL_INPUT_INHIBITED = 1;
    public static final int OIA_LEVEL_NOT_INHIBITED = 2;
    public static final int OIA_LEVEL_MESSAGE_LIGHT_ON = 3;
    public static final int OIA_LEVEL_MESSAGE_LIGHT_OFF = 4;
    public static final int OIA_LEVEL_AUDIBLE_BELL = 5;
    public static final int OIA_LEVEL_INSERT_MODE = 6;
    public static final int OIA_LEVEL_KEYBOARD = 7;
    public static final int OIA_LEVEL_CLEAR_SCREEN = 8;
    public static final int OIA_LEVEL_SCREEN_SIZE = 9;
    public static final int OIA_LEVEL_INPUT_ERROR = 10;
    public static final int OIA_LEVEL_KEYS_BUFFERED = 11;
    public static final int OIA_LEVEL_SCRIPT = 12;
    public static final int INPUTINHIBITED_NOTINHIBITED = 0;
    public static final int INPUTINHIBITED_SYSTEM_WAIT = 1;
    public static final int INPUTINHIBITED_COMMCHECK = 2;
    public static final int INPUTINHIBITED_PROGCHECK = 3;
    public static final int INPUTINHIBITED_MACHINECHECK = 4;
    public static final int INPUTINHIBITED_OTHER = 5;
    private Vector<ScreenOIAListener> listeners = null;
    private boolean insertMode;
    private boolean locked;
    private boolean keysBuffered;
    private int owner = 0;
    private int level = 0;
    private Screen5250 source = null;
    private int commCheck = 0;
    private int machineCheck = 0;
    private boolean messageWait;
    private boolean scriptRunning;
    private int inputInhibited = 0;
    private String inhibitedText;

    public ScreenOIA(Screen5250 screen) {
        this.source = screen;
    }

    public boolean isInsertMode() {
        return this.insertMode;
    }

    protected void setInsertMode(boolean mode) {
        this.level = 6;
        this.insertMode = mode;
        this.fireOIAChanged(0);
    }

    public int getCommCheckCode() {
        return this.commCheck;
    }

    public int getInputInhibited() {
        return this.inputInhibited;
    }

    public int getMachineCheckCode() {
        return this.machineCheck;
    }

    public int getOwner() {
        return this.owner;
    }

    public int getProgCheckCode() {
        return 0;
    }

    public boolean isKeyBoardLocked() {
        return this.locked;
    }

    public boolean isKeysBuffered() {
        return this.keysBuffered;
    }

    public void setKeysBuffered(boolean kb) {
        this.level = 11;
        boolean oldKB = this.keysBuffered;
        this.keysBuffered = kb;
        if (this.keysBuffered != oldKB) {
            this.fireOIAChanged(1);
        }
    }

    protected void setKeyBoardLocked(boolean lockIt) {
        this.level = 7;
        boolean oldLocked = this.locked;
        this.locked = lockIt;
        if (!lockIt && this.isKeysBuffered()) {
            this.source.sendKeys("");
        }
        if (this.locked != oldLocked) {
            this.fireOIAChanged(2);
        }
    }

    public boolean isMessageWait() {
        return this.messageWait;
    }

    protected void setMessageLightOn() {
        this.level = 3;
        this.messageWait = true;
        this.fireOIAChanged(3);
    }

    protected void setMessageLightOff() {
        this.level = 4;
        this.messageWait = false;
        this.fireOIAChanged(3);
    }

    public void setScriptActive(boolean running) {
        this.level = 12;
        this.scriptRunning = running;
        this.fireOIAChanged(4);
    }

    public boolean isScriptActive() {
        return this.scriptRunning;
    }

    public void setAudibleBell() {
        this.level = 5;
        this.fireOIAChanged(5);
    }

    protected void clearScreen() {
        this.level = 8;
        this.fireOIAChanged(6);
    }

    public void addOIAListener(ScreenOIAListener listener) {
        if (this.listeners == null) {
            this.listeners = new Vector(3);
        }
        this.listeners.addElement(listener);
    }

    public void removeOIAListener(ScreenOIAListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(listener);
    }

    public Screen5250 getSource() {
        return this.source;
    }

    public void setSource(Screen5250 screen) {
        this.source = screen;
    }

    public void setOwner(int newOwner) {
        this.owner = newOwner;
    }

    public int getLevel() {
        return this.level;
    }

    public String getInhibitedText() {
        return this.inhibitedText;
    }

    public void setInputInhibited(int inhibit, int whatCode) {
        this.setInputInhibited(inhibit, whatCode, null);
    }

    public void setInputInhibited(int inhibit, int whatCode, String message) {
        this.inputInhibited = inhibit;
        this.level = 1;
        this.inhibitedText = message;
        switch (inhibit) {
            case 2: {
                this.commCheck = whatCode;
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.machineCheck = whatCode;
                break;
            }
            case 1: {
                this.level = whatCode;
                break;
            }
            case 0: {
                this.level = whatCode;
            }
        }
        this.fireOIAChanged(7);
    }

    private void fireOIAChanged(int change) {
        if (this.listeners != null) {
            int size = this.listeners.size();
            for (int i = 0; i < size; ++i) {
                ScreenOIAListener target = this.listeners.elementAt(i);
                target.onOIAChanged(this, change);
            }
        }
    }
}

