/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.framework.transport.SSL;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.Socket;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.swing.JOptionPane;
import org.tn5250j.framework.transport.SSLInterface;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

public class SSLImplementation
implements SSLInterface,
X509TrustManager {
    SSLContext sslContext = null;
    KeyStore userks = null;
    private String userKsPath;
    private char[] userksPassword = "changeit".toCharArray();
    KeyManagerFactory userkmf = null;
    TrustManagerFactory usertmf = null;
    TrustManager[] userTrustManagers = null;
    X509Certificate[] acceptedIssuers;
    TN5250jLogger logger = TN5250jLogFactory.getLogger(this.getClass());

    @Override
    public void init(String sslType) {
        try {
            this.logger.debug("Initializing User KeyStore");
            this.userKsPath = System.getProperty("user.home") + File.separator + ".tn5250j" + File.separator + "keystore";
            File userKsFile = new File(this.userKsPath);
            this.userks = KeyStore.getInstance(KeyStore.getDefaultType());
            this.userks.load(userKsFile.exists() ? new FileInputStream(userKsFile) : null, this.userksPassword);
            this.logger.debug("Initializing User Key Manager Factory");
            this.userkmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            this.userkmf.init(this.userks, this.userksPassword);
            this.logger.debug("Initializing User Trust Manager Factory");
            this.usertmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            this.usertmf.init(this.userks);
            this.userTrustManagers = this.usertmf.getTrustManagers();
            this.logger.debug("Initializing SSL Context");
            this.sslContext = SSLContext.getInstance(sslType);
            this.sslContext.init(this.userkmf.getKeyManagers(), new TrustManager[]{this}, null);
        }
        catch (Exception ex) {
            this.logger.error("Error initializing SSL [" + ex.getMessage() + "]");
        }
    }

    @Override
    public Socket createSSLSocket(String destination, int port) {
        if (this.sslContext == null) {
            throw new IllegalStateException("SSL Context Not Initialized");
        }
        SSLSocket socket = null;
        try {
            socket = (SSLSocket)this.sslContext.getSocketFactory().createSocket(destination, port);
        }
        catch (Exception e) {
            this.logger.error("Error creating ssl socket [" + e.getMessage() + "]");
        }
        return socket;
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.acceptedIssuers;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        throw new SecurityException("checkClientTrusted unsupported");
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String type) throws CertificateException {
        try {
            for (int i = 0; i < this.userTrustManagers.length; ++i) {
                if (!(this.userTrustManagers[i] instanceof X509TrustManager)) continue;
                X509TrustManager trustManager = (X509TrustManager)this.userTrustManagers[i];
                X509Certificate[] calist = trustManager.getAcceptedIssuers();
                if (calist.length > 0) {
                    trustManager.checkServerTrusted(chain, type);
                    continue;
                }
                throw new CertificateException("Empty list of accepted issuers (a.k.a. root CA list).");
            }
            return;
        }
        catch (CertificateException ce) {
            X509Certificate cert = chain[0];
            String certInfo = "Version: " + cert.getVersion() + "\n";
            certInfo = certInfo.concat("Serial Number: " + cert.getSerialNumber() + "\n");
            certInfo = certInfo.concat("Signature Algorithm: " + cert.getSigAlgName() + "\n");
            certInfo = certInfo.concat("Issuer: " + cert.getIssuerDN().getName() + "\n");
            certInfo = certInfo.concat("Valid From: " + cert.getNotBefore() + "\n");
            certInfo = certInfo.concat("Valid To: " + cert.getNotAfter() + "\n");
            certInfo = certInfo.concat("Subject DN: " + cert.getSubjectDN().getName() + "\n");
            certInfo = certInfo.concat("Public Key: " + cert.getPublicKey().getFormat() + "\n");
            int accept = JOptionPane.showConfirmDialog(null, certInfo, "Unknown Certificate - Do you accept it?", 0);
            if (accept != 0) {
                throw new CertificateException("Certificate Rejected");
            }
            int save = JOptionPane.showConfirmDialog(null, "Remember this certificate?", "Save Certificate", 0);
            if (save == 0) {
                try {
                    this.userks.setCertificateEntry(cert.getSubjectDN().getName(), cert);
                    this.userks.store(new FileOutputStream(this.userKsPath), this.userksPassword);
                }
                catch (Exception e) {
                    this.logger.error("Error saving certificate [" + e.getMessage() + "]");
                    e.printStackTrace();
                }
            }
            return;
        }
    }
}

