/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.gui;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import org.tn5250j.gui.JSortTable;
import org.tn5250j.gui.SortArrowIcon;

public class SortHeaderRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    public static Icon NONSORTED = new SortArrowIcon(0);
    public static Icon ASCENDING = new SortArrowIcon(2);
    public static Icon DECENDING = new SortArrowIcon(1);

    public SortHeaderRenderer() {
        this.setHorizontalTextPosition(2);
        this.setHorizontalAlignment(0);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        JTableHeader header;
        int index = -1;
        boolean ascending = true;
        if (table instanceof JSortTable) {
            JSortTable sortTable = (JSortTable)table;
            index = sortTable.getSortedColumnIndex();
            ascending = sortTable.isSortedColumnAscending();
        }
        if (table != null && (header = table.getTableHeader()) != null) {
            this.setForeground(header.getForeground());
            this.setBackground(header.getBackground());
            this.setFont(header.getFont());
        }
        Icon icon = ascending ? ASCENDING : DECENDING;
        this.setIcon(col == index ? icon : NONSORTED);
        this.setText(value == null ? "" : value.toString());
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        return this;
    }
}

