/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.gui;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.ImageIcon;
import org.tn5250j.tools.GUIGraphicsUtils;

public class TN5250jSplashScreen
extends Canvas {
    private static final long serialVersionUID = 1L;
    protected Window dialog = null;
    protected Frame f = null;
    protected Image image;
    private Image offScreenBuffer;
    private Graphics offScreenBufferGraphics;
    private int steps;
    private int progress;
    private Object lock = new Object();

    public TN5250jSplashScreen(String image_location) {
        this.initialize(GUIGraphicsUtils.createImageIcon(image_location));
    }

    public TN5250jSplashScreen(ImageIcon image) {
        this.initialize(image);
    }

    protected void initialize(ImageIcon iimage) {
        int y;
        this.image = iimage.getImage();
        if (this.image == null) {
            throw new IllegalArgumentException("Image specified is invalid.");
        }
        MediaTracker tracker = new MediaTracker(this);
        tracker.addImage(this.image, 0);
        try {
            tracker.waitForAll();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        this.f = new Frame();
        this.dialog = new Window(this.f);
        this.dialog.setCursor(Cursor.getPredefinedCursor(3));
        Dimension s = new Dimension(this.image.getWidth(this) + 2, this.image.getHeight(this) + 2);
        this.setSize(s);
        this.dialog.setLayout(new BorderLayout());
        this.dialog.setSize(s);
        this.dialog.add((Component)this, "Center");
        this.dialog.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screen.width - s.width) / 2;
        if (x < 0) {
            x = 0;
        }
        if ((y = (screen.height - s.height) / 2) < 0) {
            y = 0;
        }
        this.dialog.setLocation(x, y);
        this.dialog.validate();
    }

    public void setSteps(int step) {
        this.steps = step;
    }

    public synchronized void updateProgress(int prog) {
        if (this.dialog == null || this.f == null) {
            return;
        }
        this.progress = prog;
        this.repaint();
        try {
            this.wait();
        }
        catch (InterruptedException ie) {
            System.out.println(" updateProgress " + ie.getMessage());
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public synchronized void paint(Graphics g) {
        int inset = 5;
        int height = 14;
        Dimension size = this.getSize();
        if (this.offScreenBuffer == null) {
            this.offScreenBuffer = this.createImage(size.width, size.height);
            this.offScreenBufferGraphics = this.offScreenBuffer.getGraphics();
        }
        this.offScreenBufferGraphics.drawImage(this.image, 1, 1, this);
        this.offScreenBufferGraphics.setColor(new Color(204, 204, 255));
        this.offScreenBufferGraphics.draw3DRect(0, 0, size.width - 1, size.height - 1, true);
        this.offScreenBufferGraphics.setColor(new Color(204, 204, 255).darker());
        this.offScreenBufferGraphics.fill3DRect(inset - 1, this.image.getHeight(this) - (height + 2), this.image.getWidth(this) - inset * 2, height + 1, false);
        this.offScreenBufferGraphics.setColor(new Color(204, 204, 255));
        this.offScreenBufferGraphics.fillRect(inset, this.image.getHeight(this) - (height + 1), (this.image.getWidth(this) - inset * 2) / this.steps * this.progress, height);
        g.drawImage(this.offScreenBuffer, 0, 0, this);
        this.notify();
    }

    @Override
    public void setVisible(boolean show) {
        if (show && this.dialog != null && this.f != null && !this.dialog.isVisible()) {
            this.dialog.setVisible(true);
        } else {
            if (this.dialog != null) {
                this.updateProgress(this.steps + 1);
                this.dialog.setCursor(Cursor.getPredefinedCursor(0));
                this.dialog.dispose();
            }
            if (this.f != null) {
                this.f.dispose();
            }
            this.dialog = null;
            this.f = null;
        }
    }
}

