/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.gui;

import java.util.Vector;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.tn5250j.event.ToggleDocumentListener;

public class ToggleDocument
extends PlainDocument {
    private static final long serialVersionUID = 1L;
    Vector<ToggleDocumentListener> listeners;

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        super.insertString(offs, str, a);
        if (this.getText(0, this.getLength()).length() > 0) {
            this.fireNotEmpty();
        }
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        super.remove(offs, len);
        if (this.getText(0, this.getLength()).length() == 0) {
            this.fireEmpty();
        }
    }

    public synchronized void addToggleDocumentListener(ToggleDocumentListener listener) {
        if (this.listeners == null) {
            this.listeners = new Vector(3);
        }
        this.listeners.addElement(listener);
    }

    public synchronized void removeToggleDocumentListener(ToggleDocumentListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(listener);
    }

    public void fireNotEmpty() {
        if (this.listeners != null) {
            int size = this.listeners.size();
            for (int i = 0; i < size; ++i) {
                ToggleDocumentListener target = this.listeners.elementAt(i);
                target.toggleNotEmpty();
            }
        }
    }

    public void fireEmpty() {
        if (this.listeners != null) {
            int size = this.listeners.size();
            for (int i = 0; i < size; ++i) {
                ToggleDocumentListener target = this.listeners.elementAt(i);
                target.toggleEmpty();
            }
        }
    }
}

