/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.gui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.tn5250j.event.WizardEvent;
import org.tn5250j.event.WizardListener;
import org.tn5250j.gui.WizardPage;

public class Wizard
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected CardLayout cardLayout;
    protected transient Vector<WizardListener> listeners;
    protected transient ActionListener nextListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Wizard.this.next();
        }
    };
    protected transient ActionListener previousListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Wizard.this.previous();
        }
    };
    protected transient ActionListener finishListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent ev) {
            Wizard.this.finish();
        }
    };
    protected transient ActionListener cancelListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent ev) {
            Wizard.this.cancel();
        }
    };
    protected transient ActionListener helpListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent ev) {
            Wizard.this.help();
        }
    };
    protected transient ContainerListener containerListener = new ContainerListener(){

        @Override
        public void componentAdded(ContainerEvent e) {
            if (e.getChild() instanceof WizardPage) {
                WizardPage wp = (WizardPage)e.getChild();
                JButton b = wp.getNextButton();
                if (b != null) {
                    b.addActionListener(Wizard.this.nextListener);
                }
                if ((b = wp.getPreviousButton()) != null) {
                    b.addActionListener(Wizard.this.previousListener);
                }
                if ((b = wp.getFinishButton()) != null) {
                    b.addActionListener(Wizard.this.finishListener);
                }
                if ((b = wp.getCancelButton()) != null) {
                    b.addActionListener(Wizard.this.cancelListener);
                }
                if ((b = wp.getHelpButton()) != null) {
                    b.addActionListener(Wizard.this.helpListener);
                }
            }
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            if (e.getChild() instanceof WizardPage) {
                WizardPage wp = (WizardPage)e.getChild();
                JButton b = wp.getNextButton();
                if (b != null) {
                    b.removeActionListener(Wizard.this.nextListener);
                }
                if ((b = wp.getPreviousButton()) != null) {
                    b.removeActionListener(Wizard.this.previousListener);
                }
                if ((b = wp.getFinishButton()) != null) {
                    b.removeActionListener(Wizard.this.finishListener);
                }
                if ((b = wp.getCancelButton()) != null) {
                    b.removeActionListener(Wizard.this.cancelListener);
                }
                if ((b = wp.getHelpButton()) != null) {
                    b.removeActionListener(Wizard.this.helpListener);
                }
            }
        }
    };

    public Wizard() {
        this.setLayout(new CardLayout());
        this.cardLayout = (CardLayout)this.getLayout();
        this.addContainerListener(this.containerListener);
    }

    public void show(String name) {
        this.cardLayout.show(this, name);
    }

    public void first() {
        this.cardLayout.first(this);
    }

    public void last() {
        this.cardLayout.last(this);
    }

    public boolean next() {
        WizardListener listener;
        boolean is_last_page = false;
        Component current_page = null;
        Component next_page = null;
        int ncomponents = this.getComponentCount();
        for (int i = 0; i < ncomponents; ++i) {
            Component comp = this.getComponent(i);
            if (!comp.isVisible()) continue;
            current_page = comp;
            if (i == ncomponents - 1) {
                is_last_page = true;
                next_page = this.getComponent(0);
                break;
            }
            next_page = this.getComponent(i + 1);
            break;
        }
        WizardEvent event = new WizardEvent(this, current_page, next_page, is_last_page, !is_last_page);
        Enumeration<WizardListener> e = this.listeners.elements();
        while (e.hasMoreElements()) {
            listener = e.nextElement();
            listener.nextBegin(event);
        }
        if (!event.getAllowChange()) {
            return false;
        }
        if (next_page != event.getNewPage()) {
            this.cardLayout.show(this, event.getNewPage().getName());
        } else {
            this.cardLayout.next(this);
        }
        e = this.listeners.elements();
        while (e.hasMoreElements()) {
            listener = e.nextElement();
            listener.nextComplete(event);
        }
        return true;
    }

    public boolean previous() {
        WizardListener listener;
        boolean is_last_page = false;
        boolean is_first_page = false;
        Component current_page = null;
        Component previous_page = null;
        int ncomponents = this.getComponentCount();
        for (int i = 0; i < ncomponents; ++i) {
            Component comp = this.getComponent(i);
            if (!comp.isVisible()) continue;
            current_page = comp;
            if (i == ncomponents - 1) {
                is_last_page = true;
            }
            if (i == 0) {
                previous_page = this.getComponent(ncomponents - 1);
                is_first_page = true;
                break;
            }
            previous_page = this.getComponent(i - 1);
            break;
        }
        WizardEvent event = new WizardEvent(this, current_page, previous_page, is_last_page, !is_first_page);
        Enumeration<WizardListener> e = this.listeners.elements();
        while (e.hasMoreElements()) {
            listener = e.nextElement();
            listener.previousBegin(event);
        }
        if (!event.getAllowChange()) {
            return false;
        }
        if (previous_page != event.getNewPage()) {
            this.cardLayout.show(this, event.getNewPage().getName());
        } else {
            this.cardLayout.previous(this);
        }
        e = this.listeners.elements();
        while (e.hasMoreElements()) {
            listener = e.nextElement();
            listener.previousComplete(event);
        }
        return true;
    }

    public boolean finish() {
        boolean is_last_page = false;
        Component comp = this.getCurrentPage();
        if (comp == this.getComponent(this.getComponentCount() - 1)) {
            is_last_page = true;
        }
        WizardEvent event = new WizardEvent(this, comp, null, is_last_page, true);
        Enumeration<WizardListener> e = this.listeners.elements();
        while (e.hasMoreElements()) {
            WizardListener listener = e.nextElement();
            listener.finished(event);
        }
        return event.getAllowChange();
    }

    public boolean cancel() {
        boolean is_last_page = false;
        Component comp = this.getCurrentPage();
        if (comp == this.getComponent(this.getComponentCount() - 1)) {
            is_last_page = true;
        }
        WizardEvent event = new WizardEvent(this, comp, null, is_last_page, true);
        Enumeration<WizardListener> e = this.listeners.elements();
        while (e.hasMoreElements()) {
            WizardListener listener = e.nextElement();
            listener.canceled(event);
        }
        return event.getAllowChange();
    }

    public void help() {
        boolean is_last_page = false;
        Component comp = this.getCurrentPage();
        if (comp == this.getComponent(this.getComponentCount() - 1)) {
            is_last_page = true;
        }
        WizardEvent event = new WizardEvent(this, comp, null, is_last_page, true);
        Enumeration<WizardListener> e = this.listeners.elements();
        while (e.hasMoreElements()) {
            WizardListener listener = e.nextElement();
            listener.help(event);
        }
    }

    protected Component getCurrentPage() {
        int ncomponents = this.getComponentCount();
        for (int i = 0; i < ncomponents; ++i) {
            Component comp = this.getComponent(i);
            if (!comp.isVisible()) continue;
            return comp;
        }
        return null;
    }

    public void addWizardListener(WizardListener l) {
        if (this.listeners == null) {
            this.listeners = new Vector(3);
        }
        this.listeners.add(l);
    }

    public void removeWizardListener(WizardListener l) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(l);
    }

    @Override
    public Component add(Component page) {
        this.add(page, page.getName());
        return page;
    }
}

