/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.keyboard;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import org.tn5250j.Session5250;
import org.tn5250j.SessionPanel;
import org.tn5250j.event.KeyChangeListener;
import org.tn5250j.framework.tn5250.Screen5250;
import org.tn5250j.keyboard.DefaultKeyboardHandler;
import org.tn5250j.keyboard.KeyMapper;
import org.tn5250j.tools.system.OperatingSystem;

public abstract class KeyboardHandler
extends KeyAdapter
implements KeyChangeListener {
    protected Session5250 session;
    protected SessionPanel sessionGui;
    protected Screen5250 screen;
    protected boolean isLinux;
    protected boolean isAltGr;
    protected boolean keyProcessed = false;
    protected KeyMapper keyMap;
    protected String lastKeyStroke = null;
    protected StringBuffer recordBuffer;
    protected boolean recording;

    public KeyboardHandler(Session5250 session) {
        this.session = session;
        this.screen = session.getScreen();
        this.sessionGui = session.getGUI();
        this.isLinux = OperatingSystem.isUnix();
        this.keyMap = new KeyMapper();
        KeyMapper.init();
        KeyMapper.addKeyChangeListener(this);
        this.initKeyBindings();
    }

    public static KeyboardHandler getKeyboardHandlerInstance(Session5250 session) {
        return new DefaultKeyboardHandler(session);
    }

    abstract void initKeyBindings();

    protected InputMap getInputMap() {
        return this.sessionGui.getInputMap();
    }

    protected ActionMap getActionMap() {
        return this.sessionGui.getActionMap();
    }

    @Override
    public void onKeyChanged() {
        this.getInputMap().clear();
        this.getActionMap().clear();
        this.initKeyBindings();
    }

    public abstract boolean isKeyStrokeDefined(String var1);

    public abstract KeyStroke getKeyStroke(String var1);

    public String getRecordBuffer() {
        return this.recordBuffer.toString();
    }

    public void startRecording() {
        this.recording = true;
        this.recordBuffer = new StringBuffer();
    }

    public void stopRecording() {
        this.recording = false;
        this.recordBuffer = null;
    }

    public boolean isRecording() {
        return this.recording;
    }

    public void sessionClosed(SessionPanel session) {
        this.keyMap.removeKeyChangeListener(this);
    }

    protected boolean emulatorAction(KeyStroke ks, KeyEvent e) {
        if (this.sessionGui == null) {
            return false;
        }
        InputMap map = this.getInputMap();
        ActionMap am = this.getActionMap();
        if (map != null && am != null && this.sessionGui.isEnabled()) {
            Action action;
            Object binding = map.get(ks);
            Action action2 = action = binding == null ? null : am.get(binding);
            if (action != null) {
                return true;
            }
        }
        return false;
    }

    public void processKeyEvent(KeyEvent evt) {
        switch (evt.getID()) {
            case 400: {
                this.keyTyped(evt);
                break;
            }
            case 401: {
                this.keyPressed(evt);
                break;
            }
            case 402: {
                this.keyReleased(evt);
            }
        }
    }
}

