/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.keyboard.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import org.tn5250j.SessionPanel;
import org.tn5250j.interfaces.OptionAccessFactory;
import org.tn5250j.keyboard.KeyMapper;

public abstract class EmulatorAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    protected SessionPanel session;

    public EmulatorAction(SessionPanel session, String name) {
        super(name);
        this.session = session;
    }

    public EmulatorAction(SessionPanel session, String name, KeyStroke ks, KeyMapper keyMap) {
        this(session, name);
        this.setKeyStroke(name, ks, keyMap);
    }

    protected void setKeyStroke(String action, KeyStroke ks, KeyMapper keyMap) {
        if (OptionAccessFactory.getInstance().isRestrictedOption(action)) {
            return;
        }
        if (KeyMapper.isKeyStrokeDefined(action)) {
            ks = KeyMapper.getKeyStroke(action);
        }
        this.session.getInputMap().put(ks, action);
        this.session.getActionMap().put(action, this);
        if (KeyMapper.isKeyStrokeDefined(action + ".alt2")) {
            ks = KeyMapper.getKeyStroke(action + ".alt2");
            this.session.getInputMap().put(ks, action);
            this.session.getActionMap().put(action, this);
        }
    }

    @Override
    public abstract void actionPerformed(ActionEvent var1);
}

