/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.keyboard.configure;

import java.awt.event.KeyEvent;
import org.tn5250j.keyboard.configure.KeyGetterInterface;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

public class KeyGetter
extends KeyGetterInterface {
    private static final long serialVersionUID = 1691732474472874354L;
    private static final transient TN5250jLogger LOG = TN5250jLogFactory.getLogger(KeyGetter.class);

    private void displayInfo(KeyEvent e) {
        String typeStr;
        switch (e.getID()) {
            case 401: {
                typeStr = "KEY_PRESSED";
                break;
            }
            case 402: {
                typeStr = "KEY_RELEASED";
                break;
            }
            case 400: {
                typeStr = "KEY_TYPED";
                break;
            }
            default: {
                typeStr = "unknown type";
            }
        }
        char c = e.getKeyChar();
        int keyCode = e.getKeyCode();
        int modifiers = e.getModifiers();
        int location = e.getKeyLocation();
        String charString = Character.isISOControl(c) ? "key character = (an unprintable control character)" : "key character = '" + c + "'";
        String keyCodeString = "key code = " + keyCode + " (" + KeyEvent.getKeyText(keyCode) + ")";
        if (keyCode == 257) {
            keyCodeString = keyCodeString + " previous candidate ";
        }
        if (keyCode == 134 || keyCode == 136 || keyCode == 129 || keyCode == 133 || keyCode == 130) {
            keyCodeString = keyCodeString + " dead key ";
        }
        String modString = "modifiers = " + modifiers;
        String tmpString = KeyEvent.getKeyModifiersText(modifiers);
        modString = tmpString.length() > 0 ? modString + " (" + tmpString + ")" : modString + " (no modifiers)";
        String locString = "location = (UNKNOWN)";
        switch (location) {
            case 2: {
                locString = "location = " + location + " (LEFT)";
                break;
            }
            case 4: {
                locString = "location = " + location + " (NUM_PAD)";
                break;
            }
            case 3: {
                locString = "location = " + location + " (RIGHT)";
                break;
            }
            case 1: {
                locString = "location = " + location + " (STANDARD)";
                break;
            }
            default: {
                locString = "location = " + location + " (UNKNOWN)";
            }
        }
        String isString = "isKeys = isActionKey (" + e.isActionKey() + ") isAltDown (" + e.isAltDown() + ") isAltGraphDown (" + e.isAltGraphDown() + ") isAltGraphDownLinux (" + this.isAltGr + ") isControlDown (" + e.isControlDown() + ") isMetaDown (" + e.isMetaDown() + ") isShiftDown (" + e.isShiftDown() + ")";
        if (LOG.isDebugEnabled()) {
            LOG.debug(typeStr + "\n    " + charString + "\n    " + keyCodeString + "\n    " + modString + "\n    " + locString + "\n    " + isString + "\n");
        }
    }

    @Override
    void processVTKeyPressed(KeyEvent e) {
        this.displayInfo(e);
        int keyCode = e.getKeyCode();
        if (this.isLinux && keyCode == 65406) {
            this.isAltGr = true;
        }
        if (keyCode == 0 || keyCode == 20 || keyCode == 16 || keyCode == 18 || keyCode == 65406 || keyCode == 17) {
            return;
        }
        if (!e.isAltDown() || !e.isShiftDown() || !e.isControlDown() || keyCode != 17 && !e.isActionKey()) {
            this.keyevent = e;
            this.dialog.setVisible(false);
            this.dialog.dispose();
        }
    }

    @Override
    void processVTKeyTyped(KeyEvent e) {
        this.displayInfo(e);
        int keycode = e.getKeyCode();
        if (e.isAltDown() || e.isShiftDown() || e.isControlDown() || e.isActionKey() || keycode == 17) {
            this.keyevent = e;
            this.dialog.setVisible(false);
            this.dialog.dispose();
        }
    }

    @Override
    void processVTKeyReleased(KeyEvent e) {
        this.displayInfo(e);
        if (this.isLinux && e.getKeyCode() == 65406) {
            this.isAltGr = false;
        }
        int keycode = e.getKeyCode();
        if (e.isAltDown() || e.isShiftDown() || e.isControlDown() || e.isActionKey() || keycode == 17) {
            this.keyevent = e;
            this.dialog.setVisible(false);
            this.dialog.dispose();
        }
    }
}

