/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.mailtools;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.tn5250j.SessionConfig;
import org.tn5250j.SessionPanel;
import org.tn5250j.framework.tn5250.Screen5250;
import org.tn5250j.gui.GenericTn5250JFrame;
import org.tn5250j.gui.TN5250jFileChooser;
import org.tn5250j.mailtools.SMTPConfig;
import org.tn5250j.mailtools.SendEMail;
import org.tn5250j.tools.LangTool;
import org.tn5250j.tools.encoder.EncodeComponent;

public class SendEMailDialog
extends GenericTn5250JFrame
implements Runnable {
    private static final long serialVersionUID = 1L;
    JComboBox toAddress;
    JTextField subject;
    JTextArea bodyText;
    JTextField attachmentName;
    SessionConfig config;
    SessionPanel session;
    String fileName;
    JRadioButton text;
    JRadioButton graphic;
    GridBagConstraints gbc;
    JRadioButton normal;
    JRadioButton screenshot;
    JButton browse;
    boolean sendScreen;
    SendEMail sendEMail;
    Thread myThread = new Thread(this);

    public SendEMailDialog(Frame parent, SessionPanel session) {
        this(parent, session, true);
    }

    public SendEMailDialog(Frame parent, SessionPanel session, boolean sendScreen) {
        if (!this.isEMailAvailable()) {
            JOptionPane.showMessageDialog(parent, LangTool.getString("messages.noEmailAPI"), "Error", 0, null);
        } else {
            this.session = session;
            Screen5250 screen = session.getScreen();
            this.sendScreen = sendScreen;
            Object[] message = new Object[]{this.setupMailPanel("tn5250j.txt")};
            Object[] options = new String[3];
            int result = 0;
            block7: while (result == 0 || result == 2) {
                this.setOptions((String[])options);
                result = JOptionPane.showOptionDialog(parent, message, LangTool.getString("em.title"), -1, -1, null, options, options[0]);
                switch (result) {
                    case 0: {
                        this.sendEMail = new SendEMail();
                        this.sendEMail.setConfigFile("SMTPProperties.cfg");
                        this.sendEMail.setTo((String)this.toAddress.getSelectedItem());
                        this.sendEMail.setSubject(this.subject.getText());
                        if (this.bodyText.getText().length() > 0) {
                            this.sendEMail.setMessage(this.bodyText.getText());
                        }
                        if (this.attachmentName.getText().length() > 0) {
                            if (!this.normal.isSelected()) {
                                this.sendEMail.setAttachmentName(this.attachmentName.getText());
                            } else {
                                this.sendEMail.setAttachmentName(this.fileName);
                            }
                        }
                        if (this.text.isSelected()) {
                            int len = screen.getScreenLength();
                            char[] screenTxt = new char[len];
                            char[] screenExtendedAttr = new char[len];
                            char[] screenAttrPlace = new char[len];
                            screen.GetScreen(screenTxt, len, 1);
                            screen.GetScreen(screenExtendedAttr, len, 4);
                            screen.GetScreen(screenAttrPlace, len, 8);
                            StringBuffer sb = new StringBuffer();
                            int c = screen.getColumns();
                            int l = screen.getRows() * c;
                            int col = 0;
                            int x = 0;
                            while (x < l) {
                                if (screenTxt[x] >= ' ' && (screenExtendedAttr[x] & '\u0001') == 0) {
                                    if ((screenExtendedAttr[x] & 8) != 0 && screenAttrPlace[x] != '\u0001') {
                                        sb.append('_');
                                    } else {
                                        sb.append(screenTxt[x]);
                                    }
                                } else if ((screenExtendedAttr[x] & 8) != 0 && screenAttrPlace[x] != '\u0001') {
                                    sb.append('_');
                                } else {
                                    sb.append(' ');
                                }
                                if (col == c) {
                                    sb.append('\n');
                                    col = 0;
                                }
                                ++x;
                                ++col;
                            }
                            this.sendEMail.setAttachment(sb.toString());
                        } else if (this.graphic.isSelected()) {
                            File dir = new File(System.getProperty("user.dir"));
                            String tempFile = "tn5250jTemp";
                            try {
                                File f = File.createTempFile(tempFile, ".png", dir);
                                System.out.println(f.getName());
                                System.out.println(f.getCanonicalPath());
                                f.deleteOnExit();
                                EncodeComponent.encode(EncodeComponent.PNG, (Component)session, f);
                                this.sendEMail.setFileName(f.getName());
                            }
                            catch (Exception ex) {
                                System.out.println(ex.getMessage());
                            }
                        } else if (this.attachmentName.getText().length() > 0) {
                            File f = new File(this.attachmentName.getText());
                            this.sendEMail.setFileName(f.toString());
                        }
                        this.sendIt(parent, this.sendEMail);
                        continue block7;
                    }
                    case 1: {
                        continue block7;
                    }
                    case 2: {
                        this.configureSMTP(parent);
                        continue block7;
                    }
                }
            }
        }
    }

    public SendEMailDialog(Frame parent, SessionPanel session, String fileName) {
        if (!this.isEMailAvailable()) {
            JOptionPane.showMessageDialog(parent, LangTool.getString("messages.noEmailAPI"), "Error", 0, null);
        } else {
            this.session = session;
            Object[] message = new Object[]{this.setupMailPanel(fileName)};
            Object[] options = new String[3];
            int result = 0;
            block5: while (result == 0 || result == 2) {
                this.setOptions((String[])options);
                result = JOptionPane.showOptionDialog(parent, message, LangTool.getString("em.titleFileTransfer"), -1, -1, null, options, options[0]);
                switch (result) {
                    case 0: {
                        this.sendEMail = new SendEMail();
                        this.sendEMail.setConfigFile("SMTPProperties.cfg");
                        this.sendEMail.setTo((String)this.toAddress.getSelectedItem());
                        this.sendEMail.setSubject(this.subject.getText());
                        if (this.bodyText.getText().length() > 0) {
                            this.sendEMail.setMessage(this.bodyText.getText());
                        }
                        if (this.attachmentName.getText().length() > 0) {
                            this.sendEMail.setAttachmentName(this.attachmentName.getText());
                        }
                        if (fileName != null && fileName.length() > 0) {
                            this.sendEMail.setFileName(fileName);
                        }
                        this.sendIt(parent, this.sendEMail);
                        continue block5;
                    }
                    case 1: {
                        continue block5;
                    }
                    case 2: {
                        this.configureSMTP(parent);
                        continue block5;
                    }
                }
            }
        }
    }

    private void sendIt(Frame parent, SendEMail sem) {
        this.myThread.start();
    }

    public void setSendEMail(SendEMail sem) {
        this.sendEMail = sem;
    }

    @Override
    public void run() {
        try {
            if (this.sendEMail.send()) {
                this.sendEMail.release();
                this.sendEMail = null;
                JOptionPane.showMessageDialog(null, LangTool.getString("em.confirmationMessage") + " " + (String)this.toAddress.getSelectedItem(), LangTool.getString("em.titleConfirmation"), 1);
                if (this.session != null) {
                    this.config.setProperty("emailTo", this.getToTokens(this.config.getStringProperty("emailTo"), this.toAddress));
                    this.config.saveSessionProps();
                    this.setToCombo(this.config.getStringProperty("emailTo"), this.toAddress);
                }
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void configureSMTP(Frame parent) {
        if (parent == null) {
            parent = new JFrame();
        }
        SMTPConfig smtp = new SMTPConfig(parent, "", true);
        smtp.setVisible(true);
        smtp.dispose();
    }

    private JPanel setupMailPanel(String fileName) {
        JPanel semp = new JPanel();
        semp.setLayout(new GridBagLayout());
        this.text = new JRadioButton(LangTool.getString("em.text"));
        this.graphic = new JRadioButton(LangTool.getString("em.graphic"));
        this.normal = new JRadioButton(LangTool.getString("em.normalmail"), true);
        this.screenshot = new JRadioButton(LangTool.getString("em.screenshot"));
        ButtonGroup tGroup = new ButtonGroup();
        tGroup.add(this.text);
        tGroup.add(this.graphic);
        ButtonGroup mGroup = new ButtonGroup();
        mGroup.add(this.normal);
        mGroup.add(this.screenshot);
        this.text.setSelected(false);
        this.text.setEnabled(false);
        this.graphic.setEnabled(false);
        JLabel screenDump = new JLabel(LangTool.getString("em.screendump"));
        JLabel tol = new JLabel(LangTool.getString("em.to"));
        JLabel subl = new JLabel(LangTool.getString("em.subject"));
        JLabel bodyl = new JLabel(LangTool.getString("em.body"));
        JLabel fnl = new JLabel(LangTool.getString("em.fileName"));
        JLabel tom = new JLabel(LangTool.getString("em.typeofmail"));
        this.browse = new JButton(LangTool.getString("em.choosefile"));
        this.browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SendEMailDialog.this.browse_actionPerformed(e);
            }
        });
        this.toAddress = new JComboBox();
        this.toAddress.setPreferredSize(new Dimension(175, 25));
        this.toAddress.setEditable(true);
        this.subject = new JTextField(30);
        this.bodyText = new JTextArea(6, 30);
        JScrollPane bodyScrollPane = new JScrollPane(this.bodyText);
        bodyScrollPane.setHorizontalScrollBarPolicy(30);
        bodyScrollPane.setVerticalScrollBarPolicy(20);
        this.attachmentName = new JTextField(fileName, 30);
        if (fileName != null && fileName.length() > 0) {
            this.attachmentName.setText(fileName);
        } else {
            this.attachmentName.setText("");
        }
        this.text.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SendEMailDialog.this.setAttachmentName();
            }
        });
        this.normal.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SendEMailDialog.this.setTypeOfMail();
            }
        });
        if (this.sendScreen) {
            this.screenshot.setSelected(true);
        } else {
            this.normal.setSelected(true);
        }
        this.config = null;
        if (this.session != null) {
            this.config = this.session.getSession().getConfiguration();
            if (this.config.isPropertyExists("emailTo")) {
                this.setToCombo(this.config.getStringProperty("emailTo"), this.toAddress);
            }
        }
        semp.setBorder(BorderFactory.createEtchedBorder());
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 10, 5, 5);
        semp.add((Component)tom, this.gbc);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 0;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 15, 5, 5);
        semp.add((Component)this.normal, this.gbc);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 2;
        this.gbc.gridy = 0;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 45, 5, 10);
        semp.add((Component)this.screenshot, this.gbc);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(0, 10, 5, 5);
        semp.add((Component)screenDump, this.gbc);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 1;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(0, 15, 5, 5);
        semp.add((Component)this.text, this.gbc);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 2;
        this.gbc.gridy = 1;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(0, 45, 5, 10);
        semp.add((Component)this.graphic, this.gbc);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 2;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 10, 5, 5);
        semp.add((Component)tol, this.gbc);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 2;
        this.gbc.gridwidth = 2;
        this.gbc.fill = 2;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 5, 5, 10);
        semp.add((Component)this.toAddress, this.gbc);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 3;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 10, 5, 5);
        semp.add((Component)subl, this.gbc);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 3;
        this.gbc.gridwidth = 2;
        this.gbc.fill = 2;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 5, 5, 10);
        semp.add((Component)this.subject, this.gbc);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 4;
        this.gbc.gridheight = 3;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 10, 5, 5);
        semp.add((Component)bodyl, this.gbc);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 4;
        this.gbc.gridwidth = 2;
        this.gbc.gridheight = 3;
        this.gbc.fill = 2;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 5, 5, 10);
        semp.add((Component)bodyScrollPane, this.gbc);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 7;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 10, 5, 5);
        semp.add((Component)fnl, this.gbc);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 7;
        this.gbc.gridwidth = 2;
        this.gbc.fill = 2;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 5, 5, 10);
        semp.add((Component)this.attachmentName, this.gbc);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 8;
        this.gbc.gridwidth = 2;
        this.gbc.anchor = 10;
        this.gbc.insets = new Insets(5, 5, 10, 10);
        semp.add((Component)this.browse, this.gbc);
        return semp;
    }

    private void browse_actionPerformed(ActionEvent e) {
        String workingDir = System.getProperty("user.dir");
        TN5250jFileChooser pcFileChooser = new TN5250jFileChooser(workingDir);
        int ret = pcFileChooser.showOpenDialog(new JFrame());
        if (ret == 0) {
            File file = pcFileChooser.getSelectedFile();
            this.fileName = file.getName();
            this.attachmentName.setText(file.toString());
        }
    }

    private void setAttachmentName() {
        if (this.text.isSelected()) {
            this.attachmentName.setText("tn5250j.txt");
        } else if (this.normal.isSelected()) {
            this.attachmentName.setText("tn5250j.png");
        } else {
            this.attachmentName.setText("tn5250j.png");
        }
    }

    private void setTypeOfMail() {
        if (this.normal.isSelected()) {
            this.text.setEnabled(false);
            this.graphic.setEnabled(false);
            this.attachmentName.setText("");
            this.browse.setEnabled(true);
        } else {
            this.text.setEnabled(true);
            this.graphic.setEnabled(true);
            this.text.setSelected(true);
            this.setAttachmentName();
            this.browse.setEnabled(false);
        }
    }

    private void setOptions(String[] options) {
        options[0] = LangTool.getString("em.optSendLabel");
        options[1] = LangTool.getString("em.optCancelLabel");
        File smtp = new File("SMTPProperties.cfg");
        options[2] = smtp.exists() ? LangTool.getString("em.optEditLabel") : LangTool.getString("em.optConfigureLabel");
    }

    private void setToCombo(String to, JComboBox boxen) {
        StringTokenizer tokenizer = new StringTokenizer(to, "|");
        boxen.removeAllItems();
        while (tokenizer.hasMoreTokens()) {
            boxen.addItem(tokenizer.nextToken());
        }
    }

    private String getToTokens(String to, JComboBox boxen) {
        StringBuffer sb = new StringBuffer();
        String selected = (String)boxen.getSelectedItem();
        sb.append(selected + '|');
        int c = boxen.getItemCount();
        for (int x = 0; x < c; ++x) {
            if (selected.equals(boxen.getItemAt(x))) continue;
            sb.append((String)boxen.getItemAt(x) + '|');
        }
        return sb.toString();
    }

    private boolean isEMailAvailable() {
        try {
            Class.forName("javax.mail.Message");
            return true;
        }
        catch (Exception ex) {
            System.out.println(" not there " + ex.getMessage());
            return false;
        }
    }
}

