/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.scripting;

import java.util.HashMap;
import java.util.Map;
import org.tn5250j.SessionPanel;
import org.tn5250j.scripting.InterpreterDriver;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

public class InterpreterDriverManager {
    private static final transient TN5250jLogger LOG = TN5250jLogFactory.getLogger(InterpreterDriverManager.class);
    private static Map<String, InterpreterDriver> _extensionDriverMap = new HashMap<String, InterpreterDriver>();
    private static Map<String, InterpreterDriver> _languageDriverMap = new HashMap<String, InterpreterDriver>();
    private static final char EXTENSION_SEPARATOR = '.';

    private InterpreterDriverManager() {
    }

    public static void registerDriver(InterpreterDriver driver) {
        String[] extensions = driver.getSupportedExtensions();
        int size = extensions.length;
        for (int i = 0; i < size; ++i) {
            _extensionDriverMap.put(extensions[i], driver);
        }
        String[] languages = driver.getSupportedLanguages();
        int size2 = languages.length;
        for (int i = 0; i < size2; ++i) {
            _languageDriverMap.put(languages[i], driver);
        }
    }

    public static void executeScript(SessionPanel session, String script, String language) throws InterpreterDriver.InterpreterException {
        InterpreterDriver driver = _languageDriverMap.get(language);
        if (driver == null) {
            LOG.warn("No driver installed to handle language " + language);
            return;
        }
        driver.executeScript(session, script);
    }

    public static void executeScriptFile(SessionPanel session, String scriptFile) throws InterpreterDriver.InterpreterException {
        String extension = scriptFile.substring(scriptFile.lastIndexOf(46) + 1);
        InterpreterDriver driver = _extensionDriverMap.get(extension);
        if (driver == null) {
            LOG.warn("No driver installed to handle extension " + extension);
            return;
        }
        driver.executeScriptFile(session, scriptFile);
    }

    public static void executeScriptFile(String scriptFile) throws InterpreterDriver.InterpreterException {
        String extension = scriptFile.substring(scriptFile.lastIndexOf(46) + 1);
        InterpreterDriver driver = _extensionDriverMap.get(extension);
        if (driver == null) {
            LOG.warn("No driver installed to handle extension " + extension);
            return;
        }
        driver.executeScriptFile(scriptFile);
    }

    public static boolean isScriptSupported(String scriptFile) {
        String extension = scriptFile.substring(scriptFile.lastIndexOf(46) + 1);
        return _extensionDriverMap.containsKey(extension);
    }
}

