/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.scripting;

import java.io.File;
import javax.swing.JOptionPane;
import org.python.core.PyException;
import org.python.core.PySyntaxError;
import org.python.util.PythonInterpreter;
import org.tn5250j.SessionPanel;
import org.tn5250j.scripting.InterpreterDriver;
import org.tn5250j.scripting.InterpreterDriverManager;

public class JPythonInterpreterDriver
implements InterpreterDriver {
    private static JPythonInterpreterDriver _instance;
    private PythonInterpreter _interpreter;

    JPythonInterpreterDriver() {
        try {
            this._interpreter = new PythonInterpreter();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void executeScript(SessionPanel session, String script) throws InterpreterDriver.InterpreterException {
        try {
            session.setMacroRunning(true);
            this._interpreter.set("_session", (Object)session);
            this._interpreter.exec(script);
            session.setMacroRunning(false);
        }
        catch (PyException ex) {
            throw new InterpreterDriver.InterpreterException((Exception)((Object)ex));
        }
    }

    public void executeScript(String script) throws InterpreterDriver.InterpreterException {
        try {
            this._interpreter = new PythonInterpreter();
            this._interpreter.exec(script);
        }
        catch (PyException ex) {
            throw new InterpreterDriver.InterpreterException((Exception)((Object)ex));
        }
    }

    @Override
    public void executeScriptFile(SessionPanel session, String scriptFile) throws InterpreterDriver.InterpreterException {
        try {
            final SessionPanel s1 = session;
            final String s2 = scriptFile;
            s1.setMacroRunning(true);
            Runnable interpretIt = new Runnable(){

                @Override
                public void run() {
                    JPythonInterpreterDriver.this._interpreter = new PythonInterpreter();
                    JPythonInterpreterDriver.this._interpreter.set("_session", (Object)s1);
                    try {
                        JPythonInterpreterDriver.this._interpreter.execfile(s2);
                    }
                    catch (PySyntaxError pse) {
                        JOptionPane.showMessageDialog(s1, (Object)pse, "Error in script " + s2, 0);
                    }
                    catch (PyException pse) {
                        JOptionPane.showMessageDialog(s1, (Object)pse, "Error in script " + s2, 0);
                    }
                    finally {
                        s1.setMacroRunning(false);
                    }
                }
            };
            Thread interpThread = new Thread(interpretIt);
            interpThread.setDaemon(true);
            interpThread.start();
        }
        catch (PyException ex) {
            throw new InterpreterDriver.InterpreterException((Exception)((Object)ex));
        }
        catch (Exception ex2) {
            throw new InterpreterDriver.InterpreterException(ex2);
        }
    }

    @Override
    public void executeScriptFile(String scriptFile) throws InterpreterDriver.InterpreterException {
        try {
            this._interpreter.execfile(scriptFile);
        }
        catch (PyException ex) {
            throw new InterpreterDriver.InterpreterException((Exception)((Object)ex));
        }
    }

    @Override
    public String[] getSupportedExtensions() {
        return new String[]{"py"};
    }

    @Override
    public String[] getSupportedLanguages() {
        return new String[]{"Python", "JPython"};
    }

    public static void main(String[] args) {
        try {
            _instance.executeScript("print \"Hello\"");
            _instance.executeScriptFile("test.py");
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
    }

    static {
        System.setProperty("python.cachedir", System.getProperty("user.home") + File.separator + ".tn5250j" + File.separator);
        try {
            _instance = new JPythonInterpreterDriver();
        }
        catch (Exception exception) {
            // empty catch block
        }
        InterpreterDriverManager.registerDriver(_instance);
    }
}

